/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.analyzer;

import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassAnalysisCache;
import org.gradle.api.internal.tasks.compile.incremental.analyzer.ClassDependenciesAnalyzer;
import org.gradle.api.internal.tasks.compile.incremental.deps.ClassAnalysis;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashCode;

public class CachingClassDependenciesAnalyzer
implements ClassDependenciesAnalyzer {
    private final ClassDependenciesAnalyzer analyzer;
    private final ClassAnalysisCache cache;

    public CachingClassDependenciesAnalyzer(ClassDependenciesAnalyzer analyzer, ClassAnalysisCache cache) {
        this.analyzer = analyzer;
        this.cache = cache;
    }

    @Override
    public ClassAnalysis getClassAnalysis(final HashCode classFileHash, final FileTreeElement classFile) {
        return this.cache.get(classFileHash, new Factory<ClassAnalysis>(){

            @Override
            public ClassAnalysis create() {
                return CachingClassDependenciesAnalyzer.this.analyzer.getClassAnalysis(classFileHash, classFile);
            }
        });
    }
}

