/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.classpath;

import java.io.File;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshot;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotCache;
import org.gradle.api.internal.tasks.compile.incremental.classpath.ClasspathEntrySnapshotData;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.internal.MinimalPersistentCache;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.snapshot.CompleteFileSystemLocationSnapshot;
import org.gradle.internal.vfs.VirtualFileSystem;

public class DefaultClasspathEntrySnapshotCache
implements ClasspathEntrySnapshotCache {
    private final VirtualFileSystem virtualFileSystem;
    private final MinimalPersistentCache<HashCode, ClasspathEntrySnapshotData> cache;

    public DefaultClasspathEntrySnapshotCache(VirtualFileSystem virtualFileSystem, PersistentIndexedCache<HashCode, ClasspathEntrySnapshotData> persistentCache) {
        this.virtualFileSystem = virtualFileSystem;
        this.cache = new MinimalPersistentCache<HashCode, ClasspathEntrySnapshotData>(persistentCache);
    }

    @Override
    public ClasspathEntrySnapshot get(File file, HashCode hash) {
        ClasspathEntrySnapshotData data = this.cache.get(hash);
        return data != null ? new ClasspathEntrySnapshot(data) : null;
    }

    @Override
    public ClasspathEntrySnapshot get(File key, Factory<ClasspathEntrySnapshot> factory) {
        HashCode fileContentHash = this.virtualFileSystem.read(key.getAbsolutePath(), CompleteFileSystemLocationSnapshot::getHash);
        return new ClasspathEntrySnapshot(this.cache.get(fileContentHash, () -> ((ClasspathEntrySnapshot)factory.create()).getData()));
    }
}

