/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.plugins.GroovyBasePlugin;
import org.gradle.api.plugins.quality.CodeNarc;
import org.gradle.api.plugins.quality.CodeNarcExtension;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.internal.AbstractCodeQualityPlugin;
import org.gradle.api.reporting.SingleFileReport;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.SourceSet;
import org.gradle.internal.impldep.com.google.common.util.concurrent.Callables;
import org.gradle.internal.metaobject.DynamicObject;

public class CodeNarcPlugin
extends AbstractCodeQualityPlugin<CodeNarc> {
    public static final String DEFAULT_CODENARC_VERSION = "1.4";
    private CodeNarcExtension extension;

    @Override
    protected String getToolName() {
        return "CodeNarc";
    }

    @Override
    protected Class<CodeNarc> getTaskType() {
        return CodeNarc.class;
    }

    @Override
    protected Class<? extends Plugin> getBasePlugin() {
        return GroovyBasePlugin.class;
    }

    @Override
    protected CodeQualityExtension createExtension() {
        this.extension = this.project.getExtensions().create("codenarc", CodeNarcExtension.class, this.project);
        this.extension.setToolVersion(DEFAULT_CODENARC_VERSION);
        this.extension.setConfig(this.project.getResources().getText().fromFile(this.project.getRootProject().file("config/codenarc/codenarc.xml")));
        this.extension.setMaxPriority1Violations(0);
        this.extension.setMaxPriority2Violations(0);
        this.extension.setMaxPriority3Violations(0);
        this.extension.setReportFormat("html");
        return this.extension;
    }

    @Override
    protected void configureConfiguration(Configuration configuration) {
        this.configureDefaultDependencies(configuration);
    }

    @Override
    protected void configureTaskDefaults(CodeNarc task, String baseName) {
        Configuration configuration = this.project.getConfigurations().getAt(this.getConfigurationName());
        this.configureTaskConventionMapping(configuration, task);
        this.configureReportsConventionMapping(task, baseName);
    }

    private void configureDefaultDependencies(Configuration configuration) {
        configuration.defaultDependencies((Action<? super DependencySet>)new Action<DependencySet>(){

            @Override
            public void execute(DependencySet dependencies) {
                dependencies.add(CodeNarcPlugin.this.project.getDependencies().create("org.codenarc:CodeNarc:" + CodeNarcPlugin.this.extension.getToolVersion()));
            }
        });
    }

    private void configureTaskConventionMapping(Configuration configuration, CodeNarc task) {
        ConventionMapping taskMapping = task.getConventionMapping();
        taskMapping.map("codenarcClasspath", Callables.returning((Object)configuration));
        taskMapping.map("config", new Callable<TextResource>(){

            @Override
            public TextResource call() {
                return CodeNarcPlugin.this.extension.getConfig();
            }
        });
        taskMapping.map("maxPriority1Violations", new Callable<Integer>(){

            @Override
            public Integer call() {
                return CodeNarcPlugin.this.extension.getMaxPriority1Violations();
            }
        });
        taskMapping.map("maxPriority2Violations", new Callable<Integer>(){

            @Override
            public Integer call() {
                return CodeNarcPlugin.this.extension.getMaxPriority2Violations();
            }
        });
        taskMapping.map("maxPriority3Violations", new Callable<Integer>(){

            @Override
            public Integer call() {
                return CodeNarcPlugin.this.extension.getMaxPriority3Violations();
            }
        });
        taskMapping.map("ignoreFailures", new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return CodeNarcPlugin.this.extension.isIgnoreFailures();
            }
        });
    }

    private void configureReportsConventionMapping(CodeNarc task, final String baseName) {
        task.getReports().all(new Action<SingleFileReport>(){

            @Override
            public void execute(SingleFileReport report) {
                report.getRequired().convention(CodeNarcPlugin.this.project.getProviders().provider(() -> report.getName().equals(CodeNarcPlugin.this.extension.getReportFormat())));
                report.getOutputLocation().convention(CodeNarcPlugin.this.project.getLayout().getProjectDirectory().file(CodeNarcPlugin.this.project.provider(() -> {
                    String fileSuffix = report.getName().equals("text") ? "txt" : report.getName();
                    return new File(CodeNarcPlugin.this.extension.getReportsDir(), baseName + "." + fileSuffix).getAbsolutePath();
                })));
            }
        });
    }

    @Override
    protected void configureForSourceSet(SourceSet sourceSet, CodeNarc task) {
        task.setDescription("Run CodeNarc analysis for " + sourceSet.getName() + " classes");
        DynamicObject dynamicObject = new DslObject(sourceSet).getAsDynamicObject();
        task.setSource(dynamicObject.getProperty("allGroovy"));
    }
}

