/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Buildable;
import org.gradle.api.DefaultTask;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.publish.Publication;
import org.gradle.api.publish.internal.GradleModuleMetadataWriter;
import org.gradle.api.publish.internal.PublicationInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.Cast;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.scopeids.id.BuildInvocationScopeId;

public class GenerateModuleMetadata
extends DefaultTask {
    private final Property<Publication> publication;
    private final ListProperty<Publication> publications;
    private final RegularFileProperty outputFile;
    private final ChecksumService checksumService;

    public GenerateModuleMetadata() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.publication = objectFactory.property(Publication.class);
        this.publications = objectFactory.listProperty(Publication.class);
        this.outputFile = objectFactory.fileProperty();
        this.getOutputs().upToDateWhen(Specs.satisfyNone());
        this.mustHaveAttachedComponent();
        this.checksumService = ((ProjectInternal)this.getProject()).getServices().get(ChecksumService.class);
    }

    private void mustHaveAttachedComponent() {
        this.setOnlyIf((Spec<? super Task>)new Spec<Task>(){

            @Override
            public boolean isSatisfiedBy(Task element) {
                PublicationInternal publication = (PublicationInternal)GenerateModuleMetadata.this.publication.get();
                if (publication.getComponent() == null) {
                    GenerateModuleMetadata.this.getLogger().warn(publication.getDisplayName() + " isn't attached to a component. Gradle metadata only supports publications with software components (e.g. from component.java)");
                    return false;
                }
                return true;
            }
        });
    }

    @Internal
    public Property<Publication> getPublication() {
        return this.publication;
    }

    @Internal
    public ListProperty<Publication> getPublications() {
        return this.publications;
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    FileCollection getArtifacts() {
        return this.getFileCollectionFactory().create(new VariantFiles());
    }

    @Inject
    protected FileCollectionFactory getFileCollectionFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected BuildInvocationScopeId getBuildInvocationScopeId() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ProjectDependencyPublicationResolver getProjectDependencyPublicationResolver() {
        throw new UnsupportedOperationException();
    }

    @OutputFile
    public RegularFileProperty getOutputFile() {
        return this.outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    void run() {
        File file = ((RegularFile)this.outputFile.get()).getAsFile();
        PublicationInternal publication = (PublicationInternal)this.publication.get();
        List publications = (List)Cast.uncheckedCast(this.publications.get());
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf8"));){
            new GradleModuleMetadataWriter(this.getBuildInvocationScopeId(), this.getProjectDependencyPublicationResolver(), this.checksumService).generateTo(publication, publications, writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not generate metadata file " + this.outputFile.get(), e);
        }
    }

    private class VariantFiles
    implements MinimalFileSet,
    Buildable {
        private VariantFiles() {
        }

        @Override
        public TaskDependency getBuildDependencies() {
            PublicationInternal publication = (PublicationInternal)GenerateModuleMetadata.this.publication.get();
            SoftwareComponentInternal component = publication.getComponent();
            DefaultTaskDependency dependency = new DefaultTaskDependency();
            if (component == null) {
                return dependency;
            }
            for (UsageContext usageContext : component.getUsages()) {
                for (PublishArtifact publishArtifact : usageContext.getArtifacts()) {
                    dependency.add(publishArtifact);
                }
            }
            return dependency;
        }

        @Override
        public Set<File> getFiles() {
            PublicationInternal publication = (PublicationInternal)GenerateModuleMetadata.this.publication.get();
            SoftwareComponentInternal component = publication.getComponent();
            if (component == null) {
                return ImmutableSet.of();
            }
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            for (UsageContext usageContext : component.getUsages()) {
                for (PublishArtifact publishArtifact : usageContext.getArtifacts()) {
                    files.add(publishArtifact.getFile());
                }
            }
            return files;
        }

        @Override
        public String getDisplayName() {
            return "files of " + GenerateModuleMetadata.this.getPath();
        }
    }
}

