/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.services.internal;

import javax.annotation.Nullable;
import org.gradle.api.internal.provider.AbstractReadOnlyProvider;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.api.services.internal.ServiceLifecycleException;
import org.gradle.internal.Try;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.isolation.IsolatableFactory;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.state.Managed;

public class BuildServiceProvider<T extends BuildService<P>, P extends BuildServiceParameters>
extends AbstractReadOnlyProvider<T>
implements Managed {
    private final String name;
    private final Class<T> implementationType;
    private final InstantiationScheme instantiationScheme;
    private final IsolatableFactory isolatableFactory;
    private final Class<P> parametersType;
    private final P parameters;
    private Try<T> instance;

    public BuildServiceProvider(String name, Class<T> implementationType, Class<P> parametersType, @Nullable P parameters, InstantiationScheme instantiationScheme, IsolatableFactory isolatableFactory) {
        this.name = name;
        this.implementationType = implementationType;
        this.parametersType = parametersType;
        this.parameters = parameters;
        this.instantiationScheme = instantiationScheme;
        this.isolatableFactory = isolatableFactory;
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getImplementationType() {
        return this.implementationType;
    }

    @Nullable
    public P getParameters() {
        return this.parameters;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.implementationType;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public boolean immutable() {
        return true;
    }

    @Override
    public Object unpackState() {
        throw new UnsupportedOperationException("Build services cannot be serialized.");
    }

    @Override
    public boolean isValueProducedByTask() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public T getOrNull() {
        BuildServiceProvider buildServiceProvider = this;
        synchronized (buildServiceProvider) {
            if (this.instance == null) {
                DefaultServiceRegistry services = new DefaultServiceRegistry();
                BuildServiceParameters isolatedParameters = (BuildServiceParameters)this.isolatableFactory.isolate(this.parameters).isolate();
                if (isolatedParameters != null) {
                    services.add(this.parametersType, isolatedParameters);
                }
                try {
                    this.instance = Try.successful((BuildService)this.instantiationScheme.withServices(services).instantiator().newInstance(this.implementationType, new Object[0]));
                }
                catch (Exception e) {
                    this.instance = Try.failure(new ServiceLifecycleException("Failed to create service '" + this.name + "'.", e));
                }
            }
            return (T)((BuildService)this.instance.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void maybeStop() {
        BuildServiceProvider buildServiceProvider = this;
        synchronized (buildServiceProvider) {
            if (this.instance != null) {
                this.instance.ifSuccessful(t -> {
                    if (t instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)((Object)t)).close();
                        }
                        catch (Exception e) {
                            throw new ServiceLifecycleException("Failed to stop service '" + this.name + "'.", e);
                        }
                    }
                });
            }
        }
    }
}

