/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.Buildable;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.LazilyInitializedFileCollection;
import org.gradle.api.internal.plugins.GroovyJarFile;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.util.VersionNumber;

public class GroovyRuntime {
    private static final VersionNumber GROOVY_VERSION_WITH_SEPARATE_ANT = VersionNumber.parse("2.0");
    private static final VersionNumber GROOVY_VERSION_REQUIRING_TEMPLATES = VersionNumber.parse("2.5");
    private final Project project;

    public GroovyRuntime(Project project) {
        this.project = project;
    }

    public FileCollection inferGroovyClasspath(final Iterable<File> classpath) {
        return new LazilyInitializedFileCollection(){

            @Override
            public String getDisplayName() {
                return "Groovy runtime classpath";
            }

            @Override
            public FileCollection createDelegate() {
                GroovyJarFile groovyJar = GroovyRuntime.findGroovyJarFile(classpath);
                if (groovyJar == null) {
                    throw new GradleException(String.format("Cannot infer Groovy class path because no Groovy Jar was found on class path: %s", Iterables.toString((Iterable)classpath)));
                }
                if (groovyJar.isGroovyAll()) {
                    return GroovyRuntime.this.project.getLayout().files(groovyJar.getFile());
                }
                if (GroovyRuntime.this.project.getRepositories().isEmpty()) {
                    throw new GradleException("Cannot infer Groovy class path because no repository is declared for the project.");
                }
                String notation = groovyJar.getDependencyNotation();
                ArrayList dependencies = Lists.newArrayList();
                dependencies.add(GroovyRuntime.this.project.getDependencies().create(notation));
                VersionNumber groovyVersion = groovyJar.getVersion();
                if (groovyVersion.compareTo(GROOVY_VERSION_WITH_SEPARATE_ANT) >= 0) {
                    this.addGroovyDependency(notation, dependencies, "groovy-ant");
                }
                if (groovyVersion.compareTo(GROOVY_VERSION_REQUIRING_TEMPLATES) >= 0) {
                    this.addGroovyDependency(notation, dependencies, "groovy-templates");
                }
                return GroovyRuntime.this.project.getConfigurations().detachedConfiguration(dependencies.toArray(new Dependency[0]));
            }

            private void addGroovyDependency(String groovyDependencyNotion, List<Dependency> dependencies, String otherDependency) {
                dependencies.add(GroovyRuntime.this.project.getDependencies().create(groovyDependencyNotion.replace(":groovy:", ":" + otherDependency + ":")));
            }

            @Override
            public void visitDependencies(TaskDependencyResolveContext context) {
                if (classpath instanceof Buildable) {
                    context.add(classpath);
                }
            }
        };
    }

    @Nullable
    private static GroovyJarFile findGroovyJarFile(Iterable<File> classpath) {
        for (File file : classpath) {
            GroovyJarFile groovyJar = GroovyJarFile.parse(file);
            if (groovyJar == null) continue;
            return groovyJar;
        }
        return null;
    }
}

