/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.specs.Spec;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.tasks.InitBuild;

public class BuildInitPlugin
implements Plugin<Project> {
    @Override
    public void apply(final Project project) {
        if (project.getParent() == null) {
            project.getTasks().register("init", InitBuild.class, new Action<InitBuild>(){

                @Override
                public void execute(InitBuild initBuild) {
                    initBuild.setGroup("Build Setup");
                    initBuild.setDescription("Initializes a new Gradle build.");
                    initBuild.onlyIf((Spec<? super Task>)new Spec<Task>(){

                        @Override
                        public boolean isSatisfiedBy(Task element) {
                            String skippedMsg = BuildInitPlugin.this.reasonToSkip(project);
                            if (skippedMsg != null) {
                                project.getLogger().warn(skippedMsg);
                                return false;
                            }
                            return true;
                        }
                    });
                    initBuild.dependsOn(new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            if (BuildInitPlugin.this.reasonToSkip(project) == null) {
                                return "wrapper";
                            }
                            return null;
                        }
                    });
                }
            });
        }
    }

    private String reasonToSkip(Project project) {
        for (BuildInitDsl dsl : BuildInitDsl.values()) {
            String buildFileName = dsl.fileNameFor("build");
            if (project.file(buildFileName).exists()) {
                return "The build file '" + buildFileName + "' already exists. Skipping build initialization.";
            }
            String settingsFileName = dsl.fileNameFor("settings");
            if (!project.file(settingsFileName).exists()) continue;
            return "The settings file '" + settingsFileName + "' already exists. Skipping build initialization.";
        }
        File buildFile = project.getBuildFile();
        if (buildFile != null && buildFile.exists()) {
            return "The build file '" + buildFile.getName() + "' already exists. Skipping build initialization.";
        }
        if (project.getSubprojects().size() > 0) {
            return "This Gradle project appears to be part of an existing multi-project Gradle build. Skipping build initialization.";
        }
        return null;
    }
}

