/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.project;

import org.gradle.api.Action;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.configuration.project.ConfigureProjectBuildOperationType;
import org.gradle.configuration.project.NotifyProjectAfterEvaluatedBuildOperationType;
import org.gradle.configuration.project.NotifyProjectBeforeEvaluatedBuildOperationType;
import org.gradle.configuration.project.ProjectEvaluator;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.util.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LifecycleProjectEvaluator
implements ProjectEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(LifecycleProjectEvaluator.class);
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectEvaluator delegate;

    public LifecycleProjectEvaluator(BuildOperationExecutor buildOperationExecutor, ProjectEvaluator delegate) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.delegate = delegate;
    }

    @Override
    public void evaluate(ProjectInternal project, ProjectStateInternal state) {
        if (state.isUnconfigured()) {
            this.buildOperationExecutor.run(new EvaluateProject(project, state));
        }
    }

    private static void addConfigurationFailure(ProjectInternal project, ProjectStateInternal state, Exception e, BuildOperationContext ctx) {
        ProjectConfigurationException exception = LifecycleProjectEvaluator.wrapException(project, e);
        ctx.failed(exception);
        state.failed(exception);
    }

    private static ProjectConfigurationException wrapException(ProjectInternal project, Exception e) {
        return new ProjectConfigurationException(String.format("A problem occurred configuring %s.", project.getDisplayName()), (Throwable)e);
    }

    private static class NotifyAfterEvaluate
    implements RunnableBuildOperation {
        private final ProjectInternal project;
        private final ProjectStateInternal state;

        private NotifyAfterEvaluate(ProjectInternal project, ProjectStateInternal state) {
            this.project = project;
            this.state = state;
        }

        @Override
        public void run(BuildOperationContext context) {
            ProjectEvaluationListener nextBatch = this.project.getProjectEvaluationBroadcaster();
            Action<ProjectEvaluationListener> fireAction = new Action<ProjectEvaluationListener>(){

                @Override
                public void execute(ProjectEvaluationListener listener) {
                    listener.afterEvaluate(project, state);
                }
            };
            do {
                try {
                    nextBatch = this.project.stepEvaluationListener(nextBatch, fireAction);
                }
                catch (Exception e) {
                    LifecycleProjectEvaluator.addConfigurationFailure(this.project, this.state, e, context);
                    return;
                }
            } while (nextBatch != null);
            context.setResult(NotifyProjectAfterEvaluatedBuildOperationType.RESULT);
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName("Notify afterEvaluate listeners of " + this.project.getIdentityPath()).details(new NotifyProjectAfterEvaluatedBuildOperationType.DetailsImpl(this.project.getProjectPath(), this.project.getGradle().getIdentityPath()));
        }
    }

    private static class NotifyBeforeEvaluate
    implements RunnableBuildOperation {
        private final ProjectInternal project;
        private final ProjectStateInternal state;

        private NotifyBeforeEvaluate(ProjectInternal project, ProjectStateInternal state) {
            this.project = project;
            this.state = state;
        }

        @Override
        public void run(BuildOperationContext context) {
            try {
                this.project.getProjectEvaluationBroadcaster().beforeEvaluate(this.project);
                context.setResult(NotifyProjectBeforeEvaluatedBuildOperationType.RESULT);
            }
            catch (Exception e) {
                LifecycleProjectEvaluator.addConfigurationFailure(this.project, this.state, e, context);
            }
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName("Notify beforeEvaluate listeners of " + this.project.getIdentityPath()).details(new NotifyProjectBeforeEvaluatedBuildOperationType.DetailsImpl(this.project.getProjectPath(), this.project.getGradle().getIdentityPath()));
        }
    }

    private class EvaluateProject
    implements RunnableBuildOperation {
        private final ProjectInternal project;
        private final ProjectStateInternal state;

        private EvaluateProject(ProjectInternal project, ProjectStateInternal state) {
            this.project = project;
            this.state = state;
        }

        @Override
        public void run(final BuildOperationContext context) {
            this.project.getMutationState().withMutableState(new Runnable(){

                @Override
                public void run() {
                    try {
                        EvaluateProject.this.state.toBeforeEvaluate();
                        LifecycleProjectEvaluator.this.buildOperationExecutor.run(new NotifyBeforeEvaluate(EvaluateProject.this.project, EvaluateProject.this.state));
                        if (!EvaluateProject.this.state.hasFailure()) {
                            EvaluateProject.this.state.toEvaluate();
                            try {
                                LifecycleProjectEvaluator.this.delegate.evaluate(EvaluateProject.this.project, EvaluateProject.this.state);
                            }
                            catch (Exception e) {
                                LifecycleProjectEvaluator.addConfigurationFailure(EvaluateProject.this.project, EvaluateProject.this.state, e, context);
                            }
                            finally {
                                EvaluateProject.this.state.toAfterEvaluate();
                                LifecycleProjectEvaluator.this.buildOperationExecutor.run(new NotifyAfterEvaluate(EvaluateProject.this.project, EvaluateProject.this.state));
                            }
                        }
                        if (EvaluateProject.this.state.hasFailure()) {
                            EvaluateProject.this.state.rethrowFailure();
                        } else {
                            context.setResult(ConfigureProjectBuildOperationType.RESULT);
                        }
                    }
                    finally {
                        EvaluateProject.this.state.configured();
                    }
                }
            });
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            Path identityPath = this.project.getIdentityPath();
            String displayName = "Configure project " + identityPath.toString();
            String progressDisplayName = identityPath.toString();
            if (identityPath.equals(Path.ROOT)) {
                progressDisplayName = "root project";
            }
            return BuildOperationDescriptor.displayName(displayName).operationType(BuildOperationCategory.CONFIGURE_PROJECT).progressDisplayName(progressDisplayName).details(new ConfigureProjectBuildOperationType.DetailsImpl(this.project.getProjectPath(), this.project.getGradle().getIdentityPath(), this.project.getRootDir()));
        }
    }
}

