/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import java.util.Optional;
import org.gradle.internal.execution.BeforeExecutionContext;
import org.gradle.internal.execution.CurrentSnapshotResult;
import org.gradle.internal.execution.Step;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.history.AfterPreviousExecutionState;
import org.gradle.internal.execution.history.ExecutionHistoryStore;
import org.gradle.internal.execution.history.changes.ChangeDetectorVisitor;
import org.gradle.internal.execution.history.changes.OutputFileChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;

public class StoreExecutionStateStep<C extends BeforeExecutionContext>
implements Step<C, CurrentSnapshotResult> {
    private final Step<? super C, ? extends CurrentSnapshotResult> delegate;

    public StoreExecutionStateStep(Step<? super C, ? extends CurrentSnapshotResult> delegate) {
        this.delegate = delegate;
    }

    @Override
    public CurrentSnapshotResult execute(C context) {
        CurrentSnapshotResult result = this.delegate.execute(context);
        context.getWork().getExecutionHistoryStore().ifPresent(executionHistoryStore -> this.storeState(context, (ExecutionHistoryStore)executionHistoryStore, result));
        return result;
    }

    private void storeState(C context, ExecutionHistoryStore executionHistoryStore, CurrentSnapshotResult result) {
        ImmutableSortedMap<String, CurrentFileCollectionFingerprint> finalOutputs = result.getFinalOutputs();
        context.getBeforeExecutionState().ifPresent(beforeExecutionState -> {
            boolean successful = result.getOutcome().isSuccessful();
            if (successful || StoreExecutionStateStep.didChangeOutput(context.getAfterPreviousExecutionState(), finalOutputs)) {
                UnitOfWork work = context.getWork();
                executionHistoryStore.store(work.getIdentity(), result.getOriginMetadata(), beforeExecutionState.getImplementation(), beforeExecutionState.getAdditionalImplementations(), beforeExecutionState.getInputProperties(), beforeExecutionState.getInputFileProperties(), finalOutputs, successful);
            }
        });
    }

    private static boolean didChangeOutput(Optional<AfterPreviousExecutionState> afterPreviousExecutionState, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
        if (!afterPreviousExecutionState.isPresent()) {
            return true;
        }
        ImmutableSortedMap<String, FileCollectionFingerprint> previous = afterPreviousExecutionState.get().getOutputFileProperties();
        if (!previous.keySet().equals((Object)current.keySet())) {
            return true;
        }
        ChangeDetectorVisitor visitor = new ChangeDetectorVisitor();
        OutputFileChanges changes = new OutputFileChanges(previous, current);
        changes.accept(visitor);
        return visitor.hasAnyChanges();
    }
}

