/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.reflect.ClassDetails;
import org.gradle.internal.reflect.MethodSet;
import org.gradle.internal.reflect.MutablePropertyDetails;
import org.gradle.internal.reflect.NoSuchPropertyException;
import org.gradle.internal.reflect.PropertyDetails;

class MutableClassDetails
implements ClassDetails {
    private final Class<?> type;
    private final MethodSet instanceMethods = new MethodSet();
    private final Map<String, MutablePropertyDetails> properties = new TreeMap<String, MutablePropertyDetails>();
    private final List<Method> methods = new ArrayList<Method>();
    private final Set<Class<?>> superTypes = new LinkedHashSet();

    MutableClassDetails(Class<?> type) {
        this.type = type;
    }

    @Override
    public List<Method> getAllMethods() {
        return this.methods;
    }

    @Override
    public Collection<Method> getInstanceMethods() {
        return this.instanceMethods.getValues();
    }

    @Override
    public Set<Class<?>> getSuperTypes() {
        return this.superTypes;
    }

    @Override
    public Set<String> getPropertyNames() {
        return ImmutableSet.copyOf(this.properties.keySet());
    }

    @Override
    public Collection<? extends PropertyDetails> getProperties() {
        return this.properties.values();
    }

    @Override
    public PropertyDetails getProperty(String name) throws NoSuchPropertyException {
        MutablePropertyDetails property = this.properties.get(name);
        if (property == null) {
            throw new NoSuchPropertyException(String.format("No property '%s' found on %s.", name, this.type));
        }
        return property;
    }

    void superType(Class<?> type) {
        this.superTypes.add(type);
    }

    void method(Method method) {
        this.methods.add(method);
    }

    void instanceMethod(Method method) {
        this.instanceMethods.add(method);
    }

    MutablePropertyDetails property(String propertyName) {
        MutablePropertyDetails property = this.properties.get(propertyName);
        if (property == null) {
            property = new MutablePropertyDetails(propertyName);
            this.properties.put(propertyName, property);
        }
        return property;
    }
}

