/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import org.gradle.internal.file.FileAccessTimeJournal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModificationTimeFileAccessTimeJournal
implements FileAccessTimeJournal {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModificationTimeFileAccessTimeJournal.class);

    @Override
    public void setLastAccessTime(File file, long millis) {
        try {
            Files.setLastModifiedTime(file.toPath(), FileTime.fromMillis(millis));
        }
        catch (IOException e) {
            LOGGER.debug("Ignoring failure to set last access time of " + file, (Throwable)e);
        }
    }

    @Override
    public long getLastAccessTime(File file) {
        return file.lastModified();
    }

    @Override
    public void deleteLastAccessTime(File file) {
    }
}

