/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.gcp.gcs;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.impldep.com.google.api.services.storage.model.StorageObject;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;
import org.gradle.internal.resource.transport.gcp.gcs.GcsClient;
import org.gradle.internal.resource.transport.gcp.gcs.GcsResource;
import org.gradle.internal.resource.transport.gcp.gcs.ResourceMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcsResourceConnector
implements ExternalResourceConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(GcsResourceConnector.class);
    private final GcsClient gcsClient;

    public GcsResourceConnector(GcsClient gcsClient) {
        this.gcsClient = gcsClient;
    }

    @Override
    @Nullable
    public List<String> list(URI parent) throws ResourceException {
        LOGGER.debug("Listing parent resources: {}", (Object)parent);
        return this.gcsClient.list(parent);
    }

    @Override
    @Nullable
    public ExternalResourceReadResponse openResource(URI location, boolean revalidate) throws ResourceException {
        LOGGER.debug("Attempting to get resource: {}", (Object)location);
        StorageObject gcsObject = this.gcsClient.getResource(location);
        if (gcsObject == null) {
            return null;
        }
        return new GcsResource(this.gcsClient, gcsObject, location);
    }

    @Override
    @Nullable
    public ExternalResourceMetaData getMetaData(URI location, boolean revalidate) throws ResourceException {
        LOGGER.debug("Attempting to get resource metadata: {}", (Object)location);
        StorageObject gcsObject = this.gcsClient.getResource(location);
        if (gcsObject == null) {
            return null;
        }
        return ResourceMapper.toExternalResourceMetaData(location, gcsObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void upload(ReadableContent resource, URI destination) throws IOException {
        LOGGER.debug("Attempting to upload stream to: {}", (Object)destination);
        try (InputStream inputStream = resource.open();){
            this.gcsClient.put(inputStream, resource.getContentLength(), destination);
        }
    }
}

