/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.rules;

import org.gradle.internal.rules.RuleAction;
import org.gradle.internal.rules.RuleActionValidationException;
import org.gradle.internal.rules.RuleActionValidator;
import org.gradle.model.internal.type.ModelType;

public class DefaultRuleActionValidator
implements RuleActionValidator {
    private static final String VALID_NO_TYPES = "Rule may not have an input parameter of type: %s.";
    private static final String VALID_SINGLE_TYPES = "Rule may not have an input parameter of type: %s. Second parameter must be of type: %s.";
    private final Class<?> validInputType;

    public DefaultRuleActionValidator() {
        this.validInputType = null;
    }

    public DefaultRuleActionValidator(Class<?> validInputType) {
        this.validInputType = validInputType;
    }

    @Override
    public <T> RuleAction<? super T> validate(RuleAction<? super T> ruleAction) {
        this.validateInputTypes(ruleAction);
        return ruleAction;
    }

    private void validateInputTypes(RuleAction<?> ruleAction) {
        for (Class<?> inputType : ruleAction.getInputTypes()) {
            if (this.validInputType == null) {
                throw new RuleActionValidationException(this.invalidParameterMessage(inputType));
            }
            if (this.validInputType.equals(inputType)) continue;
            throw new RuleActionValidationException(this.invalidParameterMessage(inputType));
        }
    }

    private String invalidParameterMessage(Class<?> inputType) {
        if (this.validInputType == null) {
            return String.format(VALID_NO_TYPES, inputType.getName());
        }
        return String.format(VALID_SINGLE_TYPES, inputType.getName(), DefaultRuleActionValidator.className(this.validInputType));
    }

    private static String className(Class<?> aClass) {
        return ModelType.of(aClass).toString();
    }
}

