/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.io.Closeable;
import java.io.IOException;
import org.gradle.StartParameter;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DefaultCollectionCallbackActionDecorator;
import org.gradle.configuration.internal.DefaultListenerBuildOperationDecorator;
import org.gradle.configuration.internal.DefaultUserCodeApplicationContext;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.configuration.internal.UserCodeApplicationContext;
import org.gradle.initialization.DefaultGradleLauncherFactory;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.logging.sink.OutputEventListenerManager;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.DefaultBuildOperationExecutor;
import org.gradle.internal.operations.DefaultBuildOperationQueueFactory;
import org.gradle.internal.operations.DelegatingBuildOperationExecutor;
import org.gradle.internal.operations.logging.LoggingBuildOperationProgressBroadcaster;
import org.gradle.internal.operations.notify.BuildOperationNotificationBridge;
import org.gradle.internal.operations.notify.BuildOperationNotificationListenerRegistrar;
import org.gradle.internal.operations.notify.BuildOperationNotificationValve;
import org.gradle.internal.operations.trace.BuildOperationTrace;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.time.Clock;
import org.gradle.internal.work.DefaultWorkerLeaseService;
import org.gradle.internal.work.StopShieldingWorkerLeaseService;
import org.gradle.internal.work.WorkerLeaseService;

public class CrossBuildSessionScopeServices
implements Closeable {
    private final BuildOperationTrace buildOperationTrace;
    private final BuildOperationNotificationBridge buildOperationNotificationBridge;
    private final LoggingBuildOperationProgressBroadcaster loggingBuildOperationProgressBroadcaster;
    private final BuildOperationListenerManager buildOperationListenerManager;
    private final Services services;

    public CrossBuildSessionScopeServices(ServiceRegistry parent, StartParameter startParameter) {
        this.services = new Services(parent);
        this.buildOperationListenerManager = parent.get(BuildOperationListenerManager.class);
        ListenerManager generalListenerManager = parent.get(ListenerManager.class);
        this.buildOperationTrace = new BuildOperationTrace(startParameter, this.buildOperationListenerManager);
        this.buildOperationNotificationBridge = new BuildOperationNotificationBridge(this.buildOperationListenerManager, generalListenerManager);
        this.loggingBuildOperationProgressBroadcaster = new LoggingBuildOperationProgressBroadcaster(parent.get(OutputEventListenerManager.class), this.buildOperationListenerManager.getBroadcaster());
    }

    GradleLauncherFactory createGradleLauncherFactory() {
        return this.services.get(GradleLauncherFactory.class);
    }

    WorkerLeaseService createWorkerLeaseService() {
        return new StopShieldingWorkerLeaseService(this.services.get(WorkerLeaseService.class));
    }

    BuildOperationListenerManager createBuildOperationListenerManager() {
        return this.buildOperationListenerManager;
    }

    LoggingBuildOperationProgressBroadcaster createLoggingBuildOperationProgressBroadcaster() {
        return this.loggingBuildOperationProgressBroadcaster;
    }

    BuildOperationExecutor createBuildOperationExecutor() {
        return new DelegatingBuildOperationExecutor(this.services.get(BuildOperationExecutor.class));
    }

    ListenerBuildOperationDecorator createListenerBuildOperationDecorator() {
        return this.services.get(ListenerBuildOperationDecorator.class);
    }

    UserCodeApplicationContext createUserCodeApplicationContext() {
        return this.services.get(UserCodeApplicationContext.class);
    }

    BuildOperationNotificationListenerRegistrar createBuildOperationNotificationListenerRegistrar() {
        return this.buildOperationNotificationBridge.getRegistrar();
    }

    BuildOperationNotificationValve createBuildOperationNotificationValve() {
        return this.buildOperationNotificationBridge.getValve();
    }

    CollectionCallbackActionDecorator createDomainObjectCollectioncallbackActionDecorator(BuildOperationExecutor buildOperationExecutor, UserCodeApplicationContext userCodeApplicationContext) {
        return this.services.get(CollectionCallbackActionDecorator.class);
    }

    @Override
    public void close() throws IOException {
        new CompositeStoppable().add(this.buildOperationTrace, this.buildOperationNotificationBridge, this.loggingBuildOperationProgressBroadcaster, this.services).stop();
    }

    private class Services
    extends DefaultServiceRegistry {
        public Services(ServiceRegistry parent) {
            super(parent);
        }

        GradleLauncherFactory createGradleLauncherFactory(GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry) {
            return new DefaultGradleLauncherFactory(userHomeDirServiceRegistry, CrossBuildSessionScopeServices.this);
        }

        WorkerLeaseService createWorkerLeaseService(ResourceLockCoordinationService resourceLockCoordinationService, ParallelismConfigurationManager parallelismConfigurationManager) {
            return new DefaultWorkerLeaseService(resourceLockCoordinationService, parallelismConfigurationManager);
        }

        BuildOperationExecutor createBuildOperationExecutor(Clock clock, ProgressLoggerFactory progressLoggerFactory, WorkerLeaseService workerLeaseService, ExecutorFactory executorFactory, ParallelismConfigurationManager parallelismConfigurationManager, BuildOperationIdFactory buildOperationIdFactory) {
            return new DefaultBuildOperationExecutor(CrossBuildSessionScopeServices.this.buildOperationListenerManager.getBroadcaster(), clock, progressLoggerFactory, new DefaultBuildOperationQueueFactory(workerLeaseService), executorFactory, parallelismConfigurationManager, buildOperationIdFactory);
        }

        UserCodeApplicationContext createUserCodeApplicationContext() {
            return new DefaultUserCodeApplicationContext();
        }

        ListenerBuildOperationDecorator createListenerBuildOperationDecorator(BuildOperationExecutor buildOperationExecutor, UserCodeApplicationContext userCodeApplicationContext) {
            return new DefaultListenerBuildOperationDecorator(buildOperationExecutor, userCodeApplicationContext);
        }

        CollectionCallbackActionDecorator createDomainObjectCollectioncallbackActionDecorator(BuildOperationExecutor buildOperationExecutor, UserCodeApplicationContext userCodeApplicationContext) {
            return new DefaultCollectionCallbackActionDecorator(buildOperationExecutor, userCodeApplicationContext);
        }
    }
}

