/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.LibraryBinaryIdentifier;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.artifacts.ArtifactDependencyResolver;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.file.collections.ImmutableFileCollection;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestTaskReports;
import org.gradle.internal.Cast;
import org.gradle.internal.Transformers;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.component.local.model.DefaultLibraryBinaryIdentifier;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.org.apache.commons.lang.WordUtils;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.jvm.JvmBinarySpec;
import org.gradle.jvm.internal.DependencyResolvingClasspath;
import org.gradle.jvm.internal.JvmAssembly;
import org.gradle.jvm.internal.JvmBinarySpecInternal;
import org.gradle.jvm.internal.WithJvmAssembly;
import org.gradle.jvm.internal.resolve.DefaultVariantsMetaData;
import org.gradle.jvm.internal.resolve.JvmLibraryResolveContext;
import org.gradle.jvm.internal.resolve.UsageKind;
import org.gradle.jvm.test.JvmTestSuiteBinarySpec;
import org.gradle.jvm.test.internal.JvmTestSuiteBinarySpecInternal;
import org.gradle.language.base.DependentSourceSet;
import org.gradle.language.base.LanguageSourceSet;
import org.gradle.model.Each;
import org.gradle.model.Finalize;
import org.gradle.model.ModelMap;
import org.gradle.model.Path;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.platform.base.BinaryTasks;
import org.gradle.platform.base.DependencySpec;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.DefaultLibraryBinaryDependencySpec;
import org.gradle.util.CollectionUtils;

@Deprecated
public class JvmTestSuiteBasePlugin
extends RuleSource {
    @BinaryTasks
    void createJvmTestSuiteTasks(ModelMap<Task> tasks, final JvmTestSuiteBinarySpecInternal binary, final @Path(value="buildDir") File buildDir) {
        final JvmAssembly jvmAssembly = ((WithJvmAssembly)((Object)binary)).getAssembly();
        tasks.create(JvmTestSuiteBasePlugin.testTaskNameFor(binary), Test.class, new Action<Test>(){

            @Override
            public void execute(Test test) {
                test.setGroup("verification");
                test.setDescription(String.format("Runs %s.", WordUtils.uncapitalize((String)binary.getDisplayName())));
                test.dependsOn(jvmAssembly);
                test.setTestClassesDirs(ImmutableFileCollection.of(binary.getClassesDir()));
                test.setClasspath(binary.getRuntimeClasspath());
                this.configureReports(binary, test);
            }

            private void configureReports(JvmTestSuiteBinarySpecInternal binary2, Test test) {
                TestTaskReports reports = test.getReports();
                File reportsDirectory = new File(buildDir, "reports");
                File reportsOutputDirectory = binary2.getNamingScheme().getOutputDirectory(reportsDirectory);
                File htmlDir = new File(reportsOutputDirectory, "tests");
                File xmlDir = new File(buildDir, "test-results");
                File xmlDirOutputDirectory = binary2.getNamingScheme().getOutputDirectory(xmlDir);
                File binDir = new File(xmlDirOutputDirectory, "binary");
                reports.getHtml().setDestination(htmlDir);
                reports.getJunitXml().setDestination(xmlDirOutputDirectory);
                test.setBinResultsDir(binDir);
            }
        });
    }

    private static String testTaskNameFor(JvmTestSuiteBinarySpec binary) {
        return ((BinarySpecInternal)((Object)binary)).getProjectScopedName() + "Test";
    }

    @Finalize
    public void configureRuntimeClasspath(@Each JvmTestSuiteBinarySpecInternal testBinary, ServiceRegistry serviceRegistry, ModelSchemaStore modelSchemaStore) {
        ArtifactDependencyResolver dependencyResolver = serviceRegistry.get(ArtifactDependencyResolver.class);
        RepositoryHandler repositories = serviceRegistry.get(RepositoryHandler.class);
        List<ResolutionAwareRepository> resolutionAwareRepositories = CollectionUtils.collect(repositories, Transformers.cast(ResolutionAwareRepository.class));
        ModelSchema schema = (ModelSchema)Cast.uncheckedCast(modelSchemaStore.getSchema(testBinary.getPublicType()));
        AttributesSchemaInternal attributesSchema = serviceRegistry.get(AttributesSchemaInternal.class);
        ImmutableModuleIdentifierFactory moduleIdentifierFactory = serviceRegistry.get(ImmutableModuleIdentifierFactory.class);
        BuildOperationExecutor buildOperationExecutor = serviceRegistry.get(BuildOperationExecutor.class);
        BuildIdentifier currentBuild = serviceRegistry.get(BuildState.class).getBuildIdentifier();
        testBinary.setRuntimeClasspath(JvmTestSuiteBasePlugin.configureRuntimeClasspath(testBinary, dependencyResolver, resolutionAwareRepositories, schema, attributesSchema, moduleIdentifierFactory, buildOperationExecutor, currentBuild));
    }

    private static DependencyResolvingClasspath configureRuntimeClasspath(JvmTestSuiteBinarySpecInternal testBinary, ArtifactDependencyResolver dependencyResolver, List<ResolutionAwareRepository> resolutionAwareRepositories, ModelSchema<? extends JvmTestSuiteBinarySpec> schema, AttributesSchemaInternal attributesSchema, ImmutableModuleIdentifierFactory moduleIdentifierFactory, BuildOperationExecutor buildOperationExecutor, BuildIdentifier currentBuild) {
        return new DependencyResolvingClasspath(testBinary, testBinary.getDisplayName(), dependencyResolver, resolutionAwareRepositories, JvmTestSuiteBasePlugin.createResolveContext(testBinary, schema, moduleIdentifierFactory), attributesSchema, buildOperationExecutor, currentBuild);
    }

    private static JvmLibraryResolveContext createResolveContext(JvmTestSuiteBinarySpecInternal testBinary, ModelSchema<? extends JvmTestSuiteBinarySpec> schema, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        LibraryBinaryIdentifier id = testBinary.getId();
        DefaultLibraryBinaryIdentifier thisId = new DefaultLibraryBinaryIdentifier(id.getProjectPath(), id.getLibraryName() + "Test", id.getVariant());
        return new JvmLibraryResolveContext(thisId, DefaultVariantsMetaData.extractFrom(testBinary, schema), JvmTestSuiteBasePlugin.runtimeDependencies(testBinary), UsageKind.RUNTIME, testBinary.getDisplayName(), moduleIdentifierFactory);
    }

    private static List<DependencySpec> runtimeDependencies(JvmTestSuiteBinarySpecInternal testBinary) {
        ArrayList dependencies = Lists.newArrayList(testBinary.getDependencies());
        JvmBinarySpec testedBinary = testBinary.getTestedBinary();
        dependencies.add(DefaultLibraryBinaryDependencySpec.of(testBinary.getId()));
        if (testedBinary != null) {
            JvmBinarySpecInternal binary = (JvmBinarySpecInternal)testedBinary;
            LibraryBinaryIdentifier id = binary.getId();
            dependencies.add(DefaultLibraryBinaryDependencySpec.of(id));
        }
        JvmTestSuiteBasePlugin.addSourceSetSpecificDependencies(dependencies, testBinary.getSources());
        JvmTestSuiteBasePlugin.addSourceSetSpecificDependencies(dependencies, testBinary.getTestSuite().getSources());
        return dependencies;
    }

    private static void addSourceSetSpecificDependencies(List<DependencySpec> dependencies, ModelMap<LanguageSourceSet> sources) {
        for (LanguageSourceSet sourceSet : sources) {
            if (!(sourceSet instanceof DependentSourceSet)) continue;
            dependencies.addAll(((DependentSourceSet)sourceSet).getDependencies().getDependencies());
        }
    }
}

