/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.swift.internal;

import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.SetProperty;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.language.LibraryDependencies;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.internal.DefaultBinaryCollection;
import org.gradle.language.internal.DefaultLibraryDependencies;
import org.gradle.language.swift.SwiftBinary;
import org.gradle.language.swift.SwiftLibrary;
import org.gradle.language.swift.SwiftPlatform;
import org.gradle.language.swift.SwiftSharedLibrary;
import org.gradle.language.swift.SwiftStaticLibrary;
import org.gradle.language.swift.internal.DefaultSwiftComponent;
import org.gradle.language.swift.internal.DefaultSwiftSharedLibrary;
import org.gradle.language.swift.internal.DefaultSwiftStaticLibrary;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

public class DefaultSwiftLibrary
extends DefaultSwiftComponent<SwiftBinary>
implements SwiftLibrary {
    private final ObjectFactory objectFactory;
    private final SetProperty<Linkage> linkage;
    private final ConfigurationContainer configurations;
    private final Property<SwiftBinary> developmentBinary;
    private final DefaultLibraryDependencies dependencies;

    @Inject
    public DefaultSwiftLibrary(String name, ObjectFactory objectFactory, ConfigurationContainer configurations) {
        super(name, objectFactory);
        this.objectFactory = objectFactory;
        this.configurations = configurations;
        this.developmentBinary = objectFactory.property(SwiftBinary.class);
        this.linkage = objectFactory.setProperty(Linkage.class);
        this.linkage.set(Collections.singleton(Linkage.SHARED));
        this.dependencies = objectFactory.newInstance(DefaultLibraryDependencies.class, this.getNames().withSuffix("implementation"), this.getNames().withSuffix("api"));
    }

    @Override
    public DisplayName getDisplayName() {
        return Describables.withTypeAndName("Swift library", this.getName());
    }

    @Override
    public Configuration getImplementationDependencies() {
        return this.dependencies.getImplementationDependencies();
    }

    @Override
    public LibraryDependencies getDependencies() {
        return this.dependencies;
    }

    public void dependencies(Action<? super LibraryDependencies> action) {
        action.execute(this.dependencies);
    }

    public SwiftStaticLibrary addStaticLibrary(NativeVariantIdentity identity, boolean testable, SwiftPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        SwiftStaticLibrary result = this.objectFactory.newInstance(DefaultSwiftStaticLibrary.class, this.getNames().append(identity.getName()), this.getModule(), testable, this.getSwiftSource(), this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider, identity);
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    public SwiftSharedLibrary addSharedLibrary(NativeVariantIdentity identity, boolean testable, SwiftPlatform targetPlatform, NativeToolChainInternal toolChain, PlatformToolProvider platformToolProvider) {
        SwiftSharedLibrary result = this.objectFactory.newInstance(DefaultSwiftSharedLibrary.class, this.getNames().append(identity.getName()), this.getModule(), testable, this.getSwiftSource(), this.configurations, this.getImplementationDependencies(), targetPlatform, toolChain, platformToolProvider, identity);
        ((DefaultBinaryCollection)this.getBinaries()).add(result);
        return result;
    }

    @Override
    public Configuration getApiDependencies() {
        return this.dependencies.getApiDependencies();
    }

    public Property<SwiftBinary> getDevelopmentBinary() {
        return this.developmentBinary;
    }

    @Override
    public SetProperty<Linkage> getLinkage() {
        return this.linkage;
    }
}

