/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.eclipse.model.internal;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.artifacts.result.UnresolvedDependencyResult;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.plugins.ear.EarPlugin;
import org.gradle.plugins.ide.eclipse.model.AbstractClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.AbstractLibrary;
import org.gradle.plugins.ide.eclipse.model.Classpath;
import org.gradle.plugins.ide.eclipse.model.ClasspathEntry;
import org.gradle.plugins.ide.eclipse.model.EclipseClasspath;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseWtp;
import org.gradle.plugins.ide.eclipse.model.EclipseWtpComponent;
import org.gradle.plugins.ide.eclipse.model.ProjectDependency;
import org.gradle.plugins.ide.internal.resolver.IdeDependencySet;
import org.gradle.plugins.ide.internal.resolver.IdeDependencyVisitor;

public class WtpClasspathAttributeSupport {
    private final String libDirName;
    private final boolean isUtilityProject;
    private final Set<File> rootConfigFiles;
    private final Set<File> libConfigFiles;

    public WtpClasspathAttributeSupport(Project project, EclipseModel model) {
        this.isUtilityProject = !project.getPlugins().hasPlugin(WarPlugin.class) && !project.getPlugins().hasPlugin(EarPlugin.class);
        EclipseWtp eclipseWtp = model.getWtp();
        EclipseWtpComponent wtpComponent = eclipseWtp.getComponent();
        this.libDirName = wtpComponent.getLibDeployPath();
        Set<Configuration> rootConfigs = wtpComponent.getRootConfigurations();
        Set<Configuration> libConfigs = wtpComponent.getLibConfigurations();
        Set<Configuration> minusConfigs = wtpComponent.getMinusConfigurations();
        this.rootConfigFiles = WtpClasspathAttributeSupport.collectFilesFromConfigs(model.getClasspath(), rootConfigs, minusConfigs);
        this.libConfigFiles = WtpClasspathAttributeSupport.collectFilesFromConfigs(model.getClasspath(), libConfigs, minusConfigs);
    }

    private static Set<File> collectFilesFromConfigs(EclipseClasspath classpath, Set<Configuration> configs, Set<Configuration> minusConfigs) {
        WtpClasspathAttributeDependencyVisitor visitor = new WtpClasspathAttributeDependencyVisitor(classpath);
        new IdeDependencySet(classpath.getProject().getDependencies(), configs, minusConfigs).visit(visitor);
        return visitor.getFiles();
    }

    public void enhance(Classpath classpath) {
        for (ClasspathEntry entry : classpath.getEntries()) {
            if (!(entry instanceof AbstractClasspathEntry)) continue;
            AbstractClasspathEntry classpathEntry = (AbstractClasspathEntry)entry;
            Map<String, Object> wtpEntries = this.createDeploymentAttribute(classpathEntry);
            classpathEntry.getEntryAttributes().putAll(wtpEntries);
        }
    }

    private Map<String, Object> createDeploymentAttribute(ClasspathEntry entry) {
        if (entry instanceof AbstractLibrary) {
            return this.createDeploymentAttribute((AbstractLibrary)entry);
        }
        if (entry instanceof ProjectDependency) {
            return this.createDeploymentAttribute((ProjectDependency)entry);
        }
        return Collections.emptyMap();
    }

    private Map<String, Object> createDeploymentAttribute(AbstractLibrary entry) {
        File file = entry.getLibrary().getFile();
        if (!this.isUtilityProject) {
            if (this.rootConfigFiles.contains(file)) {
                return WtpClasspathAttributeSupport.singleEntryMap("org.eclipse.jst.component.dependency", "/");
            }
            if (this.libConfigFiles.contains(file)) {
                return WtpClasspathAttributeSupport.singleEntryMap("org.eclipse.jst.component.dependency", this.libDirName);
            }
        }
        return WtpClasspathAttributeSupport.singleEntryMap("org.eclipse.jst.component.nondependency", "");
    }

    private Map<String, Object> createDeploymentAttribute(ProjectDependency entry) {
        return WtpClasspathAttributeSupport.singleEntryMap("org.eclipse.jst.component.nondependency", "");
    }

    private static Map<String, Object> singleEntryMap(String key, String value) {
        return ImmutableMap.of((Object)key, (Object)value);
    }

    private static class WtpClasspathAttributeDependencyVisitor
    implements IdeDependencyVisitor {
        private final EclipseClasspath classpath;
        private final Set<File> files = Sets.newLinkedHashSet();

        private WtpClasspathAttributeDependencyVisitor(EclipseClasspath classpath) {
            this.classpath = classpath;
        }

        @Override
        public boolean isOffline() {
            return this.classpath.isProjectDependenciesOnly();
        }

        @Override
        public boolean downloadSources() {
            return false;
        }

        @Override
        public boolean downloadJavaDoc() {
            return false;
        }

        @Override
        public void visitUnresolvedDependency(UnresolvedDependencyResult unresolvedDependency) {
        }

        @Override
        public void visitProjectDependency(ResolvedArtifactResult artifact) {
        }

        @Override
        public void visitModuleDependency(ResolvedArtifactResult artifact, Set<ResolvedArtifactResult> sources, Set<ResolvedArtifactResult> javaDoc, boolean testDependency) {
            this.files.add(artifact.getFile());
        }

        @Override
        public void visitFileDependency(ResolvedArtifactResult artifact, boolean testDependency) {
            this.files.add(artifact.getFile());
        }

        public Set<File> getFiles() {
            return this.files;
        }
    }
}

