/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.signatory.internal.gnupg;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.plugins.signing.signatory.SignatorySupport;
import org.gradle.plugins.signing.signatory.internal.gnupg.GnupgSettings;
import org.gradle.process.ExecSpec;

public class GnupgSignatory
extends SignatorySupport {
    private static final Logger LOG = Logging.getLogger(GnupgSignatory.class);
    private final Project project;
    private final String name;
    private final String executable;
    private final boolean useLegacyGpg;
    private final File homeDir;
    private final File optionsFile;
    private final String keyName;
    private final String passphrase;

    public GnupgSignatory(Project project, String name, GnupgSettings settings) {
        this.project = project;
        this.name = name;
        this.executable = settings.getExecutable();
        this.useLegacyGpg = settings.getUseLegacyGpg();
        this.homeDir = settings.getHomeDir();
        this.optionsFile = settings.getOptionsFile();
        this.keyName = settings.getKeyName();
        this.passphrase = settings.getPassphrase();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void sign(final InputStream input, final OutputStream output) {
        final List<String> arguments = this.buildArgumentList();
        LOG.info("Invoking {} with arguments: {}", this.executable, arguments);
        this.project.exec((Action<? super ExecSpec>)new Action<ExecSpec>(){

            @Override
            public void execute(ExecSpec spec) {
                spec.setExecutable(GnupgSignatory.this.executable);
                spec.setArgs(arguments);
                spec.setStandardInput(input);
                spec.setStandardOutput(output);
            }
        });
    }

    private List<String> buildArgumentList() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.homeDir != null) {
            args.add("--homedir");
            args.add(this.homeDir.getAbsolutePath());
        }
        if (this.optionsFile != null) {
            args.add("--options");
            args.add(this.optionsFile.getAbsolutePath());
        }
        if (this.keyName != null) {
            args.add("--local-user");
            args.add(this.keyName);
        }
        if (this.passphrase != null) {
            if (this.useLegacyGpg) {
                args.add("--no-use-agent");
            } else {
                args.add("--pinentry-mode=loopback");
            }
            args.add("--passphrase");
            args.add(this.passphrase);
        } else if (this.useLegacyGpg) {
            args.add("--use-agent");
        }
        args.add("--no-tty");
        args.add("--batch");
        args.add("--detach-sign");
        return args;
    }

    @Override
    public String getKeyId() {
        return this.keyName;
    }
}

