/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.CleanupAction;
import org.gradle.cache.CleanupProgressMonitor;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.Pair;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.serialize.Serializer;
import org.gradle.testfixtures.internal.InMemoryIndexedCache;
import org.gradle.util.GFileUtils;

public class InMemoryCacheFactory
implements CacheFactory {
    final Map<Pair<File, String>, PersistentIndexedCache<?, ?>> caches = Maps.newLinkedHashMap();

    @Override
    public PersistentCache open(File cacheDir, String displayName, Map<String, ?> properties, CacheBuilder.LockTarget lockTarget, LockOptions lockOptions, Action<? super PersistentCache> initializer, CleanupAction cleanup) throws CacheOpenException {
        GFileUtils.mkdirs(cacheDir);
        InMemoryCache cache = new InMemoryCache(cacheDir, displayName, cleanup);
        if (initializer != null) {
            initializer.execute(cache);
        }
        return cache;
    }

    public PersistentCache open(File cacheDir, String displayName) {
        return new InMemoryCache(cacheDir, displayName, CleanupAction.NO_OP);
    }

    private class InMemoryCache
    implements PersistentCache {
        private final File cacheDir;
        private final String displayName;
        private boolean closed;
        private final CleanupAction cleanup;

        public InMemoryCache(File cacheDir, String displayName, CleanupAction cleanup) {
            this.cacheDir = cacheDir;
            this.displayName = displayName;
            this.cleanup = cleanup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.cleanup != null) {
                InMemoryCache inMemoryCache = this;
                synchronized (inMemoryCache) {
                    this.cleanup.clean(this, CleanupProgressMonitor.NO_OP);
                }
            }
            this.closed = true;
        }

        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public File getBaseDir() {
            return this.cacheDir;
        }

        @Override
        public Collection<File> getReservedCacheFiles() {
            return Collections.emptyList();
        }

        private void assertNotClosed() {
            if (this.closed) {
                throw new IllegalStateException("cache is closed");
            }
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
            this.assertNotClosed();
            return this.createCache(name, valueSerializer);
        }

        @Override
        public <K, V> PersistentIndexedCache<K, V> createCache(PersistentIndexedCacheParameters<K, V> parameters) {
            this.assertNotClosed();
            return this.createCache(parameters.getCacheName(), parameters.getValueSerializer());
        }

        private <K, V> PersistentIndexedCache<K, V> createCache(String name, Serializer<V> valueSerializer) {
            this.assertNotClosed();
            PersistentIndexedCache<?, ?> indexedCache = InMemoryCacheFactory.this.caches.get(Pair.of(this.cacheDir, name));
            if (indexedCache == null) {
                indexedCache = new InMemoryIndexedCache(valueSerializer);
                InMemoryCacheFactory.this.caches.put(Pair.of(this.cacheDir, name), indexedCache);
            }
            return (PersistentIndexedCache)Cast.uncheckedCast(indexedCache);
        }

        @Override
        public <T> T withFileLock(Factory<? extends T> action) {
            return action.create();
        }

        @Override
        public void withFileLock(Runnable action) {
            action.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T useCache(Factory<? extends T> action) {
            this.assertNotClosed();
            InMemoryCache inMemoryCache = this;
            synchronized (inMemoryCache) {
                return action.create();
            }
        }

        @Override
        public void useCache(Runnable action) {
            this.assertNotClosed();
            action.run();
        }

        @Override
        public String getDisplayName() {
            return "InMemoryCache '" + this.displayName + "' " + this.cacheDir;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

