/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.ClassLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.codegen.IrCodegenUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceLowering;
import org.jetbrains.kotlin.backend.jvm.lower.InterfaceLowering$WhenMappings;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainerKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001cH\u0016J\u0014\u0010\u001d\u001a\u00020\u0010*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0014\u0010 \u001a\u00020\u0010*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002J\u0014\u0010!\u001a\u00020\u0010*\u00020\r2\u0006\u0010\"\u001a\u00020\rH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/InterfaceLowering;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "Lorg/jetbrains/kotlin/backend/common/ClassLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "removedFunctions", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lkotlin/collections/HashMap;", "createDefaultImpl", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "function", "handleAnnotationClass", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "handleInterface", "lower", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitFunctionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "bridgeToStatic", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "callTarget", "bridgeViaAccessorTo", "copyImplementationTo", "target", "backend.jvm"})
public final class InterfaceLowering
extends IrElementTransformerVoid
implements ClassLoweringPass {
    private final HashMap<IrFunctionSymbol, IrFunctionSymbol> removedFunctions;
    @NotNull
    private final JvmBackendContext context;

    @Override
    public void lower(@NotNull IrClass irClass) {
        Intrinsics.checkParameterIsNotNull((Object)irClass, (String)"irClass");
        if (!IrCodegenUtilsKt.isJvmInterface(irClass)) {
            return;
        }
        switch (InterfaceLowering$WhenMappings.$EnumSwitchMapping$0[irClass.getKind().ordinal()]) {
            case 1: {
                this.handleInterface(irClass);
                break;
            }
            case 2: {
                this.handleAnnotationClass(irClass);
                break;
            }
            default: {
                return;
            }
        }
        CollectionsKt.removeAll(irClass.getDeclarations(), (Function1)((Function1)new Function1<IrDeclaration, Boolean>(this){
            final /* synthetic */ InterfaceLowering this$0;

            public final boolean invoke(@NotNull IrDeclaration it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return it instanceof IrFunction && InterfaceLowering.access$getRemovedFunctions$p(this.this$0).containsKey(((IrFunction)it).getSymbol());
            }
            {
                this.this$0 = interfaceLowering;
                super(1);
            }
        }));
        IrClass defaultImplsIrClass = this.context.getDeclarationFactory().getDefaultImplsClass(irClass);
        Collection collection = defaultImplsIrClass.getDeclarations();
        boolean bl = false;
        if (!collection.isEmpty()) {
            irClass.getDeclarations().add(defaultImplsIrClass);
        }
        IrElementTransformerVoidKt.transformChildrenVoid(irClass, this);
    }

    /*
     * WARNING - void declaration
     */
    private final void handleInterface(IrClass irClass) {
        block15: {
            Object v3;
            IrClass defaultImplsIrClass;
            block14: {
                void $this$filterIsInstanceTo$iv$iv;
                for (IrSimpleFunction function2 : IrUtilsKt.getFunctions(irClass)) {
                    IrSimpleFunction defaultImpl;
                    if (function2.getModality() == Modality.ABSTRACT) continue;
                    if (Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.FAKE_OVERRIDE.INSTANCE)) {
                        IrSimpleFunction defaultImpl2;
                        IrSimpleFunction implementation;
                        if (IrUtilsKt.resolveFakeOverride(function2) == null) {
                            Intrinsics.throwNpe();
                        }
                        if (Visibilities.isPrivate(implementation.getVisibility()) || org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isMethodOfAny(implementation)) continue;
                        if (this.context.getState().getJvmDefaultMode().isCompatibility()) {
                            defaultImpl2 = this.createDefaultImpl(function2);
                            this.bridgeViaAccessorTo(defaultImpl2, function2);
                            continue;
                        }
                        if (org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.hasJvmDefault(implementation)) continue;
                        defaultImpl2 = this.createDefaultImpl(function2);
                        IrSimpleFunction irSimpleFunction = this.context.getDeclarationFactory().getDefaultImplsFunction(implementation);
                        boolean bl = false;
                        boolean bl2 = false;
                        IrSimpleFunction it = irSimpleFunction;
                        boolean bl3 = false;
                        this.bridgeToStatic(defaultImpl2, it);
                        continue;
                    }
                    if (Visibilities.isPrivate(function2.getVisibility()) && !org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.hasJvmDefault(function2) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)IrDeclarationOrigin.FUNCTION_FOR_DEFAULT_PARAMETER.INSTANCE) && !org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.hasJvmDefault(function2) || Intrinsics.areEqual((Object)function2.getOrigin(), (Object)JvmLoweredDeclarationOrigin.SYNTHETIC_METHOD_FOR_PROPERTY_ANNOTATIONS.INSTANCE)) {
                        defaultImpl = this.createDefaultImpl(function2);
                        this.copyImplementationTo(function2, defaultImpl);
                        ((Map)this.removedFunctions).put(function2.getSymbol(), defaultImpl.getSymbol());
                        continue;
                    }
                    if (!org.jetbrains.kotlin.backend.jvm.ir.IrUtilsKt.hasJvmDefault(function2)) {
                        defaultImpl = this.createDefaultImpl(function2);
                        this.copyImplementationTo(function2, defaultImpl);
                        function2.setBody(null);
                        continue;
                    }
                    if (!this.context.getState().getJvmDefaultMode().isCompatibility()) continue;
                    defaultImpl = this.createDefaultImpl(function2);
                    this.bridgeViaAccessorTo(defaultImpl, function2);
                }
                defaultImplsIrClass = this.context.getDeclarationFactory().getDefaultImplsClass(irClass);
                IrAttributeContainer irAttributeContainer = irClass.getAttributeOwnerId();
                if (irAttributeContainer == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                }
                List<IrLocalDelegatedPropertySymbol> localDelegatedProperties = this.context.getLocalDelegatedProperties$backend_jvm().get((IrClass)irAttributeContainer);
                if (localDelegatedProperties != null) {
                    IrAttributeContainer irAttributeContainer2 = defaultImplsIrClass.getAttributeOwnerId();
                    if (irAttributeContainer2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                    }
                    this.context.getLocalDelegatedProperties$backend_jvm().put((IrClass)irAttributeContainer2, localDelegatedProperties);
                    IrAttributeContainer irAttributeContainer3 = irClass.getAttributeOwnerId();
                    if (irAttributeContainer3 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
                    }
                    this.context.getLocalDelegatedProperties$backend_jvm().put((IrClass)irAttributeContainer3, CollectionsKt.emptyList());
                }
                Iterable $this$filterIsInstance$iv = irClass.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrField)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$singleOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    IrField it = (IrField)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getOrigin(), (Object)JvmLoweredDeclarationOrigin.GENERATED_PROPERTY_REFERENCE.INSTANCE)) continue;
                    if (found$iv) {
                        v3 = null;
                        break block14;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v3 = !found$iv ? null : single$iv;
            }
            IrField delegatedPropertyArray = v3;
            if (delegatedPropertyArray == null) break block15;
            irClass.getDeclarations().remove(delegatedPropertyArray);
            defaultImplsIrClass.getDeclarations().add(0, delegatedPropertyArray);
            delegatedPropertyArray.setParent(defaultImplsIrClass);
            IrExpressionBody irExpressionBody = delegatedPropertyArray.getInitializer();
            if (irExpressionBody != null) {
                IrExpressionBody cfr_ignored_0 = (IrExpressionBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irExpressionBody, defaultImplsIrClass);
            }
        }
    }

    private final void handleAnnotationClass(IrClass irClass) {
        Sequence annotationsMethods2 = SequencesKt.filter(IrUtilsKt.getFunctions(irClass), (Function1)handleAnnotationClass.annotationsMethods.1.INSTANCE);
        if (SequencesKt.none((Sequence)annotationsMethods2)) {
            return;
        }
        for (IrSimpleFunction function2 : annotationsMethods2) {
            ((Map)this.removedFunctions).put(function2.getSymbol(), this.createDefaultImpl(function2).getSymbol());
        }
    }

    private final IrSimpleFunction createDefaultImpl(IrSimpleFunction function2) {
        IrSimpleFunction irSimpleFunction = this.context.getDeclarationFactory().getDefaultImplsFunction(function2);
        boolean bl = false;
        boolean bl2 = false;
        IrSimpleFunction newFunction = irSimpleFunction;
        boolean bl3 = false;
        IrBody irBody = function2.getBody();
        newFunction.setBody(irBody != null ? (IrBody)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irBody, newFunction) : null);
        IrUtilsKt.getParentAsClass(newFunction).getDeclarations().add(newFunction);
        return irSimpleFunction;
    }

    private final void copyImplementationTo(@NotNull IrSimpleFunction $this$copyImplementationTo, IrSimpleFunction target) {
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyBodyToStatic($this$copyImplementationTo, target);
    }

    /*
     * WARNING - void declaration
     */
    private final void bridgeToStatic(@NotNull IrFunction $this$bridgeToStatic, IrFunction callTarget) {
        IrCallImpl irCallImpl = new IrCallImpl($this$bridgeToStatic.getStartOffset(), $this$bridgeToStatic.getEndOffset(), $this$bridgeToStatic.getReturnType(), callTarget.getSymbol(), null, null, 48, null);
        IrFunction irFunction = $this$bridgeToStatic;
        boolean bl = false;
        boolean bl2 = false;
        IrCallImpl call2 = irCallImpl;
        boolean bl3 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.passTypeArgumentsFrom$default(call2, $this$bridgeToStatic, 0, 2, null);
        Iterable $this$forEachIndexed$iv = $this$bridgeToStatic.getValueParameters();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void it;
            int n = index$iv++;
            boolean bl4 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            int n2 = n;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv;
            int i2 = n2;
            boolean bl5 = false;
            call2.putValueArgument(i2, new IrGetValueImpl($this$bridgeToStatic.getStartOffset(), $this$bridgeToStatic.getEndOffset(), it.getSymbol(), null, 8, null));
        }
        IrCallImpl irCallImpl2 = irCallImpl;
        IrExpression irExpression = irCallImpl2;
        irFunction.setBody(new IrExpressionBodyImpl(irExpression));
    }

    /*
     * WARNING - void declaration
     */
    private final void bridgeViaAccessorTo(@NotNull IrFunction $this$bridgeViaAccessorTo, IrFunction callTarget) {
        IrValueParameter it;
        boolean bl;
        int n;
        IrValueParameter irValueParameter;
        IrCallImpl irCallImpl = new IrCallImpl($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getReturnType(), callTarget.getSymbol(), null, (IrClassSymbol)IrUtilsKt.getParentAsClass(callTarget).getSymbol(), 16, null);
        IrFunction irFunction = $this$bridgeViaAccessorTo;
        boolean bl2 = false;
        boolean bl3 = false;
        IrCallImpl call2 = irCallImpl;
        boolean bl4 = false;
        org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.passTypeArgumentsFrom$default(call2, $this$bridgeViaAccessorTo, 0, 2, null);
        int offset2 = 0;
        IrValueParameter irValueParameter2 = callTarget.getDispatchReceiverParameter();
        if (irValueParameter2 != null) {
            irValueParameter = irValueParameter2;
            n = 0;
            bl = false;
            it = irValueParameter;
            boolean bl5 = false;
            call2.setDispatchReceiver(new IrGetValueImpl($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get(offset2).getSymbol(), null, 8, null));
            ++offset2;
        }
        IrValueParameter irValueParameter3 = callTarget.getExtensionReceiverParameter();
        if (irValueParameter3 != null) {
            irValueParameter = irValueParameter3;
            n = 0;
            bl = false;
            it = irValueParameter;
            boolean bl6 = false;
            call2.setExtensionReceiver(new IrGetValueImpl($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get(offset2).getSymbol(), null, 8, null));
            ++offset2;
        }
        int n2 = offset2;
        n = $this$bridgeViaAccessorTo.getValueParameters().size();
        while (n2 < n) {
            void i2;
            call2.putValueArgument((int)(i2 - offset2), new IrGetValueImpl($this$bridgeViaAccessorTo.getStartOffset(), $this$bridgeViaAccessorTo.getEndOffset(), $this$bridgeViaAccessorTo.getValueParameters().get((int)i2).getSymbol(), null, 8, null));
            ++i2;
        }
        IrCallImpl irCallImpl2 = irCallImpl;
        IrExpression irExpression = irCallImpl2;
        irFunction.setBody(new IrExpressionBodyImpl(irExpression));
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        IrReturn irReturn;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Map map2 = this.removedFunctions;
        IrReturnTargetSymbol irReturnTargetSymbol = expression2.getReturnTargetSymbol();
        boolean bl = false;
        IrFunctionSymbol irFunctionSymbol = (IrFunctionSymbol)map2.get(irReturnTargetSymbol);
        IrFunction newFunction = irFunctionSymbol != null ? irFunctionSymbol.getOwner() : null;
        InterfaceLowering interfaceLowering = this;
        if (newFunction != null) {
            InterfaceLowering interfaceLowering2 = interfaceLowering;
            boolean bl2 = false;
            boolean bl3 = false;
            IrReturn $this$with = expression2;
            boolean bl4 = false;
            IrReturnImpl irReturnImpl = new IrReturnImpl($this$with.getStartOffset(), $this$with.getEndOffset(), $this$with.getType(), newFunction.getSymbol(), $this$with.getValue());
            interfaceLowering = interfaceLowering2;
            irReturn = irReturnImpl;
        } else {
            irReturn = expression2;
        }
        return super.visitReturn(irReturn);
    }

    @Override
    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrFunctionSymbol irFunctionSymbol = this.removedFunctions.get(expression2.getSymbol());
        IrFunction newFunction = irFunctionSymbol != null ? irFunctionSymbol.getOwner() : null;
        return super.visitCall(newFunction != null ? IrUtilsKt.irCall$default((IrFunctionAccessExpression)expression2, newFunction, true, false, null, 24, null) : expression2);
    }

    @Override
    @NotNull
    public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrFunctionReference irFunctionReference;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrFunctionSymbol irFunctionSymbol = this.removedFunctions.get(expression2.getSymbol());
        IrFunction newFunction = irFunctionSymbol != null ? irFunctionSymbol.getOwner() : null;
        InterfaceLowering interfaceLowering = this;
        if (newFunction != null) {
            InterfaceLowering interfaceLowering2 = interfaceLowering;
            boolean bl = false;
            boolean bl2 = false;
            IrFunctionReference $this$with = expression2;
            boolean bl3 = false;
            IrFunctionReferenceImpl irFunctionReferenceImpl = new IrFunctionReferenceImpl($this$with.getStartOffset(), $this$with.getEndOffset(), $this$with.getType(), newFunction.getSymbol(), $this$with.getTypeArgumentsCount(), $this$with.getOrigin());
            boolean bl4 = false;
            boolean bl5 = false;
            IrFunctionReferenceImpl $this$apply = irFunctionReferenceImpl;
            boolean bl6 = false;
            IrUtilsKt.copyTypeAndValueArgumentsFrom$default($this$apply, expression2, true, false, 4, null);
            IrAttributeContainerKt.copyAttributes((IrAttributeContainer)$this$apply, expression2);
            IrFunctionReferenceImpl irFunctionReferenceImpl2 = irFunctionReferenceImpl;
            interfaceLowering = interfaceLowering2;
            irFunctionReference = irFunctionReferenceImpl2;
        } else {
            irFunctionReference = expression2;
        }
        return super.visitFunctionReference(irFunctionReference);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public InterfaceLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        this.context = context2;
        InterfaceLowering interfaceLowering = this;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        interfaceLowering.removedFunctions = hashMap;
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull((Object)irFile, (String)"irFile");
        ClassLoweringPass.DefaultImpls.lower(this, irFile);
    }

    public static final /* synthetic */ HashMap access$getRemovedFunctions$p(InterfaceLowering $this) {
        return $this.removedFunctions;
    }
}

