/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathsList;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.console.KotlinConsoleKeeperKt;
import org.jetbrains.kotlin.console.KotlinConsoleRunner;
import org.jetbrains.kotlin.idea.util.JavaParametersBuilder;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\u0007J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "consoleMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/kotlin/console/KotlinConsoleRunner;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConsoleByVirtualFile", "virtualFile", "putVirtualFileToConsole", "console", "removeConsole", "run", "module", "Lcom/intellij/openapi/module/Module;", "previousCompilationFailed", "", "Companion", "idea"})
public final class KotlinConsoleKeeper {
    private final Map<VirtualFile, KotlinConsoleRunner> consoleMap;
    @NotNull
    private final Project project;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final KotlinConsoleRunner getConsoleByVirtualFile(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        return this.consoleMap.get(virtualFile2);
    }

    @Nullable
    public final KotlinConsoleRunner putVirtualFileToConsole(@NotNull VirtualFile virtualFile2, @NotNull KotlinConsoleRunner console) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        Intrinsics.checkParameterIsNotNull((Object)((Object)console), (String)"console");
        return this.consoleMap.put(virtualFile2, console);
    }

    @Nullable
    public final KotlinConsoleRunner removeConsole(@NotNull VirtualFile virtualFile2) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile2, (String)"virtualFile");
        return this.consoleMap.remove(virtualFile2);
    }

    @Nullable
    public final KotlinConsoleRunner run(@NotNull Module module, boolean previousCompilationFailed) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        String string = module.getModuleFilePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.moduleFilePath");
        String path2 = string;
        GeneralCommandLine cmdLine = Companion.createReplCommandLine(this.project, module);
        KotlinConsoleRunner consoleRunner = new KotlinConsoleRunner(module, cmdLine, previousCompilationFailed, this.project, KotlinConsoleKeeperKt.access$getREPL_TITLE$p(), path2);
        consoleRunner.initAndRun();
        return consoleRunner;
    }

    public static /* synthetic */ KotlinConsoleRunner run$default(KotlinConsoleKeeper kotlinConsoleKeeper, Module module, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kotlinConsoleKeeper.run(module, bl);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public KotlinConsoleKeeper(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.consoleMap = new ConcurrentHashMap();
    }

    @JvmStatic
    public static final KotlinConsoleKeeper getInstance(@NotNull Project project2) {
        return Companion.getInstance(project2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper$Companion;", "", "()V", "createReplCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "getInstance", "Lorg/jetbrains/kotlin/console/KotlinConsoleKeeper;", "kotlin.jvm.PlatformType", "idea"})
    public static final class Companion {
        @JvmStatic
        public final KotlinConsoleKeeper getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            return (KotlinConsoleKeeper)ServiceManager.getService((Project)project2, KotlinConsoleKeeper.class);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final GeneralCommandLine createReplCommandLine(@NotNull Project project2, @Nullable Module module) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            JavaParameters javaParameters = new JavaParametersBuilder(project2).withSdkFrom(module, true).withMainClassName("org.jetbrains.kotlin.cli.jvm.K2JVMCompiler").build();
            javaParameters.setCharset((Charset)null);
            javaParameters.getVMParametersList().add("-Dkotlin.repl.ideMode=true");
            PathsList pathsList = javaParameters.getClassPath();
            boolean bl = false;
            boolean bl2 = false;
            PathsList $this$apply = pathsList;
            boolean bl3 = false;
            KotlinPaths kotlinPaths = PathUtil.getKotlinPathsForIdeaPlugin();
            Iterable iterable = kotlinPaths.getCompilerClasspath();
            PathsList pathsList2 = $this$apply;
            boolean $i$f$map = false;
            void var13_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                File file2 = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl4 = false;
                String string = it.getAbsolutePath();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            pathsList2.addAll((List)collection);
            $this$apply.add(kotlinPaths.getCompilerPath().getAbsolutePath());
            if (module != null) {
                List<String> classPath2 = JavaParametersBuilder.Companion.getModuleDependencies(module);
                Collection collection2 = classPath2;
                bl2 = false;
                if (!collection2.isEmpty()) {
                    javaParameters.setUseDynamicParameters(javaParameters.isDynamicClasspath());
                    javaParameters.getProgramParametersList().add("-cp");
                    ParametersList parametersList = javaParameters.getProgramParametersList();
                    Iterable iterable2 = classPath2;
                    String string = File.pathSeparator;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"File.pathSeparator");
                    parametersList.add(CollectionsKt.joinToString$default((Iterable)iterable2, (CharSequence)string, null, null, (int)0, null, null, (int)62, null));
                }
            }
            GeneralCommandLine generalCommandLine = javaParameters.toCommandLine();
            Intrinsics.checkExpressionValueIsNotNull((Object)generalCommandLine, (String)"javaParameters.toCommandLine()");
            return generalCommandLine;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

