/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.resolve.ImplicitReceiverStack;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitDispatchReceiverValue;
import org.jetbrains.kotlin.fir.resolve.calls.ImplicitReceiverValue;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u00012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00072\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0016J\u0019\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\u000e\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\bJ\u0019\u0010\u001b\u001a\u0004\u0018\u00010\b2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030\u000b\u00a2\u0006\u0002\u0010\u001dJ\u0013\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u001fH\u0096\u0002J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0012\u0010\"\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030$H\u0016J\u0016\u0010%\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u000eR\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStackImpl;", "Lorg/jetbrains/kotlin/fir/resolve/ImplicitReceiverStack;", "", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitReceiverValue;", "()V", "indexesPerLabel", "Lcom/google/common/collect/SetMultimap;", "Lorg/jetbrains/kotlin/name/Name;", "", "indexesPerSymbol", "", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "originalTypes", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "size", "getSize", "()I", "stack", "add", "", "name", "value", "get", "", "getOriginalType", "index", "getReceiverIndex", "symbol", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Ljava/lang/Integer;", "iterator", "", "lastDispatchReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ImplicitDispatchReceiverValue;", "pop", "receiversAsReversed", "", "replaceReceiverType", "type", "resolve"})
public final class ImplicitReceiverStackImpl
implements ImplicitReceiverStack,
Iterable<ImplicitReceiverValue<?>>,
KMappedMarker {
    private final List<ImplicitReceiverValue<?>> stack;
    private final List<ConeKotlinType> originalTypes;
    private final SetMultimap<Name, Integer> indexesPerLabel;
    private final Map<FirBasedSymbol<?>, Integer> indexesPerSymbol;

    public final int getSize() {
        return this.stack.size();
    }

    @Override
    public void add(@Nullable Name name2, @NotNull ImplicitReceiverValue<?> value2) {
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        Collection collection = this.stack;
        boolean bl = false;
        collection.add(value2);
        collection = this.originalTypes;
        ConeKotlinType coneKotlinType = value2.getType();
        boolean bl2 = false;
        collection.add(coneKotlinType);
        int index2 = this.stack.size() - 1;
        if (name2 != null) {
            this.indexesPerLabel.put((Object)name2, (Object)index2);
        }
        this.indexesPerSymbol.put((FirBasedSymbol<?>)value2.getBoundSymbol(), index2);
    }

    @Override
    public void pop(@Nullable Name name2) {
        int index2 = this.stack.size() - 1;
        if (name2 != null) {
            this.indexesPerLabel.remove((Object)name2, (Object)index2);
        }
        this.originalTypes.remove(index2);
        ImplicitReceiverValue<?> value2 = this.stack.remove(index2);
        this.indexesPerSymbol.remove(value2.getBoundSymbol());
    }

    @Override
    @Nullable
    public ImplicitReceiverValue<?> get(@Nullable String name2) {
        ImplicitReceiverValue<?> implicitReceiverValue;
        if (name2 == null) {
            return (ImplicitReceiverValue)CollectionsKt.lastOrNull(this.stack);
        }
        Set set2 = this.indexesPerLabel.get((Object)Name.identifier(name2));
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"indexesPerLabel[Name.identifier(name)]");
        Integer n = (Integer)CollectionsKt.lastOrNull((Iterable)set2);
        if (n != null) {
            Integer n2 = n;
            boolean bl = false;
            boolean bl2 = false;
            int it = ((Number)n2).intValue();
            boolean bl3 = false;
            implicitReceiverValue = this.stack.get(it);
        } else {
            implicitReceiverValue = null;
        }
        return implicitReceiverValue;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public ImplicitDispatchReceiverValue lastDispatchReceiver() {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = this.stack;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ImplicitDispatchReceiverValue)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (ImplicitDispatchReceiverValue)CollectionsKt.lastOrNull((List)((List)destination$iv$iv));
    }

    @Override
    @NotNull
    public List<ImplicitReceiverValue<?>> receiversAsReversed() {
        return CollectionsKt.asReversedMutable(this.stack);
    }

    @Nullable
    public final Integer getReceiverIndex(@NotNull FirBasedSymbol<?> symbol2) {
        Intrinsics.checkParameterIsNotNull(symbol2, (String)"symbol");
        return this.indexesPerSymbol.get(symbol2);
    }

    @NotNull
    public final ConeKotlinType getOriginalType(int index2) {
        return this.originalTypes.get(index2);
    }

    public final void replaceReceiverType(int index2, @NotNull ConeKotlinType type2) {
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        boolean bl = index2 >= 0 && index2 < this.stack.size();
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        this.stack.get(index2).replaceType$resolve(type2);
    }

    @Override
    @NotNull
    public Iterator<ImplicitReceiverValue<?>> iterator() {
        return this.stack.iterator();
    }

    public ImplicitReceiverStackImpl() {
        ImplicitReceiverStackImpl implicitReceiverStackImpl = this;
        boolean bl = false;
        Object object = new ArrayList();
        implicitReceiverStackImpl.stack = object;
        implicitReceiverStackImpl = this;
        bl = false;
        object = new ArrayList();
        implicitReceiverStackImpl.originalTypes = object;
        LinkedHashMultimap linkedHashMultimap = LinkedHashMultimap.create();
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedHashMultimap, (String)"LinkedHashMultimap.create()");
        this.indexesPerLabel = (SetMultimap)linkedHashMultimap;
        implicitReceiverStackImpl = this;
        bl = false;
        implicitReceiverStackImpl.indexesPerSymbol = object = (Map)new LinkedHashMap();
    }
}

