/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirCallResolver;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.impl.FirErrorNamedReferenceImpl;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateApplicability;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSinkImpl;
import org.jetbrains.kotlin.fir.resolve.calls.FirNamedReferenceWithCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.InferenceCompletionKt;
import org.jetbrains.kotlin.fir.resolve.calls.InferenceComponents;
import org.jetbrains.kotlin.fir.resolve.calls.LambdaAnalyzer;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.fir.resolve.calls.ResolvedLambdaAtom;
import org.jetbrains.kotlin.fir.resolve.diagnostics.FirUnresolvedReferenceError;
import org.jetbrains.kotlin.fir.resolve.transformers.StoreNameReference;
import org.jetbrains.kotlin.fir.symbols.StandardClassIds;
import org.jetbrains.kotlin.fir.symbols.StandardTypesKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirResolvedTypeRefImpl;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.PostponedArgumentsAnalyzer;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.StubTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/PostponedArgumentsAnalyzer;", "", "lambdaAnalyzer", "Lorg/jetbrains/kotlin/fir/resolve/calls/LambdaAnalyzer;", "typeProvider", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "components", "Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "replacements", "", "callResolver", "Lorg/jetbrains/kotlin/fir/FirCallResolver;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/LambdaAnalyzer;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/fir/resolve/calls/InferenceComponents;Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/FirCallResolver;)V", "analyze", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/components/PostponedArgumentsAnalyzer$Context;", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtomMarker;", "analyzeLambda", "lambda", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedLambdaAtom;", "processCallableReference", "atom", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolvedCallableReferenceAtom;", "resolve"})
public final class PostponedArgumentsAnalyzer {
    private final LambdaAnalyzer lambdaAnalyzer;
    private final Function1<FirExpression, FirTypeRef> typeProvider;
    private final InferenceComponents components;
    private final Candidate candidate;
    private final Map<FirExpression, FirExpression> replacements;
    private final FirCallResolver callResolver;

    public final void analyze(@NotNull PostponedArgumentsAnalyzer.Context c, @NotNull PostponedResolvedAtomMarker argument2) {
        Intrinsics.checkParameterIsNotNull((Object)c, (String)"c");
        Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
        PostponedResolvedAtomMarker postponedResolvedAtomMarker = argument2;
        if (postponedResolvedAtomMarker instanceof ResolvedLambdaAtom) {
            this.analyzeLambda(c, (ResolvedLambdaAtom)argument2);
        } else if (postponedResolvedAtomMarker instanceof ResolvedCallableReferenceAtom) {
            this.processCallableReference((ResolvedCallableReferenceAtom)argument2);
        } else {
            String string = "Unexpected resolved primitive: " + argument2.getClass().getCanonicalName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processCallableReference(ResolvedCallableReferenceAtom atom) {
        void candidate2;
        if (atom.getPostponed()) {
            this.callResolver.resolveCallableReference(InferenceCompletionKt.getCsBuilder(this.candidate), atom);
        }
        FirCallableReferenceAccess callableReferenceAccess = atom.getReference();
        atom.setAnalyzed(true);
        Pair pair2 = atom.getResultingCandidate();
        if (pair2 == null) {
            pair2 = new Pair(null, (Object)CandidateApplicability.INAPPLICABLE);
        }
        Pair pair3 = pair2;
        Candidate candidate3 = (Candidate)pair3.component1();
        CandidateApplicability applicability = (CandidateApplicability)((Object)pair3.component2());
        FirNamedReference namedReference = candidate2 == null || applicability.compareTo((Enum)CandidateApplicability.SYNTHETIC_RESOLVED) < 0 ? (FirNamedReference)new FirErrorNamedReferenceImpl(callableReferenceAccess.getSource(), new FirUnresolvedReferenceError(callableReferenceAccess.getCalleeReference().getName())) : (FirNamedReference)new FirNamedReferenceWithCandidate(callableReferenceAccess.getSource(), callableReferenceAccess.getCalleeReference().getName(), (Candidate)candidate2);
        FirCallableReferenceAccess firCallableReferenceAccess = callableReferenceAccess.transformCalleeReference(StoreNameReference.INSTANCE, namedReference);
        boolean bl = false;
        boolean bl2 = false;
        FirCallableReferenceAccess $this$apply = firCallableReferenceAccess;
        boolean bl3 = false;
        if (candidate2 != null) {
            ConeKotlinType coneKotlinType = candidate2.getResultingTypeForCallableReference();
            if (coneKotlinType == null) {
                Intrinsics.throwNpe();
            }
            $this$apply.replaceTypeRef(new FirResolvedTypeRefImpl(null, coneKotlinType));
        }
        FirCallableReferenceAccess transformedCalleeReference = firCallableReferenceAccess;
        this.replacements.put(callableReferenceAccess, transformedCalleeReference);
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzeLambda(PostponedArgumentsAnalyzer.Context c, ResolvedLambdaAtom lambda2) {
        void $this$mapTo$iv$iv;
        void returnArguments;
        List $this$mapTo$iv$iv2;
        ConeKotlinType coneKotlinType;
        Object p1;
        ConeKotlinType $this$mapKeysTo$iv$iv;
        void $this$mapKeys$iv;
        Map<TypeVariableMarker, StubTypeMarker> stubsForPostponedVariables;
        Object object = StandardTypesKt.invoke(StandardClassIds.INSTANCE.getUnit(), ResolveUtilsKt.getFirSymbolProvider(this.components.getSession()));
        Object object2 = new ConeKotlinTypeProjection[]{};
        ConeLookupTagBasedType unitType = ResolveUtilsKt.constructType(object, (ConeKotlinTypeProjection[])object2, false);
        Map<TypeVariableMarker, StubTypeMarker> map2 = stubsForPostponedVariables = c.bindingStubsForPostponedVariables();
        object = c;
        boolean $i$f$mapKeys = false;
        void var8_10 = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            TypeConstructorMarker typeConstructorMarker = MarkerExtensionsKt.freshTypeConstructor((TypeVariableMarker)it.getKey(), c);
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            TypeConstructorMarker typeConstructorMarker2 = typeConstructorMarker;
            Object object3 = object2;
            boolean bl2 = false;
            Object v = it$iv$iv.getValue();
            object3.put(typeConstructorMarker2, v);
        }
        object2 = destination$iv$iv2;
        TypeSubstitutorMarker currentSubstitutor2 = object.buildCurrentSubstitutor((Map<TypeConstructorMarker, ? extends StubTypeMarker>)object2);
        Function1<ConeKotlinType, ConeKotlinType> $fun$substitute$1 = new Function1<ConeKotlinType, ConeKotlinType>(currentSubstitutor2, c){
            final /* synthetic */ TypeSubstitutorMarker $currentSubstitutor;
            final /* synthetic */ PostponedArgumentsAnalyzer.Context $c;

            @NotNull
            public final ConeKotlinType invoke(@NotNull ConeKotlinType type2) {
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                KotlinTypeMarker kotlinTypeMarker = MarkerExtensionsKt.safeSubstitute(this.$currentSubstitutor, this.$c, type2);
                if (kotlinTypeMarker == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.ConeKotlinType");
                }
                return (ConeKotlinType)kotlinTypeMarker;
            }
            {
                this.$currentSubstitutor = typeSubstitutorMarker;
                this.$c = context2;
                super(1);
            }
        };
        ConeKotlinType coneKotlinType2 = lambda2.getReceiver();
        if (coneKotlinType2 != null) {
            $this$mapKeysTo$iv$iv = coneKotlinType2;
            boolean destination$iv$iv2 = false;
            $i$f$mapKeysTo = false;
            p1 = $this$mapKeysTo$iv$iv;
            boolean bl = false;
            coneKotlinType = $fun$substitute$1.invoke((ConeKotlinType)p1);
        } else {
            coneKotlinType = null;
        }
        ConeKotlinType receiver2 = coneKotlinType;
        Iterable $this$map$iv = lambda2.getParameters();
        boolean $i$f$map = false;
        p1 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p12;
            ConeKotlinType bl = (ConeKotlinType)item$iv$iv;
            object = destination$iv$iv3;
            boolean bl3 = false;
            object2 = $fun$substitute$1.invoke((ConeKotlinType)p12);
            object.add(object2);
        }
        List parameters2 = (List)destination$iv$iv3;
        ConeKotlinType rawReturnType = lambda2.getReturnType();
        ConeKotlinType expectedTypeForReturnArguments = c.canBeProper(rawReturnType) ? $fun$substitute$1.invoke(rawReturnType) : (c.hasUpperOrEqualUnitConstraint(rawReturnType) ? (ConeKotlinType)unitType : null);
        Pair<List<FirStatement>, InferenceSession> $i$f$mapTo22 = this.lambdaAnalyzer.analyzeAndGetLambdaReturnArguments(lambda2.getAtom(), lambda2.isSuspend(), receiver2, parameters2, expectedTypeForReturnArguments, rawReturnType, stubsForPostponedVariables);
        $this$mapTo$iv$iv2 = (List)$i$f$mapTo22.component1();
        InferenceSession inferenceSession = (InferenceSession)$i$f$mapTo22.component2();
        Iterable $this$forEach$iv = (Iterable)returnArguments;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirStatement it = (FirStatement)element$iv;
            boolean bl = false;
            CandidateFactoryKt.addSubsystemFromExpression(c, it);
        }
        CheckerSink checkerSink = new CheckerSinkImpl(this.components, null, 2, null);
        Iterable $this$map$iv2 = (Iterable)returnArguments;
        boolean $i$f$map2 = false;
        Iterable it = $this$map$iv2;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            FirStatement firStatement = (FirStatement)item$iv$iv;
            object = destination$iv$iv4;
            boolean bl = false;
            if (it2 instanceof FirExpression) {
                PostponedResolvedAtomMarker atom = null;
                ConeKotlinType coneKotlinType3 = lambda2.getReturnType();
                FirExpression firExpression2 = (FirExpression)it2;
                ConstraintSystemBuilder constraintSystemBuilder = c.getBuilder();
                Candidate candidate2 = this.candidate;
                boolean bl4 = false;
                boolean bl5 = false;
                ConeKotlinType p13 = coneKotlinType3;
                boolean bl6 = false;
                ConeKotlinType coneKotlinType4 = $fun$substitute$1.invoke(p13);
                ArgumentsKt.resolveArgumentExpression(candidate2, constraintSystemBuilder, firExpression2, coneKotlinType4, lambda2.getAtom().getReturnTypeRef(), checkerSink, false, false, false, this.typeProvider);
            }
            object2 = Unit.INSTANCE;
            object.add(object2);
        }
        List subResolvedKtPrimitives = (List)destination$iv$iv4;
        if (returnArguments.isEmpty()) {
            ConeKotlinType coneKotlinType5 = lambda2.getReturnType();
            boolean bl = false;
            boolean bl7 = false;
            ConeKotlinType p14 = coneKotlinType5;
            boolean bl8 = false;
            ConeKotlinType lambdaReturnType = $fun$substitute$1.invoke(p14);
            c.getBuilder().addSubtypeConstraint(lambdaReturnType, unitType, SimpleConstraintSystemConstraintPosition.INSTANCE);
            c.getBuilder().addSubtypeConstraint(unitType, lambdaReturnType, SimpleConstraintSystemConstraintPosition.INSTANCE);
        }
        lambda2.setAnalyzed(true);
        lambda2.setReturnStatements((List<? extends FirStatement>)returnArguments);
    }

    public PostponedArgumentsAnalyzer(@NotNull LambdaAnalyzer lambdaAnalyzer, @NotNull Function1<? super FirExpression, ? extends FirTypeRef> typeProvider, @NotNull InferenceComponents components, @NotNull Candidate candidate2, @NotNull Map<FirExpression, FirExpression> replacements, @NotNull FirCallResolver callResolver) {
        Intrinsics.checkParameterIsNotNull((Object)lambdaAnalyzer, (String)"lambdaAnalyzer");
        Intrinsics.checkParameterIsNotNull(typeProvider, (String)"typeProvider");
        Intrinsics.checkParameterIsNotNull((Object)components, (String)"components");
        Intrinsics.checkParameterIsNotNull((Object)candidate2, (String)"candidate");
        Intrinsics.checkParameterIsNotNull(replacements, (String)"replacements");
        Intrinsics.checkParameterIsNotNull((Object)callResolver, (String)"callResolver");
        this.lambdaAnalyzer = lambdaAnalyzer;
        this.typeProvider = typeProvider;
        this.components = components;
        this.candidate = candidate2;
        this.replacements = replacements;
        this.callResolver = callResolver;
    }
}

