/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.generate;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.lang.ContextAwareActionHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0000H\u0014J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006H$J \u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u0011\u001a\u00020\fH\u0016J:\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/actions/generate/KotlinGenerateActionBase;", "Lcom/intellij/codeInsight/actions/CodeInsightAction;", "Lcom/intellij/codeInsight/CodeInsightActionHandler;", "()V", "getHandler", "getTargetClass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isValidForClass", "", "targetClass", "isValidForFile", "project", "Lcom/intellij/openapi/project/Project;", "startInWriteAction", "update", "", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "actionPlace", "", "idea"})
public abstract class KotlinGenerateActionBase
extends CodeInsightAction
implements CodeInsightActionHandler {
    protected void update(@NotNull Presentation presentation, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2, @NotNull DataContext dataContext, @Nullable String actionPlace) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        super.update(presentation, project2, editor2, file2, dataContext, actionPlace);
        KotlinGenerateActionBase actionHandler = this.getHandler();
        if (actionHandler instanceof ContextAwareActionHandler && presentation.isEnabled()) {
            presentation.setEnabled(((ContextAwareActionHandler)actionHandler).isAvailableForQuickList(editor2, file2, dataContext));
        }
    }

    protected boolean isValidForFile(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (!(file2 instanceof KtFile) || ((KtFile)file2).isCompiled()) {
            return false;
        }
        KtClassOrObject ktClassOrObject = this.getTargetClass(editor2, file2);
        if (ktClassOrObject == null) {
            return false;
        }
        KtClassOrObject targetClass = ktClassOrObject;
        return KotlinRefactoringUtilKt.canRefactor(targetClass) && this.isValidForClass(targetClass);
    }

    @Nullable
    protected KtClassOrObject getTargetClass(@NotNull Editor editor2, @NotNull PsiFile file2) {
        KtClassOrObject ktClassOrObject;
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        PsiElement psiElement2 = file2.findElementAt(caretModel.getOffset());
        if (psiElement2 != null) {
            PsiElement $this$getNonStrictParentOfType$iv = psiElement2;
            boolean $i$f$getNonStrictParentOfType = false;
            ktClassOrObject = (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false);
        } else {
            ktClassOrObject = null;
        }
        return ktClassOrObject;
    }

    protected abstract boolean isValidForClass(@NotNull KtClassOrObject var1);

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected KotlinGenerateActionBase getHandler() {
        return this;
    }
}

