/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.lightClasses;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.ClsFileImpl;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0005R/\u0010\u0003\u001a#\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u00070\u0004\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/caches/lightClasses/ClsJavaStubByVirtualFileCache;", "", "()V", "cache", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/kotlin/idea/caches/lightClasses/ClsJavaStubByVirtualFileCache$CachedJavaStub;", "Lorg/jetbrains/annotations/NotNull;", "createStub", "Lcom/intellij/psi/impl/java/stubs/PsiJavaFileStub;", "file", "get", "Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "classFile", "CachedJavaStub", "Companion", "idea-core"})
public final class ClsJavaStubByVirtualFileCache {
    private final ConcurrentMap<VirtualFile, CachedJavaStub> cache;
    private static final Logger LOG;
    public static final Companion Companion;

    @Nullable
    public final PsiJavaFileStubImpl get(@NotNull VirtualFile classFile) {
        Intrinsics.checkParameterIsNotNull((Object)classFile, (String)"classFile");
        CachedJavaStub cached2 = (CachedJavaStub)this.cache.get(classFile);
        long fileModificationStamp = classFile.getModificationStamp();
        if (cached2 != null && cached2.getModificationStamp() == fileModificationStamp) {
            return cached2.getJavaFileStub();
        }
        PsiJavaFileStubImpl psiJavaFileStubImpl = (PsiJavaFileStubImpl)this.createStub(classFile);
        if (psiJavaFileStubImpl == null) {
            return null;
        }
        PsiJavaFileStubImpl stub = psiJavaFileStubImpl;
        this.cache.put(classFile, new CachedJavaStub(fileModificationStamp, stub));
        return stub;
    }

    private final PsiJavaFileStub createStub(VirtualFile file2) {
        if (file2.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        try {
            return ClsFileImpl.buildFileStub((VirtualFile)file2, (byte[])file2.contentsToByteArray(false));
        }
        catch (ClsFormatException e) {
            StringBuilder stringBuilder2 = new StringBuilder().append("Failed to build java cls class for ");
            String string = file2.getCanonicalPath();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            LOG.error(stringBuilder2.append(string).toString(), (Throwable)e);
        }
        catch (IOException e) {
            StringBuilder stringBuilder3 = new StringBuilder().append("Failed to build java cls class for ");
            String string = file2.getCanonicalPath();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            LOG.error(stringBuilder3.append(string).toString(), (Throwable)e);
        }
        return null;
    }

    public ClsJavaStubByVirtualFileCache() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeySoftValueMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentMap, (String)"ContainerUtil.createConc\u2026alFile, CachedJavaStub>()");
        this.cache = concurrentMap;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ClsJavaStubByVirtualFileCache.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(ClsJa\u2026ualFileCache::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/caches/lightClasses/ClsJavaStubByVirtualFileCache$CachedJavaStub;", "", "modificationStamp", "", "javaFileStub", "Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "(JLcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;)V", "getJavaFileStub", "()Lcom/intellij/psi/impl/java/stubs/impl/PsiJavaFileStubImpl;", "getModificationStamp", "()J", "idea-core"})
    private static final class CachedJavaStub {
        private final long modificationStamp;
        @NotNull
        private final PsiJavaFileStubImpl javaFileStub;

        public final long getModificationStamp() {
            return this.modificationStamp;
        }

        @NotNull
        public final PsiJavaFileStubImpl getJavaFileStub() {
            return this.javaFileStub;
        }

        public CachedJavaStub(long modificationStamp, @NotNull PsiJavaFileStubImpl javaFileStub) {
            Intrinsics.checkParameterIsNotNull((Object)javaFileStub, (String)"javaFileStub");
            this.modificationStamp = modificationStamp;
            this.javaFileStub = javaFileStub;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/caches/lightClasses/ClsJavaStubByVirtualFileCache$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lorg/jetbrains/kotlin/idea/caches/lightClasses/ClsJavaStubByVirtualFileCache;", "project", "Lcom/intellij/openapi/project/Project;", "idea-core"})
    public static final class Companion {
        @NotNull
        public final ClsJavaStubByVirtualFileCache getInstance(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Object object = ServiceManager.getService((Project)project2, ClsJavaStubByVirtualFileCache.class);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"ServiceManager.getServic\u2026ualFileCache::class.java)");
            return (ClsJavaStubByVirtualFileCache)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

