/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight;

import com.intellij.DynamicBundle;
import com.intellij.application.options.editor.AutoImportOptionsProvider;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightSettings;
import org.jetbrains.kotlin.idea.codeInsight.KotlinCodeInsightWorkspaceSettings;
import org.jetbrains.kotlin.idea.statistics.FUSEventGroups;
import org.jetbrains.kotlin.idea.statistics.KotlinFUSLogger;

public class KotlinCodeInsightWorkspaceSettingsProvider
implements AutoImportOptionsProvider {
    private final Project project;
    private JPanel myPanel;
    private JCheckBox myOptimizeImportsOnTheFly;
    private JCheckBox myAddUnambiguousImportsOnTheFly;

    public KotlinCodeInsightWorkspaceSettingsProvider(Project project2) {
        this.project = project2;
        this.$$$setupUI$$$();
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    private KotlinCodeInsightSettings settings() {
        return KotlinCodeInsightSettings.Companion.getInstance();
    }

    private KotlinCodeInsightWorkspaceSettings projectSettings() {
        return KotlinCodeInsightWorkspaceSettings.Companion.getInstance(this.project);
    }

    public boolean isModified() {
        KotlinCodeInsightSettings settings2 = this.settings();
        KotlinCodeInsightWorkspaceSettings projectSettings = this.projectSettings();
        return projectSettings.optimizeImportsOnTheFly != this.myOptimizeImportsOnTheFly.isSelected() || settings2.addUnambiguousImportsOnTheFly != this.myAddUnambiguousImportsOnTheFly.isSelected();
    }

    public void apply() throws ConfigurationException {
        KotlinCodeInsightSettings settings2 = this.settings();
        KotlinCodeInsightWorkspaceSettings projectSettings = this.projectSettings();
        projectSettings.optimizeImportsOnTheFly = this.myOptimizeImportsOnTheFly.isSelected();
        settings2.addUnambiguousImportsOnTheFly = this.myAddUnambiguousImportsOnTheFly.isSelected();
        HashMap<String, String> data2 = new HashMap<String, String>();
        data2.put("optimizeImportsOnTheFly", Boolean.toString(projectSettings.optimizeImportsOnTheFly));
        data2.put("addUnambiguousImportsOnTheFly", Boolean.toString(settings2.addUnambiguousImportsOnTheFly));
        KotlinFUSLogger.Companion.log(FUSEventGroups.Settings, "KotlinCodeInsightWorkspaceSettings", data2);
    }

    public void reset() {
        KotlinCodeInsightSettings settings2 = this.settings();
        KotlinCodeInsightWorkspaceSettings projectSettings = this.projectSettings();
        this.myOptimizeImportsOnTheFly.setSelected(projectSettings.optimizeImportsOnTheFly);
        this.myAddUnambiguousImportsOnTheFly.setSelected(settings2.addUnambiguousImportsOnTheFly);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/KotlinBundle", KotlinCodeInsightWorkspaceSettingsProvider.class).getString("plugin.updater.notification.title"), (int)0, (int)0, null, null));
        this.myAddUnambiguousImportsOnTheFly = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/ApplicationBundle", KotlinCodeInsightWorkspaceSettingsProvider.class).getString("checkbox.add.unambiguous.imports.on.the.fly"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myOptimizeImportsOnTheFly = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/ApplicationBundle", KotlinCodeInsightWorkspaceSettingsProvider.class).getString("checkbox.optimize.imports.on.the.fly"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

