/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.upDownMover;

import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import java.util.function.Predicate;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.codeInsight.upDownMover.AbstractKotlinUpDownMover;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtScriptInitializer;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

public class KotlinExpressionMover
extends AbstractKotlinUpDownMover {
    private static final Predicate<KtElement> IS_CALL_EXPRESSION = input -> input instanceof KtCallExpression;
    private static final Class[] MOVABLE_ELEMENT_CLASSES = new Class[]{KtExpression.class, KtWhenEntry.class, KtValueArgument.class, PsiComment.class};
    private static final Function1<PsiElement, Boolean> MOVABLE_ELEMENT_CONSTRAINT = new Function1<PsiElement, Boolean>(){

        @NotNull
        public Boolean invoke(PsiElement element3) {
            Boolean bl = !(element3 instanceof KtExpression) || element3 instanceof KtDeclaration || element3 instanceof KtBlockExpression || element3.getParent() instanceof KtBlockExpression;
            if (bl == null) {
                1.$$$reportNull$$$0(0);
            }
            if (bl == null) {
                1.$$$reportNull$$$1(0);
            }
            if (bl == null) {
                1.$$$reportNull$$$2(0);
            }
            if (bl == null) {
                1.$$$reportNull$$$3(0);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover$1", "invoke"));
        }

        private static /* synthetic */ void $$$reportNull$$$1(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover$1", "invoke"));
        }

        private static /* synthetic */ void $$$reportNull$$$2(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover$1", "invoke"));
        }

        private static /* synthetic */ void $$$reportNull$$$3(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover$1", "invoke"));
        }
    };
    private static final Class[] BLOCKLIKE_ELEMENT_CLASSES = new Class[]{KtBlockExpression.class, KtWhenExpression.class, KtClassBody.class, KtFile.class};
    private static final Class[] FUNCTIONLIKE_ELEMENT_CLASSES = new Class[]{KtFunction.class, KtPropertyAccessor.class, KtAnonymousInitializer.class};
    private static final Predicate<KtElement> CHECK_BLOCK_LIKE_ELEMENT = input -> (input instanceof KtBlockExpression || input instanceof KtClassBody) && !PsiTreeUtil.instanceOf((Object)input.getParent(), (Class[])FUNCTIONLIKE_ELEMENT_CLASSES);
    private static final Predicate<KtElement> CHECK_BLOCK = input -> input instanceof KtBlockExpression && !PsiTreeUtil.instanceOf((Object)input.getParent(), (Class[])FUNCTIONLIKE_ELEMENT_CLASSES);
    @Nullable
    private Pair<PsiElement, PsiElement> parametersOrArgsToMove;

    @Nullable
    private static PsiElement getStandaloneClosingBrace(@NotNull PsiFile file2, @NotNull Editor editor2) {
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(0);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(1);
        }
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(0);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(1);
        }
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(0);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(1);
        }
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(1);
        }
        LineRange range = KotlinExpressionMover.getLineRangeFromSelection((Editor)editor2);
        if (range.endLine - range.startLine != 1) {
            return null;
        }
        int offset2 = editor2.getCaretModel().getOffset();
        Document document = editor2.getDocument();
        int line = document.getLineNumber(offset2);
        int lineStartOffset = document.getLineStartOffset(line);
        String lineText = document.getText().substring(lineStartOffset, document.getLineEndOffset(line));
        if (!lineText.trim().equals("}")) {
            return null;
        }
        return file2.findElementAt(lineStartOffset + lineText.indexOf(125));
    }

    private static BraceStatus checkForMovableDownClosingBrace(@NotNull PsiElement closingBrace, @NotNull PsiElement block, @NotNull Editor editor2, @NotNull StatementUpDownMover.MoveInfo info2) {
        if (closingBrace == null) {
            KotlinExpressionMover.$$$reportNull$$$3(2);
        }
        if (block == null) {
            KotlinExpressionMover.$$$reportNull$$$3(3);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(4);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(5);
        }
        if (closingBrace == null) {
            KotlinExpressionMover.$$$reportNull$$$2(2);
        }
        if (block == null) {
            KotlinExpressionMover.$$$reportNull$$$2(3);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(4);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(5);
        }
        if (closingBrace == null) {
            KotlinExpressionMover.$$$reportNull$$$1(2);
        }
        if (block == null) {
            KotlinExpressionMover.$$$reportNull$$$1(3);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(4);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(5);
        }
        if (closingBrace == null) {
            KotlinExpressionMover.$$$reportNull$$$0(2);
        }
        if (block == null) {
            KotlinExpressionMover.$$$reportNull$$$0(3);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(4);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(5);
        }
        PsiElement current = block;
        PsiElement nextElement = null;
        PsiElement nextExpression = null;
        do {
            PsiElement sibling;
            if ((sibling = KotlinExpressionMover.firstNonWhiteElement((PsiElement)current.getNextSibling(), (boolean)true)) != null && nextElement == null) {
                nextElement = sibling;
            }
            if (!(sibling instanceof KtExpression)) continue;
            nextExpression = sibling;
            break;
        } while ((current = current.getParent()) != null && !PsiTreeUtil.instanceOf((Object)current, (Class[])BLOCKLIKE_ELEMENT_CLASSES));
        if (nextExpression == null) {
            return BraceStatus.NOT_MOVABLE;
        }
        Document doc = editor2.getDocument();
        info2.toMove = new LineRange(closingBrace, closingBrace, doc);
        info2.toMove2 = new LineRange(nextElement, nextExpression);
        info2.indentSource = true;
        return BraceStatus.MOVABLE;
    }

    private static BraceStatus checkForMovableUpClosingBrace(@NotNull PsiElement closingBrace, PsiElement block, @NotNull Editor editor2, @NotNull StatementUpDownMover.MoveInfo info2) {
        Object prev2;
        if (closingBrace == null) {
            KotlinExpressionMover.$$$reportNull$$$3(6);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(7);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(8);
        }
        if (closingBrace == null) {
            KotlinExpressionMover.$$$reportNull$$$2(6);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(7);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(8);
        }
        if (closingBrace == null) {
            KotlinExpressionMover.$$$reportNull$$$1(6);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(7);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(8);
        }
        if (closingBrace == null) {
            KotlinExpressionMover.$$$reportNull$$$0(6);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(7);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(8);
        }
        if ((prev2 = KtPsiUtil.getLastChildByType(block, KtExpression.class)) == null) {
            return BraceStatus.NOT_MOVABLE;
        }
        Document doc = editor2.getDocument();
        info2.toMove = new LineRange(closingBrace, closingBrace, doc);
        info2.toMove2 = new LineRange(prev2, prev2, doc);
        info2.indentSource = true;
        return BraceStatus.MOVABLE;
    }

    private static BraceStatus checkForMovableClosingBrace(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info2, boolean down) {
        KtIfExpression ifExpression2;
        PsiElement closingBrace;
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(9);
        }
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(10);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(11);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(9);
        }
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(10);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(11);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(9);
        }
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(10);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(11);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(10);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(11);
        }
        if ((closingBrace = KotlinExpressionMover.getStandaloneClosingBrace(file2, editor2)) == null) {
            return BraceStatus.NOT_FOUND;
        }
        PsiElement blockLikeElement = closingBrace.getParent();
        if (!(blockLikeElement instanceof KtBlockExpression)) {
            return BraceStatus.NOT_MOVABLE;
        }
        PsiElement blockParent = blockLikeElement.getParent();
        if (blockParent instanceof KtWhenEntry) {
            return BraceStatus.NOT_FOUND;
        }
        if (PsiTreeUtil.instanceOf((Object)blockParent, (Class[])FUNCTIONLIKE_ELEMENT_CLASSES)) {
            return BraceStatus.NOT_FOUND;
        }
        PsiElement enclosingExpression = PsiTreeUtil.getParentOfType((PsiElement)blockLikeElement, KtExpression.class);
        if (enclosingExpression instanceof KtDoWhileExpression) {
            return BraceStatus.NOT_MOVABLE;
        }
        if (enclosingExpression instanceof KtIfExpression && blockLikeElement == (ifExpression2 = (KtIfExpression)enclosingExpression).getThen() && ifExpression2.getElse() != null) {
            return BraceStatus.NOT_MOVABLE;
        }
        return down ? KotlinExpressionMover.checkForMovableDownClosingBrace(closingBrace, blockLikeElement, editor2, info2) : KotlinExpressionMover.checkForMovableUpClosingBrace(closingBrace, blockLikeElement, editor2, info2);
    }

    @Nullable
    private static KtBlockExpression findClosestBlock(@NotNull PsiElement anchor2, boolean down, boolean strict) {
        if (anchor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(12);
        }
        if (anchor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(12);
        }
        if (anchor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(12);
        }
        if (anchor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(12);
        }
        PsiElement current = PsiTreeUtil.getParentOfType((PsiElement)anchor2, KtBlockExpression.class, (boolean)strict);
        while (current != null) {
            PsiElement sibling;
            PsiElement parent2 = current.getParent();
            if (parent2 instanceof KtClassBody || parent2 instanceof KtAnonymousInitializer && !(parent2 instanceof KtScriptInitializer) || parent2 instanceof KtNamedFunction || parent2 instanceof KtProperty && !((KtProperty)parent2).isLocal()) {
                return null;
            }
            if (parent2 instanceof KtBlockExpression) {
                return (KtBlockExpression)parent2;
            }
            PsiElement psiElement2 = sibling = down ? current.getNextSibling() : current.getPrevSibling();
            if (sibling != null) {
                KtBlockExpression block = (KtBlockExpression)KtPsiUtil.getOutermostDescendantElement(sibling, down, CHECK_BLOCK);
                if (block != null) {
                    return block;
                }
                current = sibling;
                continue;
            }
            current = parent2;
        }
        return null;
    }

    @Nullable
    private static KtBlockExpression getDSLLambdaBlock(@NotNull Editor editor2, @NotNull PsiElement element3, boolean down) {
        TextRange range;
        KtCallExpression callExpression2;
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(13);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(14);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(13);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(14);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(13);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(14);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(13);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(14);
        }
        if ((callExpression2 = (KtCallExpression)KtPsiUtil.getOutermostDescendantElement(element3, down, IS_CALL_EXPRESSION)) == null) {
            return null;
        }
        List<KtLambdaArgument> functionLiterals = callExpression2.getLambdaArguments();
        if (functionLiterals.isEmpty()) {
            return null;
        }
        KtLambdaExpression lambdaExpression2 = functionLiterals.get(0).getLambdaExpression();
        if (lambdaExpression2 == null) {
            return null;
        }
        Document document = editor2.getDocument();
        if (document.getLineNumber((range = lambdaExpression2.getTextRange()).getStartOffset()) == document.getLineNumber(range.getEndOffset())) {
            return null;
        }
        return lambdaExpression2.getBodyExpression();
    }

    @Nullable
    private static LineRange getExpressionTargetRange(@NotNull Editor editor2, @NotNull PsiElement elementToCheck, @NotNull PsiElement sibling, boolean down) {
        Pair<PsiElement, PsiElement> extended;
        PsiElement arrow;
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(15);
        }
        if (elementToCheck == null) {
            KotlinExpressionMover.$$$reportNull$$$3(16);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$3(17);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(15);
        }
        if (elementToCheck == null) {
            KotlinExpressionMover.$$$reportNull$$$2(16);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$2(17);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(15);
        }
        if (elementToCheck == null) {
            KotlinExpressionMover.$$$reportNull$$$1(16);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$1(17);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(15);
        }
        if (elementToCheck == null) {
            KotlinExpressionMover.$$$reportNull$$$0(16);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$0(17);
        }
        PsiElement start2 = sibling;
        PsiElement end = sibling;
        if (!down) {
            if (sibling instanceof KtIfExpression) {
                KtIfExpression ifExpression2 = (KtIfExpression)sibling;
                KtExpression elseExpression2 = ifExpression2.getElse();
                while (elseExpression2 instanceof KtIfExpression) {
                    KtIfExpression elseIfExpression = (KtIfExpression)elseExpression2;
                    KtExpression next2 = elseIfExpression.getElse();
                    if (next2 == null) {
                        elseExpression2 = elseIfExpression.getThen();
                        break;
                    }
                    elseExpression2 = next2;
                }
                if (elseExpression2 instanceof KtBlockExpression) {
                    start2 = sibling = elseExpression2;
                }
            } else if (sibling instanceof KtWhenExpression) {
                List<KtWhenEntry> entries2 = ((KtWhenExpression)sibling).getEntries();
                if (!entries2.isEmpty()) {
                    KtWhenEntry lastEntry = null;
                    for (KtWhenEntry entry : entries2) {
                        if (!(entry.getExpression() instanceof KtBlockExpression)) continue;
                        lastEntry = entry;
                    }
                    if (lastEntry != null) {
                        start2 = sibling = lastEntry;
                    }
                }
            } else if (sibling instanceof KtTryExpression) {
                KtTryExpression tryExpression = (KtTryExpression)sibling;
                KtFinallySection finallyBlock = tryExpression.getFinallyBlock();
                if (finallyBlock != null) {
                    start2 = sibling = finallyBlock;
                } else {
                    List<KtCatchClause> clauses = tryExpression.getCatchClauses();
                    if (!clauses.isEmpty()) {
                        start2 = sibling = (PsiElement)clauses.get(clauses.size() - 1);
                    }
                }
            }
        }
        if (sibling.getNode().getElementType() == (down ? KtTokens.RBRACE : KtTokens.LBRACE)) {
            KtBlockExpression newBlock;
            PsiElement parent2 = sibling.getParent();
            if (!(parent2 instanceof KtBlockExpression) && !(parent2 instanceof KtFunctionLiteral)) {
                return null;
            }
            if (parent2 instanceof KtFunctionLiteral) {
                newBlock = KotlinExpressionMover.findClosestBlock((PsiElement)((KtFunctionLiteral)parent2).getBodyExpression(), down, false);
                if (!down && (arrow = ((KtFunctionLiteral)parent2).getArrow()) != null) {
                    end = arrow;
                }
            } else {
                newBlock = KotlinExpressionMover.findClosestBlock(sibling, down, true);
            }
            if (newBlock == null) {
                return null;
            }
            if (PsiTreeUtil.isAncestor((PsiElement)newBlock, (PsiElement)parent2, (boolean)true)) {
                PsiElement outermostParent = KtPsiUtil.getOutermostParent(parent2, (PsiElement)newBlock, true);
                if (down) {
                    end = outermostParent;
                } else {
                    start2 = outermostParent;
                }
            } else if (down) {
                end = newBlock.getLBrace();
            } else {
                start2 = newBlock.getRBrace();
            }
        } else {
            KtBlockExpression dslBlock = KotlinExpressionMover.getDSLLambdaBlock(editor2, sibling, down);
            Object blockLikeElement = dslBlock != null ? dslBlock.getParent() : KtPsiUtil.getOutermostDescendantElement(sibling, down, CHECK_BLOCK_LIKE_ELEMENT);
            if (blockLikeElement != null) {
                if (down) {
                    end = KtPsiUtil.findChildByType(blockLikeElement, KtTokens.LBRACE);
                    if (blockLikeElement instanceof KtFunctionLiteral && (arrow = ((KtFunctionLiteral)blockLikeElement).getArrow()) != null) {
                        end = arrow;
                    }
                } else {
                    start2 = KtPsiUtil.findChildByType(blockLikeElement, KtTokens.RBRACE);
                }
            }
        }
        if (!(elementToCheck instanceof PsiComment) && (extended = KotlinExpressionMover.extendForSiblingComments(start2, end, sibling, editor2, down)) != null) {
            start2 = (PsiElement)extended.first;
            end = (PsiElement)extended.second;
        }
        return start2 != null && end != null ? new LineRange(start2, end, editor2.getDocument()) : null;
    }

    @Nullable
    private static Pair<PsiElement, PsiElement> extendForSiblingComments(@Nullable PsiElement start2, @Nullable PsiElement end, @NotNull PsiElement sibling, @NotNull Editor editor2, boolean down) {
        PsiElement next2;
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$3(18);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(19);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$2(18);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(19);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$1(18);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(19);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$0(18);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(19);
        }
        if (start2 != end || start2 != sibling) {
            return null;
        }
        boolean hasUpdate = false;
        PsiElement current = sibling;
        while (true) {
            int nextLine = KotlinExpressionMover.getElementLine(current, editor2, !down) + (down ? 1 : -1);
            if (!((current = KotlinExpressionMover.firstNonWhiteSibling(current, down)) instanceof PsiComment) || KotlinExpressionMover.getElementLine(current, editor2, down) != nextLine) break;
            hasUpdate = true;
            if (down) {
                end = current;
                continue;
            }
            start2 = current;
        }
        if (down && end instanceof PsiComment && KotlinExpressionMover.getElementLine(next2 = KotlinExpressionMover.firstNonWhiteSibling(end, true), editor2, true) == KotlinExpressionMover.getElementLine(end, editor2, false) + 1) {
            hasUpdate = true;
            end = next2;
        }
        return hasUpdate ? Pair.create((Object)start2, (Object)end) : null;
    }

    @Nullable
    private static LineRange getWhenEntryTargetRange(@NotNull Editor editor2, @NotNull PsiElement sibling, boolean down) {
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(20);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$3(21);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(20);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$2(21);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(20);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$1(21);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(20);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$0(21);
        }
        if (sibling.getNode().getElementType() == (down ? KtTokens.RBRACE : KtTokens.LBRACE) && PsiTreeUtil.getParentOfType((PsiElement)sibling, KtWhenEntry.class) == null) {
            return null;
        }
        return new LineRange(sibling, sibling, editor2.getDocument());
    }

    @Nullable
    private LineRange getValueParamOrArgTargetRange(@NotNull Editor editor2, @NotNull PsiElement elementToCheck, @NotNull PsiElement sibling, boolean down) {
        LineRange range;
        PsiElement next2;
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(22);
        }
        if (elementToCheck == null) {
            KotlinExpressionMover.$$$reportNull$$$3(23);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$3(24);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(22);
        }
        if (elementToCheck == null) {
            KotlinExpressionMover.$$$reportNull$$$2(23);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$2(24);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(22);
        }
        if (elementToCheck == null) {
            KotlinExpressionMover.$$$reportNull$$$1(23);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$1(24);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(22);
        }
        if (elementToCheck == null) {
            KotlinExpressionMover.$$$reportNull$$$0(23);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$0(24);
        }
        if ((next2 = sibling).getNode().getElementType() == KtTokens.COMMA) {
            next2 = KotlinExpressionMover.firstNonWhiteSibling(next2, down);
        }
        Object object = range = next2 instanceof KtParameter || next2 instanceof KtValueArgument ? new LineRange(next2, next2, editor2.getDocument()) : null;
        if (range != null) {
            this.parametersOrArgsToMove = new Pair((Object)elementToCheck, (Object)next2);
        }
        return range;
    }

    @Nullable
    private LineRange getTargetRange(@NotNull Editor editor2, @Nullable PsiElement elementToCheck, @NotNull PsiElement sibling, boolean down) {
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(25);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$3(26);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(25);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$2(26);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(25);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$1(26);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(25);
        }
        if (sibling == null) {
            KotlinExpressionMover.$$$reportNull$$$0(26);
        }
        if (elementToCheck instanceof KtParameter || elementToCheck instanceof KtValueArgument) {
            return this.getValueParamOrArgTargetRange(editor2, elementToCheck, sibling, down);
        }
        if (elementToCheck instanceof KtExpression || elementToCheck instanceof PsiComment) {
            return KotlinExpressionMover.getExpressionTargetRange(editor2, elementToCheck, sibling, down);
        }
        if (elementToCheck instanceof KtWhenEntry) {
            return KotlinExpressionMover.getWhenEntryTargetRange(editor2, sibling, down);
        }
        return null;
    }

    @Override
    protected boolean checkSourceElement(@NotNull PsiElement element3) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(27);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(27);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(27);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(27);
        }
        return PsiTreeUtil.instanceOf((Object)element3, (Class[])MOVABLE_ELEMENT_CLASSES) || element3.getNode().getElementType() == KtTokens.SEMICOLON;
    }

    @Override
    protected LineRange getElementSourceLineRange(@NotNull PsiElement element3, @NotNull Editor editor2, @NotNull LineRange oldRange) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(28);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(29);
        }
        if (oldRange == null) {
            KotlinExpressionMover.$$$reportNull$$$3(30);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(28);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(29);
        }
        if (oldRange == null) {
            KotlinExpressionMover.$$$reportNull$$$2(30);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(28);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(29);
        }
        if (oldRange == null) {
            KotlinExpressionMover.$$$reportNull$$$1(30);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(28);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(29);
        }
        if (oldRange == null) {
            KotlinExpressionMover.$$$reportNull$$$0(30);
        }
        TextRange textRange = element3.getTextRange();
        if (editor2.getDocument().getTextLength() < textRange.getEndOffset()) {
            return null;
        }
        int startLine = editor2.offsetToLogicalPosition((int)textRange.getStartOffset()).line;
        int endLine = editor2.offsetToLogicalPosition((int)textRange.getEndOffset()).line + 1;
        return new LineRange(startLine, endLine);
    }

    @Nullable
    private static PsiElement getMovableElement(@NotNull PsiElement element3, boolean lookRight) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(31);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(31);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(31);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(31);
        }
        if (element3.getNode().getElementType() == KtTokens.SEMICOLON) {
            return element3;
        }
        PsiElement movableElement = PsiUtilsKt.getParentOfTypesAndPredicate(element3, false, MOVABLE_ELEMENT_CLASSES, MOVABLE_ELEMENT_CONSTRAINT);
        if (movableElement == null) {
            return null;
        }
        if (KotlinExpressionMover.isBracelessBlock(movableElement)) {
            movableElement = KotlinExpressionMover.firstNonWhiteElement((PsiElement)(lookRight ? movableElement.getLastChild() : movableElement.getFirstChild()), (!lookRight ? 1 : 0) != 0);
        }
        return movableElement;
    }

    private static boolean isLastOfItsKind(@NotNull PsiElement element3, boolean down) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(32);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(32);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(32);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(32);
        }
        return KotlinExpressionMover.getSiblingOfType(element3, down, element3.getClass()) == null;
    }

    private static boolean isForbiddenMove(@NotNull PsiElement element3, boolean down) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(33);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(33);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(33);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(33);
        }
        if (element3 instanceof KtParameter || element3 instanceof KtValueArgument) {
            return KotlinExpressionMover.isLastOfItsKind(element3, down);
        }
        return false;
    }

    private static boolean isBracelessBlock(@NotNull PsiElement element3) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(34);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(34);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(34);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(34);
        }
        if (!(element3 instanceof KtBlockExpression)) {
            return false;
        }
        KtBlockExpression block = (KtBlockExpression)element3;
        return block.getLBrace() == null && block.getRBrace() == null;
    }

    private static PsiElement adjustSibling(@NotNull Editor editor2, @NotNull LineRange sourceRange, @NotNull StatementUpDownMover.MoveInfo info2, boolean down) {
        PsiElement parent2;
        PsiElement sibling;
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(35);
        }
        if (sourceRange == null) {
            KotlinExpressionMover.$$$reportNull$$$3(36);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(37);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(35);
        }
        if (sourceRange == null) {
            KotlinExpressionMover.$$$reportNull$$$2(36);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(37);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(35);
        }
        if (sourceRange == null) {
            KotlinExpressionMover.$$$reportNull$$$1(36);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(37);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(35);
        }
        if (sourceRange == null) {
            KotlinExpressionMover.$$$reportNull$$$0(36);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(37);
        }
        PsiElement element3 = down ? sourceRange.lastElement : sourceRange.firstElement;
        PsiElement whiteSpaceTestSubject = sibling = down ? element3.getNextSibling() : element3.getPrevSibling();
        if (sibling == null && (parent2 = element3.getParent()) != null && KotlinExpressionMover.isBracelessBlock(parent2)) {
            PsiElement psiElement2 = whiteSpaceTestSubject = down ? parent2.getNextSibling() : parent2.getPrevSibling();
        }
        if (whiteSpaceTestSubject instanceof PsiWhiteSpace) {
            if (PsiLinesUtilsKt.isMultiLine(whiteSpaceTestSubject)) {
                int nearLine = down ? sourceRange.endLine : sourceRange.startLine - 1;
                info2.toMove = sourceRange;
                info2.toMove2 = new LineRange(nearLine, nearLine + 1);
                info2.indentTarget = false;
                return null;
            }
            if (sibling != null) {
                sibling = KotlinExpressionMover.firstNonWhiteElement((PsiElement)sibling, (boolean)down);
            }
        }
        if (sibling == null) {
            KtBlockExpression dslBlock;
            KtCallExpression callExpression2 = (KtCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element3, KtCallExpression.class);
            if (callExpression2 != null && PsiTreeUtil.isAncestor((PsiElement)(dslBlock = KotlinExpressionMover.getDSLLambdaBlock(editor2, (PsiElement)callExpression2, down)), (PsiElement)element3, (boolean)false)) {
                PsiElement blockParent = dslBlock.getParent();
                return down ? KtPsiUtil.findChildByType(blockParent, KtTokens.RBRACE) : KtPsiUtil.findChildByType(blockParent, KtTokens.LBRACE);
            }
            info2.toMove2 = null;
            return null;
        }
        return sibling;
    }

    @Override
    public boolean checkAvailable(@NotNull Editor editor2, @NotNull PsiFile file2, @NotNull StatementUpDownMover.MoveInfo info2, boolean down) {
        LineRange sourceRange;
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(38);
        }
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(39);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(40);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(38);
        }
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(39);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(40);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(38);
        }
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(39);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(40);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(38);
        }
        if (file2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(39);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(40);
        }
        this.parametersOrArgsToMove = null;
        if (!super.checkAvailable(editor2, file2, info2, down)) {
            return false;
        }
        switch (KotlinExpressionMover.checkForMovableClosingBrace(editor2, file2, info2, down)) {
            case NOT_MOVABLE: {
                info2.toMove2 = null;
                return true;
            }
            case MOVABLE: {
                return true;
            }
        }
        LineRange oldRange = info2.toMove;
        Pair psiRange = KotlinExpressionMover.getElementRange((Editor)editor2, (PsiFile)file2, (LineRange)oldRange);
        if (psiRange == null) {
            return false;
        }
        PsiElement firstElement = KotlinExpressionMover.getMovableElement((PsiElement)psiRange.getFirst(), false);
        PsiElement lastElement = KotlinExpressionMover.getMovableElement((PsiElement)psiRange.getSecond(), true);
        if (firstElement == null || lastElement == null) {
            return false;
        }
        if (KotlinExpressionMover.isForbiddenMove(firstElement, down) || KotlinExpressionMover.isForbiddenMove(lastElement, down)) {
            info2.toMove2 = null;
            return true;
        }
        if ((firstElement instanceof KtParameter || firstElement instanceof KtValueArgument) && PsiTreeUtil.isAncestor((PsiElement)lastElement, (PsiElement)firstElement, (boolean)false)) {
            lastElement = firstElement;
        }
        if ((sourceRange = this.getSourceRange(firstElement, lastElement, editor2, oldRange)) == null) {
            return false;
        }
        PsiElement sibling = KotlinExpressionMover.getLastNonWhiteSiblingInLine(KotlinExpressionMover.adjustSibling(editor2, sourceRange, info2, down), editor2, down);
        if (sibling == null) {
            return true;
        }
        info2.toMove = sourceRange;
        info2.toMove2 = this.getTargetRange(editor2, sourceRange.firstElement, sibling, down);
        return true;
    }

    private static PsiElement getComma(@NotNull PsiElement element3) {
        PsiElement sibling;
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(41);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(41);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(41);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(41);
        }
        return (sibling = KotlinExpressionMover.firstNonWhiteSibling(element3, true)) != null && sibling.getNode().getElementType() == KtTokens.COMMA ? sibling : null;
    }

    private static void fixCommaIfNeeded(@NotNull PsiElement element3, boolean willBeLast) {
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(42);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(42);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(42);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(42);
        }
        PsiElement comma = KotlinExpressionMover.getComma(element3);
        if (willBeLast && comma != null) {
            comma.delete();
        } else if (!willBeLast && comma == null) {
            PsiElement parent2 = element3.getParent();
            assert (parent2 != null);
            parent2.addAfter(KtPsiFactoryKt.KtPsiFactory(parent2.getProject()).createComma(), element3);
        }
    }

    public void beforeMove(@NotNull Editor editor2, @NotNull StatementUpDownMover.MoveInfo info2, boolean down) {
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(43);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(44);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(43);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(44);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(43);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(44);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(43);
        }
        if (info2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(44);
        }
        if (this.parametersOrArgsToMove != null) {
            PsiElement element12 = KotlinExpressionMover.getLastSiblingOfSameTypeInLine((PsiElement)this.parametersOrArgsToMove.first, editor2);
            PsiElement element22 = KotlinExpressionMover.getLastSiblingOfSameTypeInLine((PsiElement)this.parametersOrArgsToMove.second, editor2);
            KotlinExpressionMover.fixCommaIfNeeded(element12, down && KotlinExpressionMover.isLastOfItsKind(element22, true));
            KotlinExpressionMover.fixCommaIfNeeded(element22, !down && KotlinExpressionMover.isLastOfItsKind(element12, true));
            PsiDocumentManager.getInstance((Project)editor2.getProject()).doPostponedOperationsAndUnblockDocument(editor2.getDocument());
        }
    }

    @NotNull
    private static PsiElement getLastSiblingOfSameTypeInLine(@NotNull PsiElement element3, @NotNull Editor editor2) {
        PsiElement nextElement;
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(45);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(46);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(45);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(46);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(45);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(46);
        }
        if (element3 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(45);
        }
        if (editor2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(46);
        }
        PsiElement lastElement = element3;
        int lineNumber2 = KotlinExpressionMover.getElementLine(element3, editor2, true);
        while ((nextElement = PsiTreeUtil.getNextSiblingOfType((PsiElement)lastElement, lastElement.getClass())) != null && KotlinExpressionMover.getElementLine(nextElement, editor2, true) == lineNumber2) {
            lastElement = nextElement;
        }
        PsiElement psiElement2 = lastElement;
        if (psiElement2 == null) {
            KotlinExpressionMover.$$$reportNull$$$0(47);
        }
        if (psiElement2 == null) {
            KotlinExpressionMover.$$$reportNull$$$1(47);
        }
        if (psiElement2 == null) {
            KotlinExpressionMover.$$$reportNull$$$2(47);
        }
        if (psiElement2 == null) {
            KotlinExpressionMover.$$$reportNull$$$3(47);
        }
        return psiElement2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 35: 
            case 38: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingBrace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 37: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sibling";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRange";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRange";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastSiblingOfSameTypeInLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStandaloneClosingBrace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableDownClosingBrace";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableUpClosingBrace";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableClosingBrace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findClosestBlock";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDSLLambdaBlock";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionTargetRange";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "extendForSiblingComments";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getWhenEntryTargetRange";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getValueParamOrArgTargetRange";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTargetRange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkSourceElement";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getElementSourceLineRange";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getMovableElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isLastOfItsKind";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isForbiddenMove";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isBracelessBlock";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "adjustSibling";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getComma";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fixCommaIfNeeded";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "beforeMove";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getLastSiblingOfSameTypeInLine";
                break;
            }
            case 47: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 35: 
            case 38: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingBrace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 37: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sibling";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRange";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRange";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastSiblingOfSameTypeInLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStandaloneClosingBrace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableDownClosingBrace";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableUpClosingBrace";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableClosingBrace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findClosestBlock";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDSLLambdaBlock";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionTargetRange";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "extendForSiblingComments";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getWhenEntryTargetRange";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getValueParamOrArgTargetRange";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTargetRange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkSourceElement";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getElementSourceLineRange";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getMovableElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isLastOfItsKind";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isForbiddenMove";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isBracelessBlock";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "adjustSibling";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getComma";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fixCommaIfNeeded";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "beforeMove";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getLastSiblingOfSameTypeInLine";
                break;
            }
            case 47: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$2(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 35: 
            case 38: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingBrace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 37: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sibling";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRange";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRange";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastSiblingOfSameTypeInLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStandaloneClosingBrace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableDownClosingBrace";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableUpClosingBrace";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableClosingBrace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findClosestBlock";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDSLLambdaBlock";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionTargetRange";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "extendForSiblingComments";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getWhenEntryTargetRange";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getValueParamOrArgTargetRange";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTargetRange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkSourceElement";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getElementSourceLineRange";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getMovableElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isLastOfItsKind";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isForbiddenMove";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isBracelessBlock";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "adjustSibling";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getComma";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fixCommaIfNeeded";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "beforeMove";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getLastSiblingOfSameTypeInLine";
                break;
            }
            case 47: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static /* synthetic */ void $$$reportNull$$$3(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 47: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 47: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 13: 
            case 15: 
            case 19: 
            case 20: 
            case 22: 
            case 25: 
            case 29: 
            case 35: 
            case 38: 
            case 43: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingBrace";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 37: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 41: 
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 17: 
            case 18: 
            case 21: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sibling";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldRange";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRange";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/codeInsight/upDownMover/KotlinExpressionMover";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastSiblingOfSameTypeInLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getStandaloneClosingBrace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableDownClosingBrace";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableUpClosingBrace";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkForMovableClosingBrace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findClosestBlock";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDSLLambdaBlock";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionTargetRange";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "extendForSiblingComments";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getWhenEntryTargetRange";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getValueParamOrArgTargetRange";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getTargetRange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkSourceElement";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getElementSourceLineRange";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getMovableElement";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isLastOfItsKind";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isForbiddenMove";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isBracelessBlock";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "adjustSibling";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkAvailable";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getComma";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "fixCommaIfNeeded";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "beforeMove";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getLastSiblingOfSameTypeInLine";
                break;
            }
            case 47: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 47: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum BraceStatus {
        NOT_FOUND,
        MOVABLE,
        NOT_MOVABLE;

    }
}

