/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.LanguageSettingsProvider;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.Jsr305Parser;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.PlatformModuleInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptDependenciesInfo;
import org.jetbrains.kotlin.idea.caches.project.ScriptModuleInfo;
import org.jetbrains.kotlin.idea.compiler.IDELanguageSettingsProviderKt;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.platform.SimplePlatform;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformVersion;
import org.jetbrains.kotlin.platform.jvm.JdkPlatform;
import org.jetbrains.kotlin.utils.Jsr305State;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J'\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/IDELanguageSettingsProvider;", "Lorg/jetbrains/kotlin/analyzer/LanguageSettingsProvider;", "()V", "computeJsr305State", "Lorg/jetbrains/kotlin/utils/Jsr305State;", "project", "Lcom/intellij/openapi/project/Project;", "getLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "isReleaseCoroutines", "", "(Lorg/jetbrains/kotlin/analyzer/ModuleInfo;Lcom/intellij/openapi/project/Project;Ljava/lang/Boolean;)Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getTargetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatformVersion;", "idea-core"})
public final class IDELanguageSettingsProvider
implements LanguageSettingsProvider {
    public static final IDELanguageSettingsProvider INSTANCE;

    @Override
    @NotNull
    public LanguageVersionSettings getLanguageVersionSettings(@NotNull ModuleInfo moduleInfo2, @NotNull Project project2, @Nullable Boolean isReleaseCoroutines) {
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo2, (String)"moduleInfo");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ModuleInfo moduleInfo3 = moduleInfo2;
        return moduleInfo3 instanceof ModuleSourceInfo ? PlatformKt.getLanguageVersionSettings(((ModuleSourceInfo)moduleInfo2).getModule()) : (moduleInfo3 instanceof LibraryInfo ? PlatformKt.getLanguageVersionSettings$default(project2, null, this.computeJsr305State(project2), isReleaseCoroutines, 1, null) : (moduleInfo3 instanceof ScriptModuleInfo ? IDELanguageSettingsProviderKt.access$getLanguageSettingsForScripts(project2, ((ScriptModuleInfo)moduleInfo2).getScriptDefinition()).getLanguageVersionSettings() : (moduleInfo3 instanceof ScriptDependenciesInfo.ForFile ? IDELanguageSettingsProviderKt.access$getLanguageSettingsForScripts(project2, ((ScriptDependenciesInfo.ForFile)moduleInfo2).getScriptDefinition()).getLanguageVersionSettings() : (moduleInfo3 instanceof PlatformModuleInfo ? PlatformKt.getLanguageVersionSettings(((PlatformModuleInfo)moduleInfo2).getPlatformModule().getModule()) : PlatformKt.getLanguageVersionSettings$default(project2, null, null, null, 7, null)))));
    }

    private final Jsr305State computeJsr305State(Project project2) {
        Jsr305State result2 = null;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        for (Module module : moduleManager.getModules()) {
            K2JVMCompilerArguments compilerArguments2;
            Object object = KotlinFacetSettingsProvider.Companion.getInstance(project2);
            if (object == null) continue;
            Module module2 = module;
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            if ((object = object.getSettings(module2)) == null) {
                continue;
            }
            Object settings2 = object;
            CommonCompilerArguments commonCompilerArguments = ((KotlinFacetSettings)settings2).getMergedCompilerArguments();
            if (!(commonCompilerArguments instanceof K2JVMCompilerArguments)) {
                commonCompilerArguments = null;
            }
            if ((K2JVMCompilerArguments)commonCompilerArguments == null) {
                continue;
            }
            result2 = new Jsr305Parser(MessageCollector.Companion.getNONE()).parse(compilerArguments2.getJsr305(), compilerArguments2.getSupportCompatqualCheckerFrameworkAnnotations());
        }
        return result2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public TargetPlatformVersion getTargetPlatform(@NotNull ModuleInfo moduleInfo2, @NotNull Project project2) {
        TargetPlatformVersion targetPlatformVersion;
        Intrinsics.checkParameterIsNotNull((Object)moduleInfo2, (String)"moduleInfo");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ModuleInfo moduleInfo3 = moduleInfo2;
        if (moduleInfo3 instanceof ModuleSourceInfo) {
            Object object = PlatformKt.getPlatform(((ModuleSourceInfo)moduleInfo2).getModule());
            if (object != null) {
                void $this$filterIsInstanceTo$iv$iv$iv;
                TargetPlatform $this$subplatformOfType$iv = object;
                boolean $i$f$subplatformOfType = false;
                Iterable $this$filterIsInstance$iv$iv = $this$subplatformOfType$iv.getComponentPlatforms();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof JdkPlatform)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                object = (JdkPlatform)((SimplePlatform)CollectionsKt.singleOrNull((List)((List)destination$iv$iv$iv)));
                if (object != null && (object = ((JdkPlatform)object).getTargetVersion()) != null) {
                    targetPlatformVersion = (TargetPlatformVersion)object;
                    return targetPlatformVersion;
                }
            }
            targetPlatformVersion = TargetPlatformVersion.NoVersion.INSTANCE;
            return targetPlatformVersion;
        }
        if (moduleInfo3 instanceof ScriptModuleInfo) {
            targetPlatformVersion = IDELanguageSettingsProviderKt.access$getLanguageSettingsForScripts(project2, ((ScriptModuleInfo)moduleInfo2).getScriptDefinition()).getTargetPlatformVersion();
            return targetPlatformVersion;
        }
        if (moduleInfo3 instanceof ScriptDependenciesInfo.ForFile) {
            targetPlatformVersion = IDELanguageSettingsProviderKt.access$getLanguageSettingsForScripts(project2, ((ScriptDependenciesInfo.ForFile)moduleInfo2).getScriptDefinition()).getTargetPlatformVersion();
            return targetPlatformVersion;
        }
        targetPlatformVersion = TargetPlatformVersion.NoVersion.INSTANCE;
        return targetPlatformVersion;
    }

    private IDELanguageSettingsProvider() {
    }

    static {
        IDELanguageSettingsProvider iDELanguageSettingsProvider;
        INSTANCE = iDELanguageSettingsProvider = new IDELanguageSettingsProvider();
    }
}

