/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.vfs.VirtualFile;
import java.io.BufferedWriter;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinIdeaGradleBundle;
import org.jetbrains.kotlin.idea.configuration.KotlinGradleAbstractMultiplatformModuleBuilder;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0014J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u0004H\u0016J\b\u0010\u001e\u001a\u00020\u0004H\u0016J\b\u0010\u001f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0014\u0010\u000f\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0007R\u0014\u0010\u0014\u001a\u00020\u0015X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleMobileSharedMultiplatformModuleBuilder;", "Lorg/jetbrains/kotlin/idea/configuration/KotlinGradleAbstractMultiplatformModuleBuilder;", "()V", "commonName", "", "commonSourceName", "getCommonSourceName", "()Ljava/lang/String;", "commonTestName", "getCommonTestName", "jvmSourceName", "getJvmSourceName", "jvmTargetName", "jvmTestName", "getJvmTestName", "nativeSourceName", "getNativeSourceName", "nativeTargetName", "nativeTestName", "getNativeTestName", "shouldEnableGradleMetadataPreview", "", "getShouldEnableGradleMetadataPreview", "()Z", "buildMultiPlatformPart", "createProjectSkeleton", "", "rootDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getBuilderId", "getDescription", "getPresentableName", "idea-gradle"})
public final class KotlinGradleMobileSharedMultiplatformModuleBuilder
extends KotlinGradleAbstractMultiplatformModuleBuilder {
    private final String commonName = "common";
    private String jvmTargetName = "jvm";
    private String nativeTargetName = "ios";
    private final boolean shouldEnableGradleMetadataPreview = true;

    private final String getCommonSourceName() {
        return this.commonName + "Main";
    }

    private final String getCommonTestName() {
        return this.commonName + "Test";
    }

    private final String getJvmSourceName() {
        return this.jvmTargetName + "Main";
    }

    private final String getJvmTestName() {
        return this.jvmTargetName + "Test";
    }

    private final String getNativeSourceName() {
        return this.nativeTargetName + "Main";
    }

    @NotNull
    public final String getNativeTestName() {
        return this.nativeTargetName + "Test";
    }

    @Override
    protected boolean getShouldEnableGradleMetadataPreview() {
        return this.shouldEnableGradleMetadataPreview;
    }

    @NotNull
    public String getBuilderId() {
        return "kotlin.gradle.multiplatform.mobileshared";
    }

    @NotNull
    public String getPresentableName() {
        return KotlinIdeaGradleBundle.message("presentable.text.mobile.shared.library.gradle", new Object[0]);
    }

    @NotNull
    public String getDescription() {
        return KotlinIdeaGradleBundle.message("description.text.multiplatform.gradle.project.allowing.reuse.of.the.same.kotlin.code.between.two.mobile.platforms.jvm.android.and.native", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createProjectSkeleton(@NotNull VirtualFile rootDir) {
        Intrinsics.checkParameterIsNotNull((Object)rootDir, (String)"rootDir");
        VirtualFile virtualFile2 = rootDir.createChildDirectory((Object)this, "src");
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"rootDir.createChildDirectory(this, \"src\")");
        VirtualFile src = virtualFile2;
        BufferedWriter commonMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonSourceName(), null, null, null, 14, null);
        BufferedWriter commonTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getCommonTestName(), null, null, "SampleTests.kt", 6, null);
        BufferedWriter jvmMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJvmSourceName(), this.jvmTargetName, null, null, 12, null);
        BufferedWriter jvmTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getJvmTestName(), null, null, "SampleTestsJVM.kt", 6, null);
        BufferedWriter nativeMain = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getNativeSourceName(), this.nativeTargetName, null, null, 12, null);
        BufferedWriter nativeTest = KotlinGradleAbstractMultiplatformModuleBuilder.createKotlinSampleFileWriter$default(this, src, this.getNativeTestName(), null, null, "SampleTestsNative.kt", 6, null);
        try {
            commonMain.write("package sample\n\nexpect class Sample() {\n    fun checkMe(): Int\n}\n\nexpect object Platform {\n    fun name(): String\n}\n\nfun hello(): String = \"Hello from ${Platform.name()}\"");
            jvmMain.write("package sample\n\nactual class Sample {\n    actual fun checkMe() = 42\n}\n\nactual object Platform {\n    actual fun name(): String = \"JVM\"\n}");
            nativeMain.write("package sample\n\nactual class Sample {\n    actual fun checkMe() = 7\n}\n\nactual object Platform {\n    actual fun name(): String = \"iOS\"\n}");
            commonTest.write("package sample\n\nimport kotlin.test.Test\nimport kotlin.test.assertTrue\n\nclass SampleTests {\n    @Test\n    fun testMe() {\n        assertTrue(Sample().checkMe() > 0)\n    }\n}");
            jvmTest.write("package sample\n\nimport kotlin.test.Test\nimport kotlin.test.assertTrue\n\nclass SampleTestsJVM {\n    @Test\n    fun testHello() {\n        assertTrue(\"JVM\" in hello())\n    }\n}");
            nativeTest.write("package sample\n\nimport kotlin.test.Test\nimport kotlin.test.assertTrue\n\nclass SampleTestsNative {\n    @Test\n    fun testHello() {\n        assertTrue(\"iOS\" in hello())\n    }\n}");
        }
        catch (Throwable throwable) {
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, jvmMain, jvmTest, nativeMain, nativeTest});
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BufferedWriter p1 = (BufferedWriter)element$iv;
                boolean bl = false;
                p1.close();
            }
            throw throwable;
        }
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])new BufferedWriter[]{commonMain, commonTest, jvmMain, jvmTest, nativeMain, nativeTest});
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BufferedWriter p1 = (BufferedWriter)element$iv;
            boolean bl = false;
            p1.close();
        }
    }

    @Override
    @NotNull
    protected String buildMultiPlatformPart() {
        StringBuilder stringBuilder2 = new StringBuilder().append("\n            group '");
        Object object = this.getProjectId();
        if (object == null || (object = object.getGroupId()) == null) {
            object = "com.example";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append((String)object).append("'\n            version '");
        Object object2 = this.getProjectId();
        if (object2 == null || (object2 = object2.getVersion()) == null) {
            object2 = "0.0.1";
        }
        return StringsKt.trimIndent((String)stringBuilder3.append((String)object2).append("'\n\n            apply plugin: 'maven-publish'\n\n            kotlin {\n                jvm()\n                // This is for iPhone simulator\n                // Switch here to iosArm64 (or iosArm32) to build library for iPhone device\n                iosX64(\"").append(this.nativeTargetName).append("\") {\n                    binaries {\n                        framework()\n                    }\n                }\n                sourceSets {\n                    ").append(this.getCommonSourceName()).append(" {\n                        dependencies {\n                            implementation kotlin('stdlib-common')\n                        }\n                    }\n                    ").append(this.getCommonTestName()).append(" {\n                        dependencies {\n                            implementation kotlin('test-common')\n                            implementation kotlin('test-annotations-common')\n                        }\n                    }\n                    ").append(this.getJvmSourceName()).append(" {\n                        dependencies {\n                            implementation kotlin('stdlib')\n                        }\n                    }\n                    ").append(this.getJvmTestName()).append(" {\n                        dependencies {\n                            implementation kotlin('test')\n                            implementation kotlin('test-junit')\n                        }\n                    }\n                    ").append(this.getNativeSourceName()).append(" {\n                    }\n                    ").append(this.getNativeTestName()).append(" {\n                    }\n                }\n            }\n\n            configurations {\n                compileClasspath\n            }\n        ").toString());
    }

    public KotlinGradleMobileSharedMultiplatformModuleBuilder() {
        super(false, 1, null);
    }
}

