/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.utils;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesModificationTracker;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.utils.ScriptClassRootsIndexer;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0016\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\fH\u0002J\u0006\u0010\u0014\u001a\u00020\fJ\"\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0018H\u0086\b\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/utils/ScriptClassRootsIndexer;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "concurrentTransactions", "Ljava/util/concurrent/atomic/AtomicInteger;", "newRootsPresent", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "checkInTransaction", "", "commit", "markNewRoot", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "configuration", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "startIndexingIfNeeded", "startTransaction", "transaction", "T", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "idea-core"})
public final class ScriptClassRootsIndexer {
    private boolean newRootsPresent;
    private final AtomicInteger concurrentTransactions;
    @NotNull
    private final Project project;

    public final synchronized void markNewRoot(@NotNull VirtualFile file2, @NotNull ScriptCompilationConfigurationWrapper configuration2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        ScriptUtilsKt.debug(file2, (Function0<String>)((Function0)new Function0<String>(configuration2){
            final /* synthetic */ ScriptCompilationConfigurationWrapper $configuration;

            @NotNull
            public final String invoke() {
                return "new class roots found: " + this.$configuration;
            }
            {
                this.$configuration = scriptCompilationConfigurationWrapper;
                super(0);
            }
        }));
        this.checkInTransaction();
        this.newRootsPresent = true;
    }

    public final void checkInTransaction() {
        boolean bl = this.concurrentTransactions.get() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T transaction(@NotNull Function0<? extends T> body2) {
        Object object;
        int $i$f$transaction = 0;
        Intrinsics.checkParameterIsNotNull(body2, (String)"body");
        this.startTransaction();
        try {
            object = body2.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.commit();
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }

    public final void startTransaction() {
        this.concurrentTransactions.incrementAndGet();
    }

    public final void commit() {
        this.concurrentTransactions.decrementAndGet();
        this.startIndexingIfNeeded();
    }

    private final synchronized void startIndexingIfNeeded() {
        if (!this.newRootsPresent) {
            return;
        }
        this.newRootsPresent = false;
        Runnable doNotifyRootsChanged2 = new Runnable(this){
            final /* synthetic */ ScriptClassRootsIndexer this$0;

            public final void run() {
                ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ startIndexingIfNeeded.doNotifyRootsChanged.1 this$0;

                    public final void invoke() {
                        if (this.this$0.this$0.getProject().isDisposed()) {
                            return;
                        }
                        ScriptUtilsKt.debug$default(null, startIndexingIfNeeded.doNotifyRootsChanged.1.INSTANCE, 1, null);
                        ProjectRootManagerEx projectRootManagerEx = ProjectRootManagerEx.getInstanceEx((Project)this.this$0.this$0.getProject());
                        if (projectRootManagerEx != null) {
                            projectRootManagerEx.makeRootsChange(EmptyRunnable.getInstance(), false, true);
                        }
                        ScriptDependenciesModificationTracker.Companion.getInstance(this.this$0.this$0.getProject()).incModificationCount();
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = scriptClassRootsIndexer;
            }
        };
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (application.isUnitTestMode()) {
            TransactionGuard.submitTransaction((Disposable)((Disposable)this.project), (Runnable)doNotifyRootsChanged2);
        } else {
            TransactionGuard.getInstance().submitTransactionLater((Disposable)this.project, doNotifyRootsChanged2);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScriptClassRootsIndexer(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        this.project = project2;
        this.concurrentTransactions = new AtomicInteger();
    }
}

