/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.util;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.FileAttributeProperty;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u000b\u001ae\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0019\b\u0004\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u0002H\u00020\t\u00a2\u0006\u0002\b\u000b2\u001f\b\u0004\u0010\f\u001a\u0019\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u000bH\u0086\b\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0012\u001a\u0010\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u0014*\u00020\u0012\u001a4\u0010\u0015\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u00122\u0017\u0010\u0016\u001a\u0013\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u0002H\u00020\t\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010\u0017\u001a\u001e\u0010\u0018\u001a\u0002H\u0002\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003*\u00020\nH\u0086\b\u00a2\u0006\u0002\u0010\u0019\u001a\n\u0010\u001a\u001a\u00020\u0005*\u00020\u0012\u001a\u0010\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014*\u00020\u0012\u001a\u0012\u0010\u001c\u001a\u00020\u000f*\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0011\u001a\u0018\u0010\u001f\u001a\u00020\u000f*\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110!\u001aB\u0010\"\u001a\u00020\u000f\"\b\b\u0000\u0010\u0002*\u00020\u0003*\u00020\u001d2\b\u0010#\u001a\u0004\u0018\u0001H\u00022\u001d\u0010$\u001a\u0019\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0002\u0010%\u001a&\u0010&\u001a\u00020\u000f\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0003*\u00020\u000e2\u0006\u0010'\u001a\u0002H\u0002H\u0086\b\u00a2\u0006\u0002\u0010(\u001a\u0012\u0010)\u001a\u00020\u000f*\u00020\u001d2\u0006\u0010*\u001a\u00020\u0005\u001a\u0018\u0010+\u001a\u00020\u000f*\u00020\u001d2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!\u00a8\u0006,"}, d2={"cachedFileAttribute", "Lorg/jetbrains/kotlin/idea/core/util/FileAttributeProperty;", "T", "", "name", "", "version", "", "read", "Lkotlin/Function1;", "Ljava/io/DataInputStream;", "Lkotlin/ExtensionFunctionType;", "write", "Lkotlin/Function2;", "Ljava/io/DataOutputStream;", "", "readFile", "Ljava/io/File;", "Ljava/io/DataInput;", "readFileList", "", "readNullable", "readT", "(Ljava/io/DataInput;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "readObject", "(Ljava/io/DataInputStream;)Ljava/lang/Object;", "readString", "readStringList", "writeFile", "Ljava/io/DataOutput;", "it", "writeFileList", "iterable", "", "writeNullable", "nullable", "writeT", "(Ljava/io/DataOutput;Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)V", "writeObject", "obj", "(Ljava/io/DataOutputStream;Ljava/lang/Object;)V", "writeString", "string", "writeStringList", "idea-core"})
public final class FileAttributeUtilsKt {
    @NotNull
    public static final <T> FileAttributeProperty<T> cachedFileAttribute(@NotNull String name2, int version2, @NotNull Function1<? super DataInputStream, ? extends T> read2, @NotNull Function2<? super DataOutputStream, ? super T, Unit> write) {
        int $i$f$cachedFileAttribute = 0;
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Intrinsics.checkParameterIsNotNull(read2, (String)"read");
        Intrinsics.checkParameterIsNotNull(write, (String)"write");
        return new FileAttributeProperty<T>(read2, write, name2, version2, name2, version2){
            final /* synthetic */ Function1 $read;
            final /* synthetic */ Function2 $write;
            final /* synthetic */ String $name;
            final /* synthetic */ int $version;

            @NotNull
            public T readValue(@NotNull DataInputStream input) {
                Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                return (T)this.$read.invoke((Object)input);
            }

            public void writeValue(@NotNull DataOutputStream output, @NotNull T value2) {
                Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
                Intrinsics.checkParameterIsNotNull(value2, (String)"value");
                this.$write.invoke((Object)output, value2);
            }
            {
                this.$read = $captured_local_variable$0;
                this.$write = $captured_local_variable$1;
                this.$name = $captured_local_variable$2;
                this.$version = $captured_local_variable$3;
                super($super_call_param$4, $super_call_param$5, null, 4, null);
            }
        };
    }

    @NotNull
    public static final List<String> readStringList(@NotNull DataInput $this$readStringList) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readStringList, (String)"$this$readStringList");
        List list2 = DataInputOutputUtil.readSeq((DataInput)$this$readStringList, (ThrowableComputable)new ThrowableComputable<T, IOException>($this$readStringList){
            final /* synthetic */ DataInput $this_readStringList;

            @NotNull
            public final String compute() {
                return FileAttributeUtilsKt.readString(this.$this_readStringList);
            }
            {
                this.$this_readStringList = dataInput;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"readSeq(this) { readString() }");
        return list2;
    }

    @NotNull
    public static final List<File> readFileList(@NotNull DataInput $this$readFileList) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readFileList, (String)"$this$readFileList");
        List list2 = DataInputOutputUtil.readSeq((DataInput)$this$readFileList, (ThrowableComputable)new ThrowableComputable<T, IOException>($this$readFileList){
            final /* synthetic */ DataInput $this_readFileList;

            @NotNull
            public final File compute() {
                return FileAttributeUtilsKt.readFile(this.$this_readFileList);
            }
            {
                this.$this_readFileList = dataInput;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"readSeq(this) { readFile() }");
        return list2;
    }

    @NotNull
    public static final String readString(@NotNull DataInput $this$readString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readString, (String)"$this$readString");
        String string = IOUtil.readUTF((DataInput)$this$readString);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"readUTF(this)");
        return string;
    }

    @NotNull
    public static final File readFile(@NotNull DataInput $this$readFile) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readFile, (String)"$this$readFile");
        return new File(IOUtil.readUTF((DataInput)$this$readFile));
    }

    public static final void writeFileList(@NotNull DataOutput $this$writeFileList, @NotNull Iterable<? extends File> iterable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeFileList, (String)"$this$writeFileList");
        Intrinsics.checkParameterIsNotNull(iterable, (String)"iterable");
        DataInputOutputUtil.writeSeq((DataOutput)$this$writeFileList, (Collection)CollectionsKt.toList(iterable), (ThrowableConsumer)new ThrowableConsumer<T, IOException>($this$writeFileList){
            final /* synthetic */ DataOutput $this_writeFileList;

            public final void consume(File it) {
                File file2 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                FileAttributeUtilsKt.writeFile(this.$this_writeFileList, file2);
            }
            {
                this.$this_writeFileList = dataOutput;
            }
        });
    }

    public static final void writeFile(@NotNull DataOutput $this$writeFile, @NotNull File it) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeFile, (String)"$this$writeFile");
        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
        String string = it.getCanonicalPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.canonicalPath");
        FileAttributeUtilsKt.writeString($this$writeFile, string);
    }

    public static final void writeString(@NotNull DataOutput $this$writeString, @NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeString, (String)"$this$writeString");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        IOUtil.writeUTF((DataOutput)$this$writeString, (String)string);
    }

    public static final void writeStringList(@NotNull DataOutput $this$writeStringList, @NotNull Iterable<String> iterable) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeStringList, (String)"$this$writeStringList");
        Intrinsics.checkParameterIsNotNull(iterable, (String)"iterable");
        DataInputOutputUtil.writeSeq((DataOutput)$this$writeStringList, (Collection)CollectionsKt.toList(iterable), (ThrowableConsumer)new ThrowableConsumer<T, IOException>($this$writeStringList){
            final /* synthetic */ DataOutput $this_writeStringList;

            public final void consume(String it) {
                String string = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                FileAttributeUtilsKt.writeString(this.$this_writeStringList, string);
            }
            {
                this.$this_writeStringList = dataOutput;
            }
        });
    }

    public static final <T> void writeNullable(@NotNull DataOutput $this$writeNullable, @Nullable T nullable2, @NotNull Function2<? super DataOutput, ? super T, Unit> writeT) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)$this$writeNullable, (String)"$this$writeNullable");
            Intrinsics.checkParameterIsNotNull(writeT, (String)"writeT");
            $this$writeNullable.writeBoolean(nullable2 != null);
            T t = nullable2;
            if (t == null) break block0;
            T t2 = t;
            boolean bl = false;
            boolean bl2 = false;
            T it = t2;
            boolean bl3 = false;
            writeT.invoke((Object)$this$writeNullable, it);
        }
    }

    @Nullable
    public static final <T> T readNullable(@NotNull DataInput $this$readNullable, @NotNull Function1<? super DataInput, ? extends T> readT) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readNullable, (String)"$this$readNullable");
        Intrinsics.checkParameterIsNotNull(readT, (String)"readT");
        boolean hasValue = $this$readNullable.readBoolean();
        return (T)(hasValue ? readT.invoke((Object)$this$readNullable) : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final /* synthetic */ <T> void writeObject(@NotNull DataOutputStream $this$writeObject, @NotNull T obj) {
        int $i$f$writeObject = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$writeObject, (String)"$this$writeObject");
        Intrinsics.checkParameterIsNotNull(obj, (String)"obj");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Closeable closeable = new ObjectOutputStream(os);
        boolean bl = false;
        Throwable throwable = null;
        try {
            ObjectOutputStream oos = (ObjectOutputStream)closeable;
            boolean bl2 = false;
            oos.writeObject(obj);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        byte[] bytes2 = os.toByteArray();
        $this$writeObject.writeInt(bytes2.length);
        $this$writeObject.write(bytes2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final /* synthetic */ <T> T readObject(@NotNull DataInputStream $this$readObject) {
        Object object;
        int $i$f$readObject = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$readObject, (String)"$this$readObject");
        int size = $this$readObject.readInt();
        byte[] bytes2 = new byte[size];
        $this$readObject.read(bytes2, 0, size);
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes2);
        Closeable closeable = new ObjectInputStream(bis);
        boolean bl = false;
        Throwable throwable = null;
        try {
            ObjectInputStream ois = (ObjectInputStream)closeable;
            boolean bl2 = false;
            Object object2 = ois.readObject();
            Intrinsics.reifiedOperationMarker((int)1, (String)"T");
            object = object2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)object;
    }
}

