/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006\u001a\u0014\u0010\u0007\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\b\u001a\u00020\t\u001a\u0019\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0006\u001a!\u0010\n\u001a\u0004\u0018\u00010\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\f\u001a\n\u0010\r\u001a\u00020\t*\u00020\u0002\u00a8\u0006\u000e"}, d2={"getLineCount", "", "Lcom/intellij/psi/PsiElement;", "getLineEndOffset", "Lcom/intellij/psi/PsiFile;", "line", "(Lcom/intellij/psi/PsiFile;I)Ljava/lang/Integer;", "getLineNumber", "start", "", "getLineStartOffset", "skipWhitespace", "(Lcom/intellij/psi/PsiFile;IZ)Ljava/lang/Integer;", "isMultiLine", "idea-core"})
public final class PsiLinesUtilsKt {
    @Nullable
    public static final Integer getLineStartOffset(@NotNull PsiFile $this$getLineStartOffset, int line) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getLineStartOffset, (String)"$this$getLineStartOffset");
        return PsiLinesUtilsKt.getLineStartOffset($this$getLineStartOffset, line, true);
    }

    @Nullable
    public static final Integer getLineStartOffset(@NotNull PsiFile $this$getLineStartOffset, int line, boolean skipWhitespace) {
        Document doc;
        Intrinsics.checkParameterIsNotNull((Object)$this$getLineStartOffset, (String)"$this$getLineStartOffset");
        FileViewProvider fileViewProvider = $this$getLineStartOffset.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"viewProvider");
        Document document = fileViewProvider.getDocument();
        if (document == null) {
            document = doc = PsiDocumentManager.getInstance((Project)$this$getLineStartOffset.getProject()).getDocument($this$getLineStartOffset);
        }
        if (doc != null && line >= 0 && line < doc.getLineCount()) {
            int startOffset = doc.getLineStartOffset(line);
            PsiElement psiElement2 = $this$getLineStartOffset.findElementAt(startOffset);
            if (psiElement2 == null) {
                return startOffset;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"findElementAt(startOffset) ?: return startOffset");
            PsiElement element3 = psiElement2;
            if (skipWhitespace && (element3 instanceof PsiWhiteSpace || element3 instanceof PsiComment)) {
                PsiElement psiElement3 = PsiTreeUtil.skipSiblingsForward((PsiElement)element3, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
                return psiElement3 != null ? PsiUtilsKt.getStartOffset(psiElement3) : startOffset;
            }
            return startOffset;
        }
        return null;
    }

    @Nullable
    public static final Integer getLineEndOffset(@NotNull PsiFile $this$getLineEndOffset, int line) {
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)$this$getLineEndOffset, (String)"$this$getLineEndOffset");
        FileViewProvider fileViewProvider = $this$getLineEndOffset.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"viewProvider");
        Document document2 = fileViewProvider.getDocument();
        if (document2 == null) {
            document2 = PsiDocumentManager.getInstance((Project)$this$getLineEndOffset.getProject()).getDocument($this$getLineEndOffset);
        }
        Document document3 = document = document2;
        return document3 != null ? Integer.valueOf(document3.getLineEndOffset(line)) : null;
    }

    public static final int getLineNumber(@NotNull PsiElement $this$getLineNumber, boolean start2) {
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)$this$getLineNumber, (String)"$this$getLineNumber");
        PsiFile psiFile2 = $this$getLineNumber.getContainingFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"containingFile");
        FileViewProvider fileViewProvider = psiFile2.getViewProvider();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileViewProvider, (String)"containingFile.viewProvider");
        Document document2 = fileViewProvider.getDocument();
        if (document2 == null) {
            document2 = PsiDocumentManager.getInstance((Project)$this$getLineNumber.getProject()).getDocument($this$getLineNumber.getContainingFile());
        }
        Document document3 = document = document2;
        return document3 != null ? document3.getLineNumber(start2 ? PsiUtilsKt.getStartOffset($this$getLineNumber) : PsiUtilsKt.getEndOffset($this$getLineNumber)) : 0;
    }

    public static /* synthetic */ int getLineNumber$default(PsiElement psiElement2, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return PsiLinesUtilsKt.getLineNumber(psiElement2, bl);
    }

    public static final int getLineCount(@NotNull PsiElement $this$getLineCount) {
        String string;
        Document doc;
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)$this$getLineCount, (String)"$this$getLineCount");
        PsiFile psiFile2 = $this$getLineCount.getContainingFile();
        if (psiFile2 != null) {
            PsiFile psiFile3 = psiFile2;
            boolean bl = false;
            boolean bl2 = false;
            PsiFile file2 = psiFile3;
            boolean bl3 = false;
            document = PsiDocumentManager.getInstance((Project)$this$getLineCount.getProject()).getDocument(file2);
        } else {
            document = doc = null;
        }
        if (doc != null) {
            TextRange spaceRange;
            TextRange textRange = $this$getLineCount.getTextRange();
            if (textRange == null) {
                textRange = TextRange.EMPTY_RANGE;
            }
            TextRange textRange2 = spaceRange = textRange;
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"spaceRange");
            if (textRange2.getEndOffset() <= doc.getTextLength()) {
                int startLine = doc.getLineNumber(spaceRange.getStartOffset());
                int endLine = doc.getLineNumber(spaceRange.getEndOffset());
                return endLine - startLine;
            }
        }
        if ((string = $this$getLineCount.getText()) == null) {
            string = "";
        }
        CharSequence $this$count$iv = string;
        boolean $i$f$count = false;
        int count$iv = 0;
        CharSequence charSequence = $this$count$iv;
        for (int j = 0; j < charSequence.length(); ++j) {
            char element$iv;
            char it = element$iv = charSequence.charAt(j);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        return count$iv + 1;
    }

    public static final boolean isMultiLine(@NotNull PsiElement $this$isMultiLine) {
        Intrinsics.checkParameterIsNotNull((Object)$this$isMultiLine, (String)"$this$isMultiLine");
        return PsiLinesUtilsKt.getLineCount($this$isMultiLine) > 1;
    }
}

