/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.breakpoints;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import java.util.List;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaLineBreakpointProperties;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.debugger.KotlinPositionManager;
import org.jetbrains.kotlin.idea.debugger.breakpoints.ApplicabilityResult;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinBreakpointType;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinLineBreakpoint;
import org.jetbrains.kotlin.idea.debugger.breakpoints.LineBreakpointExpressionVisitor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;

public class KotlinLineBreakpointType
extends JavaLineBreakpointType
implements KotlinBreakpointType {
    public KotlinLineBreakpointType() {
        super("kotlin-line", KotlinDebuggerCoreBundle.message("line.breakpoint.tab.title", new Object[0]));
    }

    @NotNull
    public Breakpoint<JavaLineBreakpointProperties> createJavaBreakpoint(Project project2, XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        return new KotlinLineBreakpoint(project2, (XBreakpoint<? extends XBreakpointProperties<?>>)breakpoint);
    }

    public boolean matchesPosition(@NotNull LineBreakpoint<?> breakpoint, @NotNull SourcePosition position2) {
        JavaBreakpointProperties properties2;
        if (breakpoint == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(0);
        }
        if (position2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(1);
        }
        if ((properties2 = KotlinLineBreakpointType.getProperties(breakpoint)) == null || properties2 instanceof JavaLineBreakpointProperties) {
            if (position2 instanceof KotlinPositionManager.KotlinReentrantSourcePosition) {
                return false;
            }
            if (properties2 != null && ((JavaLineBreakpointProperties)properties2).getLambdaOrdinal() == null) {
                return true;
            }
            PsiElement containingMethod = this.getContainingMethod(breakpoint);
            if (containingMethod == null) {
                return false;
            }
            return KotlinLineBreakpointType.inTheMethod(position2, containingMethod);
        }
        return true;
    }

    @Nullable
    public PsiElement getContainingMethod(@NotNull LineBreakpoint<?> breakpoint) {
        Integer ordinal;
        KtFunction lambda2;
        SourcePosition position2;
        if (breakpoint == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(2);
        }
        if ((position2 = breakpoint.getSourcePosition()) == null) {
            return null;
        }
        JavaBreakpointProperties properties2 = KotlinLineBreakpointType.getProperties(breakpoint);
        if (properties2 instanceof JavaLineBreakpointProperties && (lambda2 = KotlinLineBreakpointType.getLambdaByOrdinal(position2, ordinal = ((JavaLineBreakpointProperties)properties2).getLambdaOrdinal())) != null) {
            return lambda2;
        }
        return KotlinLineBreakpointType.getContainingMethod(position2.getElementAt());
    }

    @Nullable
    private static JavaBreakpointProperties getProperties(@NotNull LineBreakpoint<?> breakpoint) {
        XBreakpoint xBreakpoint;
        if (breakpoint == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(3);
        }
        return (xBreakpoint = breakpoint.getXBreakpoint()) != null ? (JavaBreakpointProperties)xBreakpoint.getProperties() : null;
    }

    @Nullable
    private static KtFunction getLambdaByOrdinal(SourcePosition position2, Integer ordinal) {
        List<KtFunction> lambdas;
        if (ordinal != null && ordinal >= 0 && (lambdas = BreakpointTypeUtilsKt.getLambdasAtLineIfAny(position2)).size() > ordinal) {
            return lambdas.get(ordinal);
        }
        return null;
    }

    @Nullable
    public static PsiElement getContainingMethod(@Nullable PsiElement elem) {
        return PsiTreeUtil.getParentOfType((PsiElement)elem, (Class[])new Class[]{KtFunction.class, KtClassInitializer.class});
    }

    public static boolean inTheMethod(@NotNull SourcePosition pos, @NotNull PsiElement method) {
        PsiElement elem;
        if (pos == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(4);
        }
        if (method == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(5);
        }
        if ((elem = pos.getElementAt()) == null) {
            return false;
        }
        return Comparing.equal((Object)KotlinLineBreakpointType.getContainingMethod(elem), (Object)method);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        if (file2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(7);
        }
        return BreakpointTypeUtilsKt.isBreakpointApplicable(file2, line, project2, (Function1<? super PsiElement, ApplicabilityResult>)((Function1)element3 -> {
            LineBreakpointExpressionVisitor visitor2;
            KtCallableDeclaration callable2;
            if (element3 instanceof KtDestructuringDeclaration) {
                return ApplicabilityResult.MAYBE_YES;
            }
            PsiElement containingMethod = KotlinLineBreakpointType.getContainingMethod(element3);
            if (containingMethod instanceof KtCallableDeclaration && BreakpointTypeUtilsKt.isInlineOnly(callable2 = (KtCallableDeclaration)containingMethod)) {
                return ApplicabilityResult.DEFINITELY_NO;
            }
            if (KotlinLineBreakpointType.isClosingBraceInMethod(element3)) {
                return ApplicabilityResult.MAYBE_YES;
            }
            if (element3 instanceof KtElement && (visitor2 = LineBreakpointExpressionVisitor.of(file2, line)) != null) {
                ApplicabilityResult result2 = ((KtElement)element3).accept(visitor2, null);
                if (result2 == null) {
                    return ApplicabilityResult.UNKNOWN;
                }
                return result2;
            }
            return ApplicabilityResult.UNKNOWN;
        }));
    }

    private static boolean isClosingBraceInMethod(PsiElement element3) {
        if (element3 instanceof LeafPsiElement && element3.getNode().getElementType() == KtTokens.RBRACE) {
            PsiElement owner;
            PsiElement blockExpression2 = element3.getParent();
            if (blockExpression2 instanceof KtFunctionLiteral) {
                return true;
            }
            if (blockExpression2 instanceof KtBlockExpression && ((owner = blockExpression2.getParent()) instanceof KtFunction || owner instanceof KtClassInitializer)) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public List<JavaLineBreakpointType.JavaBreakpointVariant> computeVariants(@NotNull Project project2, @NotNull XSourcePosition position2) {
        if (project2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(8);
        }
        if (position2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(9);
        }
        List<JavaLineBreakpointType.JavaBreakpointVariant> list2 = BreakpointTypeUtilsKt.computeLineBreakpointVariants(project2, position2, this);
        if (list2 == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @Nullable
    public TextRange getHighlightRange(XLineBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        KtFunction lambda2;
        SourcePosition position2;
        Breakpoint javaBreakpoint;
        Integer ordinal;
        JavaLineBreakpointProperties properties2 = (JavaLineBreakpointProperties)breakpoint.getProperties();
        if (properties2 != null && (ordinal = properties2.getLambdaOrdinal()) != null && (javaBreakpoint = BreakpointManager.getJavaBreakpoint(breakpoint)) instanceof LineBreakpoint && (position2 = ((LineBreakpoint)javaBreakpoint).getSourcePosition()) != null && (lambda2 = KotlinLineBreakpointType.getLambdaByOrdinal(position2, ordinal)) != null) {
            return lambda2.getTextRange();
        }
        return null;
    }

    @Nullable
    private static SourcePosition createLineSourcePosition(@NotNull XLineBreakpointImpl breakpoint) {
        PsiManager psiManager;
        PsiFile psiFile2;
        VirtualFile file2;
        if (breakpoint == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(11);
        }
        if ((file2 = breakpoint.getFile()) != null && (psiFile2 = (PsiFile)ReadAction.compute(() -> KotlinLineBreakpointType.lambda$createLineSourcePosition$1(psiManager = PsiManager.getInstance((Project)breakpoint.getProject()), file2))) != null) {
            return SourcePosition.createFromLine((PsiFile)psiFile2, (int)breakpoint.getLine());
        }
        return null;
    }

    @Nullable
    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<JavaLineBreakpointProperties> breakpoint) {
        JavaBreakpointProperties javaBreakpointProperties;
        if (breakpoint == null) {
            KotlinLineBreakpointType.$$$reportNull$$$0(12);
        }
        if ((javaBreakpointProperties = (JavaBreakpointProperties)breakpoint.getProperties()) != null) {
            KtExpression bodyElement;
            KtFunction function2;
            Integer ordinal = ((JavaLineBreakpointProperties)javaBreakpointProperties).getLambdaOrdinal();
            SourcePosition sourcePosition2 = KotlinLineBreakpointType.createLineSourcePosition((XLineBreakpointImpl)breakpoint);
            if (sourcePosition2 != null && (function2 = KotlinLineBreakpointType.getLambdaByOrdinal(sourcePosition2, ordinal)) != null && (bodyElement = function2.getBodyExpression()) != null) {
                SourcePosition linePosition = SourcePosition.createFromElement((PsiElement)bodyElement);
                return (XSourcePosition)ReadAction.compute(() -> {
                    if (linePosition != null) {
                        return DebuggerUtilsEx.toXSourcePosition((SourcePosition)new PositionManagerImpl.JavaSourcePosition(linePosition, ordinal.intValue()));
                    }
                    return null;
                });
            }
        }
        return super.getSourcePosition(breakpoint);
    }

    private static /* synthetic */ PsiFile lambda$createLineSourcePosition$1(PsiManager psiManager, VirtualFile file2) throws RuntimeException {
        return psiManager.findFile(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "matchesPosition";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getContainingMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "inTheMethod";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "canPutAt";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeVariants";
                break;
            }
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createLineSourcePosition";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourcePosition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class KotlinBreakpointVariant
    extends JavaLineBreakpointType.JavaBreakpointVariant {
        private final int lambdaCount;

        public KotlinBreakpointVariant(XSourcePosition position2, int lambdaCount) {
            if (position2 == null) {
                KotlinBreakpointVariant.$$$reportNull$$$0(0);
            }
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position2);
            this.lambdaCount = lambdaCount;
        }

        @NotNull
        public String getText() {
            String string = KotlinDebuggerCoreBundle.message("line.and.lambda.breakpoint", this.lambdaCount);
            if (string == null) {
                KotlinBreakpointVariant.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$KotlinBreakpointVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$KotlinBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public class LineKotlinBreakpointVariant
    extends JavaLineBreakpointType.LineJavaBreakpointVariant {
        public LineKotlinBreakpointVariant(@Nullable XSourcePosition position2, PsiElement element3, Integer lambdaOrdinal2) {
            if (position2 == null) {
                LineKotlinBreakpointVariant.$$$reportNull$$$0(0);
            }
            super((JavaLineBreakpointType)KotlinLineBreakpointType.this, position2, element3, lambdaOrdinal2);
        }

        @NotNull
        public String getText() {
            String string = KotlinDebuggerCoreBundle.message("line.breakpoint", new Object[0]);
            if (string == null) {
                LineKotlinBreakpointVariant.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "position";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$LineKotlinBreakpointVariant";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/idea/debugger/breakpoints/KotlinLineBreakpointType$LineKotlinBreakpointVariant";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

