/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.command;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.ClassesByNameProvider;
import com.intellij.debugger.jdi.GeneratedLocation;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.impl.watch.MethodsTracker;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.SafeUtilKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineAsyncStackTraceProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CreationCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.RestoredCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.RunningCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendCoroutineStackFrameItem;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SuspendStackFrameDescriptor;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.SyntheticStackFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.AsyncStackTraceContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 O2\u00020\u0001:\u0001OB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J.\u0010\"\u001a\u0010\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%\u0018\u00010#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u0016\u0010,\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020!0\u001aH\u0002J\"\u0010/\u001a\u00020\u001f2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020-H\u0002J\u0016\u00105\u001a\u00020-2\f\u0010.\u001a\b\u0012\u0004\u0012\u0002060\u001aH\u0002J\b\u00107\u001a\u000206H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020!H\u0002J\u0010\u0010;\u001a\u0002092\u0006\u0010<\u001a\u000206H\u0002J\u0010\u0010=\u001a\u0002092\u0006\u0010<\u001a\u000206H\u0002J \u0010>\u001a\u0002092\u0006\u0010?\u001a\u00020\u001b2\u0006\u0010@\u001a\u0002062\u0006\u0010A\u001a\u00020BH\u0002J\u000e\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FJ\u001e\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010@\u001a\u0002062\u0006\u0010K\u001a\u00020\u001fJ\u001e\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010@\u001a\u0002062\u0006\u0010 \u001a\u00020!J\u0010\u0010L\u001a\u0002092\u0006\u0010M\u001a\u00020FH\u0002J\b\u0010N\u001a\u00020DH\u0002R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006P"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/command/CoroutineBuilder;", "", "suspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "(Lcom/intellij/xdebugger/frame/XSuspendContext;)V", "classesByName", "Lcom/intellij/debugger/jdi/ClassesByNameProvider;", "kotlin.jvm.PlatformType", "getClassesByName", "()Lcom/intellij/debugger/jdi/ClassesByNameProvider;", "coroutineStackFrameProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineAsyncStackTraceProvider;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "Lorg/jetbrains/annotations/NotNull;", "getDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcessImpl;", "methodsTracker", "Lcom/intellij/debugger/ui/impl/watch/MethodsTracker;", "getSuspendContext", "()Lcom/intellij/xdebugger/frame/XSuspendContext;", "virtualMachineProxy", "Lcom/intellij/debugger/jdi/VirtualMachineProxyImpl;", "getVirtualMachineProxy", "()Lcom/intellij/debugger/jdi/VirtualMachineProxyImpl;", "build", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineStackFrameItem;", "coroutine", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "createLocation", "Lcom/sun/jdi/Location;", "stackTraceElement", "Ljava/lang/StackTraceElement;", "createSyntheticStackFrame", "Lkotlin/Pair;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/SyntheticStackFrame;", "descriptor", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/SuspendStackFrameDescriptor;", "pos", "Lcom/intellij/xdebugger/XSourcePosition;", "project", "Lcom/intellij/openapi/project/Project;", "findCreationFrameIndex", "", "frames", "findLocation", "type", "Lcom/sun/jdi/ReferenceType;", "methodName", "", "line", "findResumeMethodIndex", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "firstSuspendedThreadFrame", "isCreationSeparatorFrame", "", "it", "isInvokeSuspendNegativeLineMethodFrame", "frame", "isResumeMethodFrame", "mergeRunningFirstFrameVars", "restoredFrame", "runningStackFrameProxy", "runningCoroutineStackFrameItem", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/RunningCoroutineStackFrameItem;", "runningThreadProxy", "Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;", "threadReference", "Lcom/sun/jdi/ThreadReference;", "stackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "positionManager", "Lcom/intellij/debugger/engine/CompoundPositionManager;", "location", "suspendedSameThread", "activeThread", "suspendedThreadProxy", "Companion", "jvm-debugger-coroutine"})
public final class CoroutineBuilder {
    private final MethodsTracker methodsTracker;
    private final CoroutineAsyncStackTraceProvider coroutineStackFrameProvider;
    @NotNull
    private final DebugProcessImpl debugProcess;
    @NotNull
    private final VirtualMachineProxyImpl virtualMachineProxy;
    private final ClassesByNameProvider classesByName;
    @NotNull
    private final XSuspendContext suspendContext;
    @NotNull
    private static final String CREATION_STACK_TRACE_SEPARATOR = "\b\b\b";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final DebugProcessImpl getDebugProcess() {
        return this.debugProcess;
    }

    @NotNull
    public final VirtualMachineProxyImpl getVirtualMachineProxy() {
        return this.virtualMachineProxy;
    }

    public final ClassesByNameProvider getClassesByName() {
        return this.classesByName;
    }

    @NotNull
    public final List<CoroutineStackFrameItem> build(@NotNull CoroutineInfoData coroutine) {
        Intrinsics.checkParameterIsNotNull((Object)coroutine, (String)"coroutine");
        boolean bl = false;
        List coroutineStackFrameList = new ArrayList();
        StackFrameProxyImpl firstSuspendedStackFrameProxyImpl = this.firstSuspendedThreadFrame();
        int creationFrameSeparatorIndex = this.findCreationFrameIndex(coroutine.getStackTrace());
        CompoundPositionManager compoundPositionManager = this.debugProcess.getPositionManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)compoundPositionManager, (String)"debugProcess.positionManager");
        CompoundPositionManager positionManager = compoundPositionManager;
        if (coroutine.getState() == CoroutineInfoData.State.RUNNING && coroutine.getActiveThread() instanceof ThreadReference) {
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.runningThreadProxy(coroutine.getActiveThread());
            JavaExecutionStack executionStack = new JavaExecutionStack(threadReferenceProxyImpl, this.debugProcess, this.suspendedSameThread(coroutine.getActiveThread()));
            List list2 = threadReferenceProxyImpl.forceFrames();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"threadReferenceProxyImpl.forceFrames()");
            List frames2 = list2;
            boolean coroutineStackInserted = false;
            Iterator iterator2 = frames2.iterator();
            while (iterator2.hasNext()) {
                XStackFrame jStackFrame;
                StackFrameProxyImpl runningStackFrameProxy = (StackFrameProxyImpl)iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)executionStack.createStackFrame(runningStackFrameProxy), (String)"executionStack.createSta\u2026e(runningStackFrameProxy)");
                StackFrameProxyImpl stackFrameProxyImpl = runningStackFrameProxy;
                Intrinsics.checkExpressionValueIsNotNull((Object)stackFrameProxyImpl, (String)"runningStackFrameProxy");
                List<CoroutineStackFrameItem> coroutineStack = this.coroutineStackFrameProvider.getAsyncStackTraceSafe(stackFrameProxyImpl, this.suspendContext);
                if (coroutineStack != null && !coroutineStack.isEmpty()) {
                    RunningCoroutineStackFrameItem runningCoroutineStackFrameItem = new RunningCoroutineStackFrameItem(runningStackFrameProxy, jStackFrame);
                    coroutineStackFrameList.add(runningCoroutineStackFrameItem);
                    if (this.mergeRunningFirstFrameVars((CoroutineStackFrameItem)((Object)CollectionsKt.first(coroutineStack)), runningStackFrameProxy, runningCoroutineStackFrameItem)) {
                        coroutineStack.remove(0);
                    }
                    for (CoroutineStackFrameItem asyncFrame : coroutineStack) {
                        coroutineStackFrameList.add(new RestoredCoroutineStackFrameItem(runningStackFrameProxy, asyncFrame.getLocation(), asyncFrame.getSpilledVariables()));
                        coroutineStackInserted = true;
                    }
                    continue;
                }
                if (coroutineStackInserted && this.isInvokeSuspendNegativeLineMethodFrame(runningStackFrameProxy)) {
                    coroutineStackInserted = false;
                    continue;
                }
                coroutineStackFrameList.add(new RunningCoroutineStackFrameItem(runningStackFrameProxy, jStackFrame));
            }
        } else if ((coroutine.getState() == CoroutineInfoData.State.SUSPENDED || coroutine.getActiveThread() == null) && coroutine.getLastObservedFrameFieldRef() instanceof ObjectReference) {
            List suspendedStackTrace = CollectionsKt.take((Iterable)coroutine.getStackTrace(), (int)creationFrameSeparatorIndex);
            for (StackTraceElement suspendedFrame : suspendedStackTrace) {
                Location location2 = this.createLocation(suspendedFrame);
                coroutineStackFrameList.add(new SuspendCoroutineStackFrameItem(firstSuspendedStackFrameProxyImpl, suspendedFrame, coroutine.getLastObservedFrameFieldRef(), location2));
            }
        }
        JavaExecutionStack executionStack = new JavaExecutionStack(this.suspendedThreadProxy(), this.debugProcess, false);
        XStackFrame xStackFrame = executionStack.createStackFrame(firstSuspendedStackFrameProxyImpl);
        Intrinsics.checkExpressionValueIsNotNull((Object)xStackFrame, (String)"executionStack.createSta\u2026endedStackFrameProxyImpl)");
        XStackFrame xStackFrame2 = xStackFrame;
        Iterable $this$forEach$iv = coroutine.getStackTrace().subList(creationFrameSeparatorIndex + 1, coroutine.getStackTrace().size());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StackTraceElement it = (StackTraceElement)element$iv;
            boolean bl2 = false;
            Location location3 = this.createLocation(it);
            coroutineStackFrameList.add(new CreationCoroutineStackFrameItem(firstSuspendedStackFrameProxyImpl, it, location3));
        }
        coroutine.getStackFrameList().addAll(coroutineStackFrameList);
        return coroutineStackFrameList;
    }

    private final boolean mergeRunningFirstFrameVars(CoroutineStackFrameItem restoredFrame, StackFrameProxyImpl runningStackFrameProxy, RunningCoroutineStackFrameItem runningCoroutineStackFrameItem) {
        Method realMethod;
        Method restoredMethod;
        if (restoredFrame.getLocation() instanceof GeneratedLocation && Intrinsics.areEqual((Object)(restoredMethod = restoredFrame.getLocation().method()), (Object)(realMethod = runningStackFrameProxy.location().method()))) {
            runningCoroutineStackFrameItem.getSpilledVariables().addAll((Collection<XNamedValue>)restoredFrame.getSpilledVariables());
            return true;
        }
        return false;
    }

    private final boolean suspendedSameThread(ThreadReference activeThread) {
        return Intrinsics.areEqual((Object)activeThread, (Object)this.suspendedThreadProxy().getThreadReference());
    }

    private final Location createLocation(StackTraceElement stackTraceElement) {
        ReferenceType referenceType = (ReferenceType)ContainerUtil.getFirstItem((List)this.classesByName.get(stackTraceElement.getClassName()));
        String string = stackTraceElement.getMethodName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stackTraceElement.methodName");
        return this.findLocation(referenceType, string, stackTraceElement.getLineNumber());
    }

    private final Location findLocation(ReferenceType type2, String methodName2, int line) {
        if (type2 != null && line >= 0) {
            try {
                Location location2 = type2.locationsOfLine("Java", null, line).stream().filter((Predicate)new Predicate<Location>(methodName2){
                    final /* synthetic */ String $methodName;

                    public final boolean test(@NotNull Location l) {
                        Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
                        return Intrinsics.areEqual((Object)l.method().name(), (Object)this.$methodName);
                    }
                    {
                        this.$methodName = string;
                    }
                }).findFirst().orElse(null);
                if (location2 != null) {
                    return location2;
                }
            }
            catch (AbsentInformationException absentInformationException) {
                // empty catch block
            }
        }
        return (Location)new GeneratedLocation(this.debugProcess, type2, methodName2, line);
    }

    @NotNull
    public final XStackFrame stackFrame(@NotNull CompoundPositionManager positionManager, @NotNull StackFrameProxyImpl runningStackFrameProxy, @NotNull Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)positionManager, (String)"positionManager");
        Intrinsics.checkParameterIsNotNull((Object)runningStackFrameProxy, (String)"runningStackFrameProxy");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        XStackFrame xStackFrame = positionManager.createStackFrame(runningStackFrameProxy, this.debugProcess, location2);
        if (xStackFrame == null) {
            Intrinsics.throwNpe();
        }
        return xStackFrame;
    }

    @NotNull
    public final XStackFrame stackFrame(@NotNull CompoundPositionManager positionManager, @NotNull StackFrameProxyImpl runningStackFrameProxy, @NotNull StackTraceElement stackTraceElement) {
        Intrinsics.checkParameterIsNotNull((Object)positionManager, (String)"positionManager");
        Intrinsics.checkParameterIsNotNull((Object)runningStackFrameProxy, (String)"runningStackFrameProxy");
        Intrinsics.checkParameterIsNotNull((Object)stackTraceElement, (String)"stackTraceElement");
        Location location2 = this.createLocation(stackTraceElement);
        XStackFrame xStackFrame = positionManager.createStackFrame(runningStackFrameProxy, this.debugProcess, location2);
        if (xStackFrame == null) {
            Intrinsics.throwNpe();
        }
        return xStackFrame;
    }

    private final int findCreationFrameIndex(List<StackTraceElement> frames2) {
        int n;
        block2: {
            List<StackTraceElement> $this$indexOfFirst$iv = frames2;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            Iterator<StackTraceElement> iterator2 = $this$indexOfFirst$iv.iterator();
            while (iterator2.hasNext()) {
                StackTraceElement item$iv;
                StackTraceElement it = item$iv = iterator2.next();
                boolean bl = false;
                if (this.isCreationSeparatorFrame(it)) {
                    n = index$iv;
                    break block2;
                }
                ++index$iv;
            }
            n = -1;
        }
        int index2 = n;
        return index2 < 0 ? CollectionsKt.getLastIndex(frames2) : index2;
    }

    private final boolean isCreationSeparatorFrame(StackTraceElement it) {
        String string = it.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.className");
        return StringsKt.startsWith$default((String)string, (String)CREATION_STACK_TRACE_SEPARATOR, (boolean)false, (int)2, null);
    }

    private final StackFrameProxyImpl firstSuspendedThreadFrame() {
        List list2 = this.suspendedThreadProxy().forceFrames();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"suspendedThreadProxy().forceFrames()");
        Object object = CollectionsKt.first((List)list2);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"suspendedThreadProxy().forceFrames().first()");
        return (StackFrameProxyImpl)object;
    }

    @NotNull
    public final ThreadReferenceProxyImpl runningThreadProxy(@NotNull ThreadReference threadReference) {
        Intrinsics.checkParameterIsNotNull((Object)threadReference, (String)"threadReference");
        return new ThreadReferenceProxyImpl(this.debugProcess.getVirtualMachineProxy(), threadReference);
    }

    private final ThreadReferenceProxyImpl suspendedThreadProxy() {
        XSuspendContext xSuspendContext = this.suspendContext;
        if (xSuspendContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.debugger.engine.SuspendContextImpl");
        }
        ThreadReferenceProxyImpl threadReferenceProxyImpl = ((SuspendContextImpl)xSuspendContext).getThread();
        if (threadReferenceProxyImpl == null) {
            Intrinsics.throwNpe();
        }
        return threadReferenceProxyImpl;
    }

    /*
     * WARNING - void declaration
     */
    private final int findResumeMethodIndex(List<? extends StackFrameProxyImpl> frames2) {
        int n = CollectionsKt.getLastIndex(frames2);
        boolean bl = false;
        while (n >= 0) {
            void i2;
            if (this.isResumeMethodFrame(frames2.get((int)i2))) {
                return (int)i2;
            }
            --i2;
        }
        return 0;
    }

    private final boolean isResumeMethodFrame(StackFrameProxyImpl frame) {
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)frame);
        return Intrinsics.areEqual((Object)(comparable != null && (comparable = SafeUtilKt.safeMethod((Location)comparable)) != null ? comparable.name() : null), (Object)"resumeWith");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInvokeSuspendNegativeLineMethodFrame(StackFrameProxyImpl frame) {
        Comparable<Location> comparable = SafeUtilKt.safeLocation((StackFrameProxy)frame);
        if (!Intrinsics.areEqual((Object)(comparable != null && (comparable = SafeUtilKt.safeMethod((Location)comparable)) != null ? comparable.name() : null), (Object)"invokeSuspend")) return false;
        Location location2 = SafeUtilKt.safeLocation((StackFrameProxy)frame);
        if (location2 == null) return false;
        int n = SafeUtilKt.safeLineNumber(location2);
        if (n >= 0) return false;
        return true;
    }

    private final Pair<XExecutionStack, SyntheticStackFrame> createSyntheticStackFrame(SuspendStackFrameDescriptor descriptor2, XSourcePosition pos, Project project2) {
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
        DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getInstanceEx(project).context");
        DebuggerContextImpl context2 = debuggerContextImpl;
        SuspendContextImpl suspendContextImpl = context2.getSuspendContext();
        if (suspendContextImpl == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)suspendContextImpl, (String)"context.suspendContext ?: return null");
        SuspendContextImpl suspendContext = suspendContextImpl;
        ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContext.getThread();
        if (threadReferenceProxyImpl == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)threadReferenceProxyImpl, (String)"suspendContext.thread ?: return null");
        ThreadReferenceProxyImpl proxy2 = threadReferenceProxyImpl;
        JavaExecutionStack executionStack = new JavaExecutionStack(proxy2, suspendContext.getDebugProcess(), false);
        executionStack.initTopFrame();
        EvaluationContextImpl evalContext = context2.createEvaluationContext();
        EvaluationContextImpl evaluationContextImpl = evalContext;
        if (evaluationContextImpl == null || (evaluationContextImpl = evaluationContextImpl.getFrameProxy()) == null) {
            return null;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)evaluationContextImpl, (String)"evalContext?.frameProxy ?: return null");
        EvaluationContextImpl frameProxy = evaluationContextImpl;
        ExecutionContext execContext = new ExecutionContext(evalContext, (StackFrameProxyImpl)frameProxy);
        ObjectReference continuation2 = descriptor2.getContinuation();
        Type type2 = continuation2.type();
        if (type2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
        }
        Method aMethod = ((ClassType)type2).concreteMethodByName("getStackTraceElement", "()Ljava/lang/StackTraceElement;");
        CoroutineAsyncStackTraceProvider coroutineAsyncStackTraceProvider = new CoroutineAsyncStackTraceProvider();
        boolean bl = false;
        boolean bl2 = false;
        CoroutineAsyncStackTraceProvider $this$with = coroutineAsyncStackTraceProvider;
        boolean bl3 = false;
        Method method = aMethod;
        Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"aMethod");
        List<XNamedValue> list2 = new AsyncStackTraceContext(execContext, method).getSpilledVariables(continuation2);
        if (list2 == null) {
            return null;
        }
        List<XNamedValue> vars = list2;
        return TuplesKt.to((Object)executionStack, (Object)((Object)new SyntheticStackFrame(descriptor2, vars, pos)));
    }

    @NotNull
    public final XSuspendContext getSuspendContext() {
        return this.suspendContext;
    }

    public CoroutineBuilder(@NotNull XSuspendContext suspendContext) {
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        this.suspendContext = suspendContext;
        this.methodsTracker = new MethodsTracker();
        this.coroutineStackFrameProvider = new CoroutineAsyncStackTraceProvider();
        XSuspendContext xSuspendContext = this.suspendContext;
        if (xSuspendContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.debugger.engine.SuspendContextImpl");
        }
        DebugProcessImpl debugProcessImpl = ((SuspendContextImpl)xSuspendContext).getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"(suspendContext as Suspe\u2026ContextImpl).debugProcess");
        this.debugProcess = debugProcessImpl;
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.debugProcess.getVirtualMachineProxy();
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualMachineProxyImpl, (String)"debugProcess.virtualMachineProxy");
        this.virtualMachineProxy = virtualMachineProxyImpl;
        this.classesByName = ClassesByNameProvider.createCache((List)this.virtualMachineProxy.allClasses());
    }

    static {
        CREATION_STACK_TRACE_SEPARATOR = CREATION_STACK_TRACE_SEPARATOR;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/command/CoroutineBuilder$Companion;", "", "()V", "CREATION_STACK_TRACE_SEPARATOR", "", "getCREATION_STACK_TRACE_SEPARATOR", "()Ljava/lang/String;", "jvm-debugger-coroutine"})
    public static final class Companion {
        @NotNull
        public final String getCREATION_STACK_TRACE_SEPARATOR() {
            return CREATION_STACK_TRACE_SEPARATOR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

