/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.command.CoroutineBuilder;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 62\u00020\u0001:\u000267B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0006\u0010\"\u001a\u00020#J\u0018\u0010$\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010%\u001a\u00020 H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0017H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020-0\u00122\u0006\u0010(\u001a\u00020\u0017H\u0002J\u0010\u0010.\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020\u0017H\u0002J\b\u0010/\u001a\u0004\u0018\u000100J\u0010\u00101\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J\u0010\u00102\u001a\u00020-2\u0006\u00103\u001a\u00020\u0017H\u0002J\u0010\u00104\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J\b\u00105\u001a\u0004\u0018\u000100R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineDebugProbesProxy;", "", "suspendContext", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "(Lcom/intellij/xdebugger/frame/XSuspendContext;)V", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "refs", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineDebugProbesProxy$ProcessReferences;", "getSuspendContext", "()Lcom/intellij/xdebugger/frame/XSuspendContext;", "dump", "", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoData;", "dumpCoroutines", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoCache;", "dumpCoroutinesInfo", "Lcom/sun/jdi/ObjectReference;", "enhanceStackTraceWithThreadDump", "args", "fetchClassName", "", "instance", "fetchCoroutineState", "fetchFileName", "fetchLine", "", "fetchMethodName", "frameBuilder", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/command/CoroutineBuilder;", "getElementFromList", "num", "getLastObservedThread", "Lcom/sun/jdi/ThreadReference;", "info", "threadRef", "Lcom/sun/jdi/Field;", "getName", "getStackTrace", "Ljava/lang/StackTraceElement;", "getState", "install", "Lcom/sun/jdi/Value;", "lastObservedStackTrace", "newStackTraceElement", "frame", "sizeOf", "uninstall", "Companion", "ProcessReferences", "jvm-debugger-coroutine"})
public final class CoroutineDebugProbesProxy {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty log$delegate;
    private ExecutionContext executionContext;
    private ProcessReferences refs;
    @NotNull
    private final XSuspendContext suspendContext;
    private static final String DEBUG_PACKAGE = "kotlinx.coroutines.debug";
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(CoroutineDebugProbesProxy.class), "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;"))};
        Companion = new Companion(null);
    }

    private final Logger getLog() {
        return (Logger)this.log$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Nullable
    public final synchronized Value install() {
        return ExecutionContext.invokeMethodAsVoid$default(this.executionContext, this.refs.getInstance(), "install", null, null, 12, null);
    }

    @Nullable
    public final synchronized Value uninstall() {
        return ExecutionContext.invokeMethodAsVoid$default(this.executionContext, this.refs.getInstance(), "uninstall", null, null, 12, null);
    }

    @NotNull
    public final synchronized CoroutineInfoCache dumpCoroutines() {
        CoroutineInfoCache coroutineInfoCache = new CoroutineInfoCache(null, null, 3, null);
        try {
            List<CoroutineInfoData> infoList = this.dump();
            coroutineInfoCache.ok(infoList);
        }
        catch (Throwable e) {
            this.getLog().error("Exception is thrown by calling dumpCoroutines.", e);
            coroutineInfoCache.fail();
        }
        return coroutineInfoCache;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CoroutineInfoData> dump() {
        ObjectReference objectReference = this.dumpCoroutinesInfo();
        if (objectReference == null) {
            return CollectionsKt.emptyList();
        }
        ObjectReference coroutinesInfo = objectReference;
        this.executionContext.keepReference(coroutinesInfo);
        int size = this.sizeOf(coroutinesInfo);
        boolean bl = false;
        ArrayList<CoroutineInfoData> arrayList = new ArrayList<CoroutineInfoData>(size);
        boolean bl2 = false;
        int n = 0;
        n = 0;
        int n2 = size;
        while (n < n2) {
            void it;
            int n3 = n++;
            boolean bl3 = false;
            int n4 = n3;
            ArrayList<CoroutineInfoData> arrayList2 = arrayList;
            boolean bl4 = false;
            ObjectReference elem = this.getElementFromList(coroutinesInfo, (int)it);
            CoroutineInfoData coroutineInfoData = this.fetchCoroutineState(elem);
            arrayList2.add(coroutineInfoData);
        }
        return arrayList;
    }

    private final ObjectReference dumpCoroutinesInfo() {
        return this.executionContext.invokeMethodAsObject(this.refs.getInstance(), this.refs.getDumpMethod(), new Value[0]);
    }

    @NotNull
    public final CoroutineBuilder frameBuilder() {
        return new CoroutineBuilder(this.suspendContext);
    }

    private final ObjectReference getElementFromList(ObjectReference instance, int num) {
        Value value2 = ExecutionContext.invokeMethod$default(this.executionContext, instance, this.refs.getGetRef(), CollectionsKt.listOf((Object)this.executionContext.getVm().getVirtualMachine().mirrorOf(num)), 0, 8, null);
        if (value2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        }
        return (ObjectReference)value2;
    }

    private final CoroutineInfoData fetchCoroutineState(ObjectReference instance) {
        String name2 = this.getName(instance);
        String state = this.getState(instance);
        ThreadReference thread = this.getLastObservedThread(instance, this.refs.getLastObservedThreadFieldRef());
        Value value2 = instance.getValue(this.refs.getLastObservedFrameFieldRef());
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        ObjectReference lastObservedFrameFieldRef = (ObjectReference)value2;
        List<StackTraceElement> stackTrace = this.getStackTrace(instance);
        return new CoroutineInfoData(name2, CoroutineInfoData.State.valueOf(state), stackTrace, thread, lastObservedFrameFieldRef);
    }

    private final String getName(ObjectReference info2) {
        String string;
        ObjectReference coroutineName;
        Value value2 = ExecutionContext.invokeMethod$default(this.executionContext, info2, this.refs.getGetContextRef(), CollectionsKt.emptyList(), 0, 8, null);
        if (!(value2 instanceof ObjectReference)) {
            value2 = null;
        }
        ObjectReference objectReference = (ObjectReference)value2;
        if (objectReference == null) {
            throw (Throwable)new IllegalArgumentException("Coroutine context must not be null");
        }
        ObjectReference coroutineContextInst = objectReference;
        Value value3 = ExecutionContext.invokeMethod$default(this.executionContext, coroutineContextInst, this.refs.getGetContextElement(), CollectionsKt.listOf((Object)this.refs.getKeyFieldValueRef()), 0, 8, null);
        if (!(value3 instanceof ObjectReference)) {
            value3 = null;
        }
        if ((coroutineName = (ObjectReference)value3) != null) {
            Value value4 = ExecutionContext.invokeMethod$default(this.executionContext, coroutineName, this.refs.getGetNameRef(), CollectionsKt.emptyList(), 0, 8, null);
            if (value4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.StringReference");
            }
            string = ((StringReference)value4).value();
        } else {
            string = "coroutine";
        }
        String name2 = string;
        Value value5 = info2.getValue(this.refs.getSequenceNumberFieldRef());
        if (value5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.LongValue");
        }
        long id = ((LongValue)value5).value();
        return name2 + '#' + id;
    }

    private final String getState(ObjectReference info2) {
        Value value2 = ExecutionContext.invokeMethod$default(this.executionContext, info2, this.refs.getGetStateRef(), CollectionsKt.emptyList(), 0, 8, null);
        if (value2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        }
        ObjectReference state = (ObjectReference)value2;
        Value value3 = ExecutionContext.invokeMethod$default(this.executionContext, state, this.refs.getToString(), CollectionsKt.emptyList(), 0, 8, null);
        if (value3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.StringReference");
        }
        String string = ((StringReference)value3).value();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"(executionContext.invoke\u2026 StringReference).value()");
        return string;
    }

    private final ThreadReference getLastObservedThread(ObjectReference info2, Field threadRef) {
        Value value2 = info2.getValue(threadRef);
        if (!(value2 instanceof ThreadReference)) {
            value2 = null;
        }
        return (ThreadReference)value2;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StackTraceElement> getStackTrace(ObjectReference info2) {
        ObjectReference frameList = this.lastObservedStackTrace(info2);
        int n = 0;
        List tmpList = new ArrayList();
        n = 0;
        int n2 = this.sizeOf(frameList);
        while (n < n2) {
            void it;
            ObjectReference frame = this.getElementFromList(frameList, (int)it);
            StackTraceElement ste = this.newStackTraceElement(frame);
            tmpList.add(ste);
            ++it;
        }
        ObjectReference mergedFrameList = this.enhanceStackTraceWithThreadDump(CollectionsKt.listOf((Object[])new ObjectReference[]{info2, frameList}));
        int size = this.sizeOf(mergedFrameList);
        int ste = 0;
        List list2 = new ArrayList();
        ste = 0;
        int n3 = size;
        while (ste < n3) {
            void it;
            ObjectReference frame = this.getElementFromList(mergedFrameList, (int)it);
            StackTraceElement ste2 = this.newStackTraceElement(frame);
            list2.add(ste2);
            ++it;
        }
        return list2;
    }

    private final StackTraceElement newStackTraceElement(ObjectReference frame) {
        return new StackTraceElement(this.fetchClassName(frame), this.fetchMethodName(frame), this.fetchFileName(frame), this.fetchLine(frame));
    }

    private final int fetchLine(ObjectReference instance) {
        Value value2 = instance.getValue(this.refs.getLineNumberFieldRef());
        if (!(value2 instanceof IntegerValue)) {
            value2 = null;
        }
        IntegerValue integerValue = (IntegerValue)value2;
        return integerValue != null ? integerValue.value() : -1;
    }

    private final String fetchFileName(ObjectReference instance) {
        Object object;
        Value value2 = instance.getValue(this.refs.getFileNameFieldRef());
        if (!(value2 instanceof StringReference)) {
            value2 = null;
        }
        if ((object = (StringReference)value2) == null || (object = object.value()) == null) {
            object = "";
        }
        return object;
    }

    private final String fetchMethodName(ObjectReference instance) {
        Object object;
        Value value2 = instance.getValue(this.refs.getMethodNameFieldRef());
        if (!(value2 instanceof StringReference)) {
            value2 = null;
        }
        if ((object = (StringReference)value2) == null || (object = object.value()) == null) {
            object = "";
        }
        return object;
    }

    private final String fetchClassName(ObjectReference instance) {
        Object object;
        Value value2 = instance.getValue(this.refs.getDeclaringClassFieldRef());
        if (!(value2 instanceof StringReference)) {
            value2 = null;
        }
        if ((object = (StringReference)value2) == null || (object = object.value()) == null) {
            object = "";
        }
        return object;
    }

    private final ObjectReference lastObservedStackTrace(ObjectReference instance) {
        Value value2 = ExecutionContext.invokeMethod$default(this.executionContext, instance, this.refs.getLastObservedStackTraceRef(), CollectionsKt.emptyList(), 0, 8, null);
        if (value2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        }
        return (ObjectReference)value2;
    }

    private final ObjectReference enhanceStackTraceWithThreadDump(List<? extends ObjectReference> args) {
        Value value2 = ExecutionContext.invokeMethod$default(this.executionContext, this.refs.getDebugProbesImplInstance(), this.refs.getEnhanceStackTraceWithThreadDumpRef(), args, 0, 8, null);
        if (value2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
        }
        return (ObjectReference)value2;
    }

    private final int sizeOf(ObjectReference args) {
        Value value2 = ExecutionContext.invokeMethod$default(this.executionContext, args, this.refs.getSizeRef(), CollectionsKt.emptyList(), 0, 8, null);
        if (value2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.IntegerValue");
        }
        return ((IntegerValue)value2).value();
    }

    private final ExecutionContext executionContext() {
        XSuspendContext xSuspendContext = this.suspendContext;
        if (xSuspendContext == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.debugger.engine.SuspendContextImpl");
        }
        EvaluationContextImpl evaluationContextImpl = new EvaluationContextImpl((SuspendContextImpl)xSuspendContext, ((SuspendContextImpl)this.suspendContext).getFrameProxy());
        StackFrameProxyImpl stackFrameProxyImpl = ((SuspendContextImpl)this.suspendContext).getFrameProxy();
        if (stackFrameProxyImpl == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.debugger.jdi.StackFrameProxyImpl");
        }
        return new ExecutionContext(evaluationContextImpl, stackFrameProxyImpl);
    }

    @NotNull
    public final XSuspendContext getSuspendContext() {
        return this.suspendContext;
    }

    public CoroutineDebugProbesProxy(@NotNull XSuspendContext suspendContext) {
        Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
        this.suspendContext = suspendContext;
        this.log$delegate = ProvidersKt.getLogger();
        this.executionContext = this.executionContext();
        this.refs = new ProcessReferences(this.executionContext);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b,\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0011\u0010\u000f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0011\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\bR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0011\u0010#\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001cR\u0011\u0010%\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010 R\u0011\u0010'\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010 R\u0011\u0010)\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010 R\u0011\u0010+\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010 R\u0011\u0010-\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010 R\u0011\u0010/\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\u0018R\u0019\u00101\u001a\n 2*\u0004\u0018\u00010\u001a0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001cR\u0011\u00104\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\u0018R\u0011\u00106\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010\u001cR\u0011\u00108\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010 R\u0011\u0010:\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u001cR\u0011\u0010<\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010\u001cR\u0011\u0010>\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010\fR\u0011\u0010@\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u001cR\u0011\u0010B\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u001cR\u0011\u0010D\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010 R\u0011\u0010F\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010\bR\u0011\u0010H\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010 \u00a8\u0006J"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineDebugProbesProxy$ProcessReferences;", "", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "(Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;)V", "classClsRef", "Lcom/sun/jdi/ClassType;", "getClassClsRef", "()Lcom/sun/jdi/ClassType;", "coroutineContextClsRef", "Lcom/sun/jdi/InterfaceType;", "getCoroutineContextClsRef", "()Lcom/sun/jdi/InterfaceType;", "coroutineInfoClsRef", "getCoroutineInfoClsRef", "coroutineNameClsRef", "getCoroutineNameClsRef", "debugProbesClsRef", "getDebugProbesClsRef", "debugProbesImplClsRef", "getDebugProbesImplClsRef", "debugProbesImplInstance", "Lcom/sun/jdi/ObjectReference;", "getDebugProbesImplInstance", "()Lcom/sun/jdi/ObjectReference;", "declaringClassFieldRef", "Lcom/sun/jdi/Field;", "getDeclaringClassFieldRef", "()Lcom/sun/jdi/Field;", "dumpMethod", "Lcom/sun/jdi/Method;", "getDumpMethod", "()Lcom/sun/jdi/Method;", "enhanceStackTraceWithThreadDumpRef", "getEnhanceStackTraceWithThreadDumpRef", "fileNameFieldRef", "getFileNameFieldRef", "getContextElement", "getGetContextElement", "getContextRef", "getGetContextRef", "getNameRef", "getGetNameRef", "getRef", "getGetRef", "getStateRef", "getGetStateRef", "instance", "getInstance", "keyFieldRef", "kotlin.jvm.PlatformType", "getKeyFieldRef", "keyFieldValueRef", "getKeyFieldValueRef", "lastObservedFrameFieldRef", "getLastObservedFrameFieldRef", "lastObservedStackTraceRef", "getLastObservedStackTraceRef", "lastObservedThreadFieldRef", "getLastObservedThreadFieldRef", "lineNumberFieldRef", "getLineNumberFieldRef", "listClsRef", "getListClsRef", "methodNameFieldRef", "getMethodNameFieldRef", "sequenceNumberFieldRef", "getSequenceNumberFieldRef", "sizeRef", "getSizeRef", "stackTraceElementClsRef", "getStackTraceElementClsRef", "toString", "getToString", "jvm-debugger-coroutine"})
    public static final class ProcessReferences {
        @NotNull
        private final ClassType debugProbesClsRef;
        @NotNull
        private final ClassType debugProbesImplClsRef;
        @NotNull
        private final ClassType coroutineNameClsRef;
        @NotNull
        private final ClassType classClsRef;
        @NotNull
        private final ObjectReference debugProbesImplInstance;
        @NotNull
        private final Method enhanceStackTraceWithThreadDumpRef;
        @NotNull
        private final Method dumpMethod;
        @NotNull
        private final ObjectReference instance;
        @NotNull
        private final ClassType coroutineInfoClsRef;
        @NotNull
        private final InterfaceType coroutineContextClsRef;
        @NotNull
        private final Method getStateRef;
        @NotNull
        private final Method getContextRef;
        @NotNull
        private final Field sequenceNumberFieldRef;
        @NotNull
        private final Method lastObservedStackTraceRef;
        @NotNull
        private final Method getContextElement;
        @NotNull
        private final Method getNameRef;
        private final Field keyFieldRef;
        @NotNull
        private final Method toString;
        @NotNull
        private final Field lastObservedThreadFieldRef;
        @NotNull
        private final Field lastObservedFrameFieldRef;
        @NotNull
        private final InterfaceType listClsRef;
        @NotNull
        private final Method sizeRef;
        @NotNull
        private final Method getRef;
        @NotNull
        private final ClassType stackTraceElementClsRef;
        @NotNull
        private final Field methodNameFieldRef;
        @NotNull
        private final Field declaringClassFieldRef;
        @NotNull
        private final Field fileNameFieldRef;
        @NotNull
        private final Field lineNumberFieldRef;
        @NotNull
        private final ObjectReference keyFieldValueRef;

        @NotNull
        public final ClassType getDebugProbesClsRef() {
            return this.debugProbesClsRef;
        }

        @NotNull
        public final ClassType getDebugProbesImplClsRef() {
            return this.debugProbesImplClsRef;
        }

        @NotNull
        public final ClassType getCoroutineNameClsRef() {
            return this.coroutineNameClsRef;
        }

        @NotNull
        public final ClassType getClassClsRef() {
            return this.classClsRef;
        }

        @NotNull
        public final ObjectReference getDebugProbesImplInstance() {
            return this.debugProbesImplInstance;
        }

        @NotNull
        public final Method getEnhanceStackTraceWithThreadDumpRef() {
            return this.enhanceStackTraceWithThreadDumpRef;
        }

        @NotNull
        public final Method getDumpMethod() {
            return this.dumpMethod;
        }

        @NotNull
        public final ObjectReference getInstance() {
            return this.instance;
        }

        @NotNull
        public final ClassType getCoroutineInfoClsRef() {
            return this.coroutineInfoClsRef;
        }

        @NotNull
        public final InterfaceType getCoroutineContextClsRef() {
            return this.coroutineContextClsRef;
        }

        @NotNull
        public final Method getGetStateRef() {
            return this.getStateRef;
        }

        @NotNull
        public final Method getGetContextRef() {
            return this.getContextRef;
        }

        @NotNull
        public final Field getSequenceNumberFieldRef() {
            return this.sequenceNumberFieldRef;
        }

        @NotNull
        public final Method getLastObservedStackTraceRef() {
            return this.lastObservedStackTraceRef;
        }

        @NotNull
        public final Method getGetContextElement() {
            return this.getContextElement;
        }

        @NotNull
        public final Method getGetNameRef() {
            return this.getNameRef;
        }

        public final Field getKeyFieldRef() {
            return this.keyFieldRef;
        }

        @NotNull
        public final Method getToString() {
            return this.toString;
        }

        @NotNull
        public final Field getLastObservedThreadFieldRef() {
            return this.lastObservedThreadFieldRef;
        }

        @NotNull
        public final Field getLastObservedFrameFieldRef() {
            return this.lastObservedFrameFieldRef;
        }

        @NotNull
        public final InterfaceType getListClsRef() {
            return this.listClsRef;
        }

        @NotNull
        public final Method getSizeRef() {
            return this.sizeRef;
        }

        @NotNull
        public final Method getGetRef() {
            return this.getRef;
        }

        @NotNull
        public final ClassType getStackTraceElementClsRef() {
            return this.stackTraceElementClsRef;
        }

        @NotNull
        public final Field getMethodNameFieldRef() {
            return this.methodNameFieldRef;
        }

        @NotNull
        public final Field getDeclaringClassFieldRef() {
            return this.declaringClassFieldRef;
        }

        @NotNull
        public final Field getFileNameFieldRef() {
            return this.fileNameFieldRef;
        }

        @NotNull
        public final Field getLineNumberFieldRef() {
            return this.lineNumberFieldRef;
        }

        @NotNull
        public final ObjectReference getKeyFieldValueRef() {
            return this.keyFieldValueRef;
        }

        public ProcessReferences(@NotNull ExecutionContext executionContext) {
            ObjectReference objectReference;
            Intrinsics.checkParameterIsNotNull((Object)executionContext, (String)"executionContext");
            ReferenceType referenceType = ExecutionContext.findClass$default(executionContext, "kotlinx.coroutines.debug.DebugProbes", null, 2, null);
            if (referenceType == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            this.debugProbesClsRef = (ClassType)referenceType;
            ReferenceType referenceType2 = ExecutionContext.findClass$default(executionContext, "kotlinx.coroutines.debug.internal.DebugProbesImpl", null, 2, null);
            if (referenceType2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            this.debugProbesImplClsRef = (ClassType)referenceType2;
            ReferenceType referenceType3 = ExecutionContext.findClass$default(executionContext, "kotlinx.coroutines.CoroutineName", null, 2, null);
            if (referenceType3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            this.coroutineNameClsRef = (ClassType)referenceType3;
            ReferenceType referenceType4 = ExecutionContext.findClass$default(executionContext, "java.lang.Object", null, 2, null);
            if (referenceType4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            this.classClsRef = (ClassType)referenceType4;
            ClassType classType = this.debugProbesImplClsRef;
            ProcessReferences processReferences2 = this;
            boolean bl = false;
            boolean bl2 = false;
            ClassType $this$with = classType;
            boolean bl3 = false;
            Value value2 = $this$with.getValue($this$with.fieldByName("INSTANCE"));
            if (value2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            }
            processReferences2.debugProbesImplInstance = objectReference = (ObjectReference)value2;
            List<Method> list2 = this.debugProbesImplClsRef.methodsByName("enhanceStackTraceWithThreadDump");
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"debugProbesImplClsRef\n  \u2026tackTraceWithThreadDump\")");
            Object object = CollectionsKt.single(list2);
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"debugProbesImplClsRef\n  \u2026WithThreadDump\").single()");
            this.enhanceStackTraceWithThreadDumpRef = (Method)object;
            Method method = this.debugProbesClsRef.concreteMethodByName("dumpCoroutinesInfo", "()Ljava/util/List;");
            Intrinsics.checkExpressionValueIsNotNull((Object)method, (String)"debugProbesClsRef.concre\u2026o\", \"()Ljava/util/List;\")");
            this.dumpMethod = method;
            classType = this.debugProbesClsRef;
            processReferences2 = this;
            bl = false;
            bl2 = false;
            $this$with = classType;
            boolean bl4 = false;
            Value value3 = $this$with.getValue($this$with.fieldByName("INSTANCE"));
            if (value3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            }
            processReferences2.instance = objectReference = (ObjectReference)value3;
            ReferenceType referenceType5 = ExecutionContext.findClass$default(executionContext, "kotlinx.coroutines.debug.CoroutineInfo", null, 2, null);
            if (referenceType5 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            this.coroutineInfoClsRef = (ClassType)referenceType5;
            ReferenceType referenceType6 = ExecutionContext.findClass$default(executionContext, "kotlin.coroutines.CoroutineContext", null, 2, null);
            if (referenceType6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.InterfaceType");
            }
            this.coroutineContextClsRef = (InterfaceType)referenceType6;
            Method method2 = this.coroutineInfoClsRef.concreteMethodByName("getState", "()Lkotlinx/coroutines/debug/State;");
            Intrinsics.checkExpressionValueIsNotNull((Object)method2, (String)"coroutineInfoClsRef.conc\u2026coroutines/debug/State;\")");
            this.getStateRef = method2;
            Method method3 = this.coroutineInfoClsRef.concreteMethodByName("getContext", "()Lkotlin/coroutines/CoroutineContext;");
            Intrinsics.checkExpressionValueIsNotNull((Object)method3, (String)"coroutineInfoClsRef.conc\u2026tines/CoroutineContext;\")");
            this.getContextRef = method3;
            Field field2 = this.coroutineInfoClsRef.fieldByName("sequenceNumber");
            Intrinsics.checkExpressionValueIsNotNull((Object)field2, (String)"coroutineInfoClsRef.fieldByName(\"sequenceNumber\")");
            this.sequenceNumberFieldRef = field2;
            List<Method> list3 = this.coroutineInfoClsRef.methodsByName("lastObservedStackTrace");
            Intrinsics.checkExpressionValueIsNotNull(list3, (String)"coroutineInfoClsRef.meth\u2026\"lastObservedStackTrace\")");
            Object object2 = CollectionsKt.single(list3);
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"coroutineInfoClsRef.meth\u2026rvedStackTrace\").single()");
            this.lastObservedStackTraceRef = (Method)object2;
            List<Method> list4 = this.coroutineContextClsRef.methodsByName("get");
            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"coroutineContextClsRef.methodsByName(\"get\")");
            Object object3 = CollectionsKt.single(list4);
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"coroutineContextClsRef.m\u2026odsByName(\"get\").single()");
            this.getContextElement = (Method)object3;
            List<Method> list5 = this.coroutineNameClsRef.methodsByName("getName");
            Intrinsics.checkExpressionValueIsNotNull(list5, (String)"coroutineNameClsRef.methodsByName(\"getName\")");
            Object object4 = CollectionsKt.single(list5);
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"coroutineNameClsRef.meth\u2026yName(\"getName\").single()");
            this.getNameRef = (Method)object4;
            this.keyFieldRef = this.coroutineNameClsRef.fieldByName("Key");
            Method method4 = this.classClsRef.concreteMethodByName("toString", "()Ljava/lang/String;");
            Intrinsics.checkExpressionValueIsNotNull((Object)method4, (String)"classClsRef.concreteMeth\u2026, \"()Ljava/lang/String;\")");
            this.toString = method4;
            Field field3 = this.coroutineInfoClsRef.fieldByName("lastObservedThread");
            Intrinsics.checkExpressionValueIsNotNull((Object)field3, (String)"coroutineInfoClsRef.fiel\u2026ame(\"lastObservedThread\")");
            this.lastObservedThreadFieldRef = field3;
            Field field4 = this.coroutineInfoClsRef.fieldByName("lastObservedFrame");
            Intrinsics.checkExpressionValueIsNotNull((Object)field4, (String)"coroutineInfoClsRef.fiel\u2026Name(\"lastObservedFrame\")");
            this.lastObservedFrameFieldRef = field4;
            ReferenceType referenceType7 = ExecutionContext.findClass$default(executionContext, "java.util.List", null, 2, null);
            if (referenceType7 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.InterfaceType");
            }
            this.listClsRef = (InterfaceType)referenceType7;
            List<Method> list6 = this.listClsRef.methodsByName("size");
            Intrinsics.checkExpressionValueIsNotNull(list6, (String)"listClsRef.methodsByName(\"size\")");
            Object object5 = CollectionsKt.single(list6);
            Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"listClsRef.methodsByName(\"size\").single()");
            this.sizeRef = (Method)object5;
            List<Method> list7 = this.listClsRef.methodsByName("get");
            Intrinsics.checkExpressionValueIsNotNull(list7, (String)"listClsRef.methodsByName(\"get\")");
            Object object6 = CollectionsKt.single(list7);
            Intrinsics.checkExpressionValueIsNotNull((Object)object6, (String)"listClsRef.methodsByName(\"get\").single()");
            this.getRef = (Method)object6;
            ReferenceType referenceType8 = ExecutionContext.findClass$default(executionContext, "java.lang.StackTraceElement", null, 2, null);
            if (referenceType8 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ClassType");
            }
            this.stackTraceElementClsRef = (ClassType)referenceType8;
            Field field5 = this.stackTraceElementClsRef.fieldByName("methodName");
            Intrinsics.checkExpressionValueIsNotNull((Object)field5, (String)"stackTraceElementClsRef.fieldByName(\"methodName\")");
            this.methodNameFieldRef = field5;
            Field field6 = this.stackTraceElementClsRef.fieldByName("declaringClass");
            Intrinsics.checkExpressionValueIsNotNull((Object)field6, (String)"stackTraceElementClsRef.\u2026dByName(\"declaringClass\")");
            this.declaringClassFieldRef = field6;
            Field field7 = this.stackTraceElementClsRef.fieldByName("fileName");
            Intrinsics.checkExpressionValueIsNotNull((Object)field7, (String)"stackTraceElementClsRef.fieldByName(\"fileName\")");
            this.fileNameFieldRef = field7;
            Field field8 = this.stackTraceElementClsRef.fieldByName("lineNumber");
            Intrinsics.checkExpressionValueIsNotNull((Object)field8, (String)"stackTraceElementClsRef.fieldByName(\"lineNumber\")");
            this.lineNumberFieldRef = field8;
            Value value4 = this.coroutineNameClsRef.getValue(this.keyFieldRef);
            if (value4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.sun.jdi.ObjectReference");
            }
            this.keyFieldValueRef = (ObjectReference)value4;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineDebugProbesProxy$Companion;", "", "()V", "DEBUG_PACKAGE", "", "jvm-debugger-coroutine"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

