/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.sequence.psi.impl;

import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtil;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.KotlinPsiUtilKt;
import org.jetbrains.kotlin.idea.debugger.sequence.psi.StreamCallChecker;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/impl/PackageBasedCallChecker;", "Lorg/jetbrains/kotlin/idea/debugger/sequence/psi/StreamCallChecker;", "supportedPackage", "", "(Ljava/lang/String;)V", "checkReceiverSupported", "", "expression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "checkResultSupported", "shouldSupportResult", "isIntermediateCall", "isSupportedType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isTerminationCall", "jvm-debugger-sequence"})
public final class PackageBasedCallChecker
implements StreamCallChecker {
    private final String supportedPackage;

    @Override
    public boolean isIntermediateCall(@NotNull KtCallExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        return this.checkReceiverSupported(expression2) && this.checkResultSupported(expression2, true);
    }

    @Override
    public boolean isTerminationCall(@NotNull KtCallExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        return this.checkReceiverSupported(expression2) && this.checkResultSupported(expression2, false);
    }

    private final boolean checkResultSupported(KtCallExpression expression2, boolean shouldSupportResult) {
        KotlinType resultType = KotlinPsiUtilKt.resolveType(expression2);
        return shouldSupportResult == this.isSupportedType(resultType);
    }

    private final boolean checkReceiverSupported(KtCallExpression expression2) {
        KotlinType receiverType2 = KotlinPsiUtilKt.receiverType(expression2);
        return receiverType2 != null && this.isSupportedType(receiverType2);
    }

    private final boolean isSupportedType(KotlinType type2) {
        String typeName = KotlinPsiUtil.INSTANCE.getTypeWithoutTypeParameters(type2);
        String string = StringUtil.getPackageName((String)typeName);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringUtil.getPackageName(typeName)");
        return StringsKt.startsWith$default((String)string, (String)this.supportedPackage, (boolean)false, (int)2, null);
    }

    public PackageBasedCallChecker(@NotNull String supportedPackage) {
        Intrinsics.checkParameterIsNotNull((Object)supportedPackage, (String)"supportedPackage");
        this.supportedPackage = supportedPackage;
    }

    @Override
    public boolean isStreamCall(@NotNull KtCallExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        return StreamCallChecker.DefaultImpls.isStreamCall(this, expression2);
    }
}

