/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinStepActionFactory;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinStepOverInlineFilter;
import org.jetbrains.kotlin.idea.debugger.stepping.StepOverFilterData;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0004\u0013\u0014\u0015\u0016B\u001f\b\u0002\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H&R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0001\u0004\u0017\u0018\u0019\u001a\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/Action;", "", "position", "Lcom/intellij/xdebugger/impl/XSourcePositionImpl;", "stepOverInlineData", "Lorg/jetbrains/kotlin/idea/debugger/stepping/StepOverFilterData;", "(Lcom/intellij/xdebugger/impl/XSourcePositionImpl;Lorg/jetbrains/kotlin/idea/debugger/stepping/StepOverFilterData;)V", "getPosition", "()Lcom/intellij/xdebugger/impl/XSourcePositionImpl;", "getStepOverInlineData", "()Lorg/jetbrains/kotlin/idea/debugger/stepping/StepOverFilterData;", "apply", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "RunToCursor", "StepOut", "StepOver", "StepOverInlined", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$StepOver;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$StepOut;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$RunToCursor;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$StepOverInlined;", "jvm-debugger-core"})
public abstract class Action {
    @Nullable
    private final XSourcePositionImpl position;
    @Nullable
    private final StepOverFilterData stepOverInlineData;

    public abstract void apply(@NotNull DebugProcessImpl var1, @NotNull SuspendContextImpl var2, boolean var3);

    @Nullable
    public final XSourcePositionImpl getPosition() {
        return this.position;
    }

    @Nullable
    public final StepOverFilterData getStepOverInlineData() {
        return this.stepOverInlineData;
    }

    private Action(XSourcePositionImpl position2, StepOverFilterData stepOverInlineData) {
        this.position = position2;
        this.stepOverInlineData = stepOverInlineData;
    }

    /* synthetic */ Action(XSourcePositionImpl xSourcePositionImpl, StepOverFilterData stepOverFilterData, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            xSourcePositionImpl = null;
        }
        if ((n & 2) != 0) {
            stepOverFilterData = null;
        }
        this(xSourcePositionImpl, stepOverFilterData);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$StepOver;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action;", "()V", "apply", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "jvm-debugger-core"})
    public static final class StepOver
    extends Action {
        @Override
        public void apply(@NotNull DebugProcessImpl debugProcess, @NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
            Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
            debugProcess.createStepOverCommand(suspendContext, ignoreBreakpoints).contextAction(suspendContext);
        }

        public StepOver() {
            super(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$StepOut;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action;", "()V", "apply", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "jvm-debugger-core"})
    public static final class StepOut
    extends Action {
        @Override
        public void apply(@NotNull DebugProcessImpl debugProcess, @NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
            Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
            debugProcess.createStepOutCommand(suspendContext).contextAction(suspendContext);
        }

        public StepOut() {
            super(null, null, 3, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$RunToCursor;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action;", "position", "Lcom/intellij/xdebugger/impl/XSourcePositionImpl;", "(Lcom/intellij/xdebugger/impl/XSourcePositionImpl;)V", "apply", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "jvm-debugger-core"})
    public static final class RunToCursor
    extends Action {
        @Override
        public void apply(@NotNull DebugProcessImpl debugProcess, @NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
            Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
            ((DebugProcessImpl.ResumeCommand)ApplicationUtilsKt.runReadAction((Function0)new Function0<DebugProcessImpl.ResumeCommand>(this, debugProcess, suspendContext, ignoreBreakpoints){
                final /* synthetic */ RunToCursor this$0;
                final /* synthetic */ DebugProcessImpl $debugProcess;
                final /* synthetic */ SuspendContextImpl $suspendContext;
                final /* synthetic */ boolean $ignoreBreakpoints;

                @NotNull
                public final DebugProcessImpl.ResumeCommand invoke() {
                    XSourcePositionImpl xSourcePositionImpl = this.this$0.getPosition();
                    if (xSourcePositionImpl == null) {
                        Intrinsics.throwNpe();
                    }
                    return this.$debugProcess.createRunToCursorCommand(this.$suspendContext, (XSourcePosition)xSourcePositionImpl, this.$ignoreBreakpoints);
                }
                {
                    this.this$0 = runToCursor;
                    this.$debugProcess = debugProcessImpl;
                    this.$suspendContext = suspendContextImpl;
                    this.$ignoreBreakpoints = bl;
                    super(0);
                }
            })).contextAction(suspendContext);
        }

        public RunToCursor(@NotNull XSourcePositionImpl position2) {
            Intrinsics.checkParameterIsNotNull((Object)position2, (String)"position");
            super(position2, null, 2, null);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/Action$StepOverInlined;", "Lorg/jetbrains/kotlin/idea/debugger/stepping/Action;", "stepOverInlineData", "Lorg/jetbrains/kotlin/idea/debugger/stepping/StepOverFilterData;", "(Lorg/jetbrains/kotlin/idea/debugger/stepping/StepOverFilterData;)V", "apply", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "ignoreBreakpoints", "", "jvm-debugger-core"})
    public static final class StepOverInlined
    extends Action {
        @Override
        public void apply(@NotNull DebugProcessImpl debugProcess, @NotNull SuspendContextImpl suspendContext, boolean ignoreBreakpoints) {
            Intrinsics.checkParameterIsNotNull((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkParameterIsNotNull((Object)suspendContext, (String)"suspendContext");
            KotlinStepActionFactory kotlinStepActionFactory = new KotlinStepActionFactory(debugProcess);
            Project project2 = debugProcess.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"debugProcess.project");
            StepOverFilterData stepOverFilterData = this.getStepOverInlineData();
            if (stepOverFilterData == null) {
                Intrinsics.throwNpe();
            }
            kotlinStepActionFactory.createKotlinStepOverInlineAction(new KotlinStepOverInlineFilter(project2, stepOverFilterData)).contextAction(suspendContext);
        }

        public StepOverInlined(@NotNull StepOverFilterData stepOverInlineData) {
            Intrinsics.checkParameterIsNotNull((Object)stepOverInlineData, (String)"stepOverInlineData");
            super(null, stepOverInlineData, 1, null);
        }
    }
}

