/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.DebuggerUtilKt;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinSuspendCallStepOverFilterKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\nH\u0016J\u001a\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinSuspendCallStepOverFilter;", "Lcom/intellij/debugger/engine/MethodFilter;", "line", "", "file", "Lcom/intellij/psi/PsiFile;", "ignoreBreakpoints", "", "(ILcom/intellij/psi/PsiFile;Z)V", "getCallingExpressionLines", "Lcom/intellij/util/Range;", "locationMatches", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "onReached", "context", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "hint", "Lcom/intellij/debugger/engine/RequestHint;", "jvm-debugger-core"})
public final class KotlinSuspendCallStepOverFilter
implements MethodFilter {
    private final int line;
    private final PsiFile file;
    private final boolean ignoreBreakpoints;

    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return new Range((Comparable)Integer.valueOf(this.line), (Comparable)Integer.valueOf(this.line));
    }

    public boolean locationMatches(@NotNull DebugProcessImpl process2, @Nullable Location location2) {
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        return location2 != null && DebuggerUtilKt.isOnSuspendReturnOrReenter(location2);
    }

    public int onReached(@NotNull SuspendContextImpl context2, @NotNull RequestHint hint) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)hint, (String)"hint");
        Object object = context2.getFrameProxy();
        if (object == null || (object = object.location()) == null) {
            return 0;
        }
        Object location2 = object;
        Integer n = DebuggerUtilKt.suspendFunctionFirstLineLocation((Location)location2);
        if (n == null) {
            return 0;
        }
        int suspendStartLineNumber = n;
        DebugProcessImpl debugProcessImpl = context2.getDebugProcess();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
        DebugProcessImpl debugProcess = debugProcessImpl;
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)debugProcess.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getIns\u2026eEx(debugProcess.project)");
        BreakpointManager breakpointManager = debuggerManagerEx.getBreakpointManager();
        Intrinsics.checkExpressionValueIsNotNull((Object)breakpointManager, (String)"DebuggerManagerEx.getIns\u2026roject).breakpointManager");
        BreakpointManager breakpointManager2 = breakpointManager;
        breakpointManager2.applyThreadFilter(debugProcess, null);
        KotlinSuspendCallStepOverFilterKt.access$createRunToCursorBreakpoint(context2, suspendStartLineNumber - 1, this.file, this.ignoreBreakpoints);
        return -100;
    }

    public KotlinSuspendCallStepOverFilter(int line, @NotNull PsiFile file2, boolean ignoreBreakpoints) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.line = line;
        this.file = file2;
        this.ignoreBreakpoints = ignoreBreakpoints;
    }
}

