/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.common;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiManager;
import com.intellij.psi.compiled.ClassFileDecompilers;
import java.io.IOException;
import java.util.ArrayList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.KotlinDecompiledFileViewProvider;
import org.jetbrains.kotlin.idea.decompiler.KtDecompiledFile;
import org.jetbrains.kotlin.idea.decompiler.common.FileWithMetadata;
import org.jetbrains.kotlin.idea.decompiler.common.IncompatibleAbiVersionKt;
import org.jetbrains.kotlin.idea.decompiler.common.KotlinMetadataDecompiler;
import org.jetbrains.kotlin.idea.decompiler.common.KotlinMetadataDeserializerForDecompiler;
import org.jetbrains.kotlin.idea.decompiler.common.KotlinMetadataStubBuilder;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.BuildDecompiledTextKt;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DecompiledText;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.serialization.SerializerExtensionProtocol;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003BG\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001bH\u0002J \u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0019H\u0016J\b\u0010$\u001a\u00020\u0011H\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001a\u001a\u00020\u001bH&J\u001e\u0010)\u001a\u0004\u0018\u00010&2\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010*\u001a\u0004\u0018\u00010(H\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/common/KotlinMetadataDecompiler;", "V", "Lorg/jetbrains/kotlin/metadata/deserialization/BinaryVersion;", "Lcom/intellij/psi/compiled/ClassFileDecompilers$Full;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "serializerProtocol", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/serialization/SerializerExtensionProtocol;", "flexibleTypeDeserializer", "Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;", "expectedBinaryVersion", "invalidBinaryVersion", "stubVersion", "", "(Lcom/intellij/openapi/fileTypes/FileType;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/serialization/deserialization/FlexibleTypeDeserializer;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;I)V", "metadataStubBuilder", "Lorg/jetbrains/kotlin/idea/decompiler/common/KotlinMetadataStubBuilder;", "renderer", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "getRenderer", "()Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "renderer$delegate", "Lkotlin/Lazy;", "accepts", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "buildDecompiledText", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;", "virtualFile", "createFileViewProvider", "Lcom/intellij/psi/FileViewProvider;", "manager", "Lcom/intellij/psi/PsiManager;", "physical", "getStubBuilder", "readFile", "Lorg/jetbrains/kotlin/idea/decompiler/common/FileWithMetadata;", "bytes", "", "readFileSafely", "content", "idea-core"})
public abstract class KotlinMetadataDecompiler<V extends BinaryVersion>
extends ClassFileDecompilers.Full {
    private final KotlinMetadataStubBuilder metadataStubBuilder;
    private final Lazy renderer$delegate;
    private final FileType fileType;
    private final Function0<SerializerExtensionProtocol> serializerProtocol;
    private final FlexibleTypeDeserializer flexibleTypeDeserializer;
    private final Function0<V> expectedBinaryVersion;
    private final Function0<V> invalidBinaryVersion;

    private final DescriptorRenderer getRenderer() {
        Lazy lazy = this.renderer$delegate;
        KotlinMetadataDecompiler kotlinMetadataDecompiler = this;
        Object var3_3 = null;
        boolean bl = false;
        return (DescriptorRenderer)lazy.getValue();
    }

    @Nullable
    public abstract FileWithMetadata readFile(@NotNull byte[] var1, @NotNull VirtualFile var2);

    public boolean accepts(@NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        return Intrinsics.areEqual((Object)file2.getFileType(), (Object)this.fileType);
    }

    @NotNull
    public KotlinMetadataStubBuilder getStubBuilder() {
        return this.metadataStubBuilder;
    }

    @NotNull
    public FileViewProvider createFileViewProvider(@NotNull VirtualFile file2, @NotNull PsiManager manager, boolean physical) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        return (FileViewProvider)new KotlinDecompiledFileViewProvider(manager, file2, physical, (Function1<? super KotlinDecompiledFileViewProvider, ? extends KtDecompiledFile>)((Function1)new Function1<KotlinDecompiledFileViewProvider, KtDecompiledFile>(this){
            final /* synthetic */ KotlinMetadataDecompiler this$0;

            @Nullable
            public final KtDecompiledFile invoke(@NotNull KotlinDecompiledFileViewProvider provider2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)provider2), (String)"provider");
                VirtualFile virtualFile2 = provider2.getVirtualFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"provider.virtualFile");
                return KotlinMetadataDecompiler.readFileSafely$default(this.this$0, virtualFile2, null, 2, null) == null ? null : new KtDecompiledFile(provider2, (Function1<? super VirtualFile, DecompiledText>)((Function1)new Function1<VirtualFile, DecompiledText>(this.this$0){

                    @NotNull
                    public final DecompiledText invoke(@NotNull VirtualFile p1) {
                        Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                        return KotlinMetadataDecompiler.access$buildDecompiledText((KotlinMetadataDecompiler)((Object)this.receiver), p1);
                    }

                    public final KDeclarationContainer getOwner() {
                        return Reflection.getOrCreateKotlinClass(KotlinMetadataDecompiler.class);
                    }

                    public final String getName() {
                        return "buildDecompiledText";
                    }

                    public final String getSignature() {
                        return "buildDecompiledText(Lcom/intellij/openapi/vfs/VirtualFile;)Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DecompiledText;";
                    }
                }));
            }
            {
                this.this$0 = kotlinMetadataDecompiler;
                super(1);
            }
        }));
    }

    private final FileWithMetadata readFileSafely(VirtualFile file2, byte[] content2) {
        FileWithMetadata fileWithMetadata;
        if (!file2.isValid()) {
            return null;
        }
        try {
            byte[] byArray = content2;
            if (content2 == null) {
                byte[] byArray2 = file2.contentsToByteArray(false);
                byArray = byArray2;
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"file.contentsToByteArray(false)");
            }
            fileWithMetadata = this.readFile(byArray, file2);
        }
        catch (IOException e) {
            fileWithMetadata = null;
        }
        return fileWithMetadata;
    }

    static /* synthetic */ FileWithMetadata readFileSafely$default(KotlinMetadataDecompiler kotlinMetadataDecompiler, VirtualFile virtualFile2, byte[] byArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: readFileSafely");
        }
        if ((n & 2) != 0) {
            byArray = null;
        }
        return kotlinMetadataDecompiler.readFileSafely(virtualFile2, byArray);
    }

    private final DecompiledText buildDecompiledText(VirtualFile virtualFile2) {
        DecompiledText decompiledText2;
        if (Intrinsics.areEqual((Object)virtualFile2.getFileType(), (Object)this.fileType) ^ true) {
            String string = "Unexpected file type " + virtualFile2.getFileType();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        FileWithMetadata file2 = KotlinMetadataDecompiler.readFileSafely$default(this, virtualFile2, null, 2, null);
        FileWithMetadata fileWithMetadata = file2;
        if (fileWithMetadata == null) {
            decompiledText2 = IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)this.expectedBinaryVersion.invoke(), (BinaryVersion)this.invalidBinaryVersion.invoke());
        } else if (fileWithMetadata instanceof FileWithMetadata.Incompatible) {
            decompiledText2 = IncompatibleAbiVersionKt.createIncompatibleAbiVersionDecompiledText((BinaryVersion)this.expectedBinaryVersion.invoke(), ((FileWithMetadata.Incompatible)file2).getVersion());
        } else if (fileWithMetadata instanceof FileWithMetadata.Compatible) {
            FqName packageFqName = ((FileWithMetadata.Compatible)file2).getPackageFqName();
            KotlinMetadataDeserializerForDecompiler resolver = new KotlinMetadataDeserializerForDecompiler(packageFqName, ((FileWithMetadata.Compatible)file2).getProto(), ((FileWithMetadata.Compatible)file2).getNameResolver(), ((FileWithMetadata.Compatible)file2).getVersion(), (SerializerExtensionProtocol)this.serializerProtocol.invoke(), this.flexibleTypeDeserializer);
            boolean bl = false;
            ArrayList declarations2 = new ArrayList();
            declarations2.addAll(resolver.resolveDeclarationsInFacade(packageFqName));
            for (ProtoBuf.Class classProto : ((FileWithMetadata.Compatible)file2).getClassesToDecompile()) {
                ClassId classId = NameResolverUtilKt.getClassId(((FileWithMetadata.Compatible)file2).getNameResolver(), classProto.getFqName());
                CollectionsKt.addIfNotNull(declarations2, resolver.resolveTopLevelClass(classId));
            }
            decompiledText2 = BuildDecompiledTextKt.buildDecompiledText$default(packageFqName, declarations2, this.getRenderer(), null, 8, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return decompiledText2;
    }

    public KotlinMetadataDecompiler(@NotNull FileType fileType, @NotNull Function0<? extends SerializerExtensionProtocol> serializerProtocol, @NotNull FlexibleTypeDeserializer flexibleTypeDeserializer, @NotNull Function0<? extends V> expectedBinaryVersion, @NotNull Function0<? extends V> invalidBinaryVersion, int stubVersion) {
        Intrinsics.checkParameterIsNotNull((Object)fileType, (String)"fileType");
        Intrinsics.checkParameterIsNotNull(serializerProtocol, (String)"serializerProtocol");
        Intrinsics.checkParameterIsNotNull((Object)flexibleTypeDeserializer, (String)"flexibleTypeDeserializer");
        Intrinsics.checkParameterIsNotNull(expectedBinaryVersion, (String)"expectedBinaryVersion");
        Intrinsics.checkParameterIsNotNull(invalidBinaryVersion, (String)"invalidBinaryVersion");
        this.fileType = fileType;
        this.serializerProtocol = serializerProtocol;
        this.flexibleTypeDeserializer = flexibleTypeDeserializer;
        this.expectedBinaryVersion = expectedBinaryVersion;
        this.invalidBinaryVersion = invalidBinaryVersion;
        this.metadataStubBuilder = new KotlinMetadataStubBuilder(stubVersion, this.fileType, this.serializerProtocol, (Function2<? super VirtualFile, ? super byte[], ? extends FileWithMetadata>)((Function2)new Function2<VirtualFile, byte[], FileWithMetadata>(this){

            @Nullable
            public final FileWithMetadata invoke(@NotNull VirtualFile p1, @Nullable byte[] p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                return KotlinMetadataDecompiler.access$readFileSafely((KotlinMetadataDecompiler)((Object)this.receiver), p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(KotlinMetadataDecompiler.class);
            }

            public final String getName() {
                return "readFileSafely";
            }

            public final String getSignature() {
                return "readFileSafely(Lcom/intellij/openapi/vfs/VirtualFile;[B)Lorg/jetbrains/kotlin/idea/decompiler/common/FileWithMetadata;";
            }
        }));
        this.renderer$delegate = LazyKt.lazy((Function0)renderer.2.INSTANCE);
    }

    public static final /* synthetic */ DecompiledText access$buildDecompiledText(KotlinMetadataDecompiler $this, VirtualFile virtualFile2) {
        return $this.buildDecompiledText(virtualFile2);
    }

    public static final /* synthetic */ FileWithMetadata access$readFileSafely(KotlinMetadataDecompiler $this, VirtualFile file2, byte[] content2) {
        return $this.readFileSafely(file2, content2);
    }
}

