/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinStringTemplateBackspaceHandler;", "Lcom/intellij/codeInsight/editorActions/BackspaceHandlerDelegate;", "()V", "beforeCharDeleted", "", "c", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "charDeleted", "", "idea"})
public final class KotlinStringTemplateBackspaceHandler
extends BackspaceHandlerDelegate {
    public void beforeCharDeleted(char c, @NotNull PsiFile file2, @NotNull Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        if (c != '{' || !(file2 instanceof KtFile) || !CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return;
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        int offset2 = caretModel.getOffset();
        EditorHighlighter editorHighlighter = ((EditorEx)editor2).getHighlighter();
        Intrinsics.checkExpressionValueIsNotNull((Object)editorHighlighter, (String)"(editor as EditorEx).highlighter");
        EditorHighlighter highlighter = editorHighlighter;
        HighlighterIterator highlighterIterator = highlighter.createIterator(offset2);
        Intrinsics.checkExpressionValueIsNotNull((Object)highlighterIterator, (String)"highlighter.createIterator(offset)");
        HighlighterIterator iterator2 = highlighterIterator;
        if (Intrinsics.areEqual((Object)iterator2.getTokenType(), (Object)((Object)KtTokens.LONG_TEMPLATE_ENTRY_END)) ^ true) {
            return;
        }
        iterator2.retreat();
        if (Intrinsics.areEqual((Object)iterator2.getTokenType(), (Object)((Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) ^ true) {
            return;
        }
        ((EditorEx)editor2).getDocument().deleteString(offset2, offset2 + 1);
    }

    public boolean charDeleted(char c, @NotNull PsiFile file2, @NotNull Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
        return false;
    }
}

