/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinFormatterUsageCollector;
import org.jetbrains.kotlin.idea.formatter.KotlinFormatterUsageCollector$Companion$WhenMappings;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider;
import org.jetbrains.kotlin.idea.formatter.KotlinObsoleteCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;
import org.jetbrains.kotlin.idea.formatter.KtCodeStyleSettingsKt;
import org.jetbrains.kotlin.idea.util.FormatterUtilKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "()V", "getDefaultCodeStyle", "", "project", "Lcom/intellij/openapi/project/Project;", "getGroupId", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "getVersion", "", "Companion", "KotlinFormatterKind", "idea"})
public final class KotlinFormatterUsageCollector
extends ProjectUsagesCollector {
    private static final CommonCodeStyleSettings KOTLIN_DEFAULT_COMMON;
    private static final Lazy KOTLIN_DEFAULT_CUSTOM$delegate;
    private static final CommonCodeStyleSettings KOTLIN_OBSOLETE_DEFAULT_COMMON;
    private static final Lazy KOTLIN_OBSOLETE_DEFAULT_CUSTOM$delegate;
    public static final Companion Companion;

    @NotNull
    public String getGroupId() {
        return "kotlin.ide.formatter";
    }

    public int getVersion() {
        return 1;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        KotlinFormatterKind usedFormatter = Companion.getKotlinFormatterKind(project2);
        FeatureUsageData data2 = new FeatureUsageData().addData("kind", usedFormatter.name()).addData("defaults", this.getDefaultCodeStyle(project2));
        return SetsKt.setOf((Object)MetricEventFactoryKt.newMetric((String)"settings", (FeatureUsageData)data2));
    }

    private final String getDefaultCodeStyle(Project project2) {
        String defaults2;
        String string;
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project2);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"CodeStyle.getSettings(project)");
        CodeStyleSettings settings2 = codeStyleSettings;
        KotlinCommonCodeStyleSettings kotlinCommonSettings = KtCodeStyleSettingsKt.getKotlinCommonSettings(settings2);
        KotlinCodeStyleSettings kotlinCustomSettings = KtCodeStyleSettingsKt.getKotlinCustomSettings(settings2);
        String string2 = kotlinCustomSettings.CODE_STYLE_DEFAULTS;
        if (string2 == null) {
            string2 = kotlinCommonSettings.CODE_STYLE_DEFAULTS;
        }
        if ((string = (defaults2 = string2)) == null) {
            string = "ide_defaults";
        }
        return string;
    }

    static {
        Companion = new Companion(null);
        CommonCodeStyleSettings commonCodeStyleSettings = new KotlinLanguageCodeStyleSettingsProvider().getDefaultCommonSettings();
        boolean bl = false;
        boolean bl2 = false;
        CommonCodeStyleSettings it = commonCodeStyleSettings;
        boolean bl3 = false;
        KotlinStyleGuideCodeStyle.Companion.applyToCommonSettings$default(KotlinStyleGuideCodeStyle.Companion, it, false, 2, null);
        KOTLIN_DEFAULT_COMMON = commonCodeStyleSettings;
        KOTLIN_DEFAULT_CUSTOM$delegate = LazyKt.lazy((Function0)Companion.KOTLIN_DEFAULT_CUSTOM.2.INSTANCE);
        commonCodeStyleSettings = new KotlinLanguageCodeStyleSettingsProvider().getDefaultCommonSettings();
        bl = false;
        bl2 = false;
        it = commonCodeStyleSettings;
        boolean bl4 = false;
        KotlinObsoleteCodeStyle.Companion.applyToCommonSettings$default(KotlinObsoleteCodeStyle.Companion, it, false, 2, null);
        KOTLIN_OBSOLETE_DEFAULT_COMMON = commonCodeStyleSettings;
        KOTLIN_OBSOLETE_DEFAULT_CUSTOM$delegate = LazyKt.lazy((Function0)Companion.KOTLIN_OBSOLETE_DEFAULT_CUSTOM.2.INSTANCE);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0010\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$KotlinFormatterKind;", "", "(Ljava/lang/String;I)V", "IDEA_DEFAULT", "IDEA_CUSTOM", "IDEA_KOTLIN_WITH_CUSTOM", "IDEA_KOTLIN", "PROJECT_DEFAULT", "PROJECT_CUSTOM", "PROJECT_KOTLIN_WITH_CUSTOM", "PROJECT_KOTLIN", "IDEA_OFFICIAL_DEFAULT", "IDEA_OBSOLETE_KOTLIN", "IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM", "PROJECT_OFFICIAL_DEFAULT", "PROJECT_OBSOLETE_KOTLIN", "PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM", "idea"})
    public static final class KotlinFormatterKind
    extends Enum<KotlinFormatterKind> {
        public static final /* enum */ KotlinFormatterKind IDEA_DEFAULT;
        public static final /* enum */ KotlinFormatterKind IDEA_CUSTOM;
        public static final /* enum */ KotlinFormatterKind IDEA_KOTLIN_WITH_CUSTOM;
        public static final /* enum */ KotlinFormatterKind IDEA_KOTLIN;
        public static final /* enum */ KotlinFormatterKind PROJECT_DEFAULT;
        public static final /* enum */ KotlinFormatterKind PROJECT_CUSTOM;
        public static final /* enum */ KotlinFormatterKind PROJECT_KOTLIN_WITH_CUSTOM;
        public static final /* enum */ KotlinFormatterKind PROJECT_KOTLIN;
        public static final /* enum */ KotlinFormatterKind IDEA_OFFICIAL_DEFAULT;
        public static final /* enum */ KotlinFormatterKind IDEA_OBSOLETE_KOTLIN;
        public static final /* enum */ KotlinFormatterKind IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM;
        public static final /* enum */ KotlinFormatterKind PROJECT_OFFICIAL_DEFAULT;
        public static final /* enum */ KotlinFormatterKind PROJECT_OBSOLETE_KOTLIN;
        public static final /* enum */ KotlinFormatterKind PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM;
        private static final /* synthetic */ KotlinFormatterKind[] $VALUES;

        static {
            KotlinFormatterKind[] kotlinFormatterKindArray = new KotlinFormatterKind[14];
            KotlinFormatterKind[] kotlinFormatterKindArray2 = kotlinFormatterKindArray;
            kotlinFormatterKindArray[0] = IDEA_DEFAULT = new KotlinFormatterKind();
            kotlinFormatterKindArray[1] = IDEA_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[2] = IDEA_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[3] = IDEA_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[4] = PROJECT_DEFAULT = new KotlinFormatterKind();
            kotlinFormatterKindArray[5] = PROJECT_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[6] = PROJECT_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[7] = PROJECT_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[8] = IDEA_OFFICIAL_DEFAULT = new KotlinFormatterKind();
            kotlinFormatterKindArray[9] = IDEA_OBSOLETE_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[10] = IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[11] = PROJECT_OFFICIAL_DEFAULT = new KotlinFormatterKind();
            kotlinFormatterKindArray[12] = PROJECT_OBSOLETE_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[13] = PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            $VALUES = kotlinFormatterKindArray;
        }

        public static KotlinFormatterKind[] values() {
            return (KotlinFormatterKind[])$VALUES.clone();
        }

        public static KotlinFormatterKind valueOf(String string) {
            return Enum.valueOf(KotlinFormatterKind.class, string);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\r\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$Companion;", "", "()V", "KOTLIN_DEFAULT_COMMON", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "KOTLIN_DEFAULT_CUSTOM", "Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "getKOTLIN_DEFAULT_CUSTOM", "()Lorg/jetbrains/kotlin/idea/core/formatter/KotlinCodeStyleSettings;", "KOTLIN_DEFAULT_CUSTOM$delegate", "Lkotlin/Lazy;", "KOTLIN_OBSOLETE_DEFAULT_COMMON", "KOTLIN_OBSOLETE_DEFAULT_CUSTOM", "getKOTLIN_OBSOLETE_DEFAULT_CUSTOM", "KOTLIN_OBSOLETE_DEFAULT_CUSTOM$delegate", "getKotlinFormatterKind", "Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$KotlinFormatterKind;", "project", "Lcom/intellij/openapi/project/Project;", "paired", "kind", "isProject", "", "idea"})
    public static final class Companion {
        private final KotlinCodeStyleSettings getKOTLIN_DEFAULT_CUSTOM() {
            Lazy lazy = KOTLIN_DEFAULT_CUSTOM$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (KotlinCodeStyleSettings)((Object)lazy.getValue());
        }

        private final KotlinCodeStyleSettings getKOTLIN_OBSOLETE_DEFAULT_CUSTOM() {
            Lazy lazy = KOTLIN_OBSOLETE_DEFAULT_CUSTOM$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (KotlinCodeStyleSettings)((Object)lazy.getValue());
        }

        @NotNull
        public final KotlinFormatterKind getKotlinFormatterKind(@NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            boolean isProject = CodeStyleSettingsManager.getInstance((Project)project2).USE_PER_PROJECT_SETTINGS;
            boolean isDefaultOfficialCodeStyle2 = FormatterUtilKt.isDefaultOfficialCodeStyle();
            CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project2);
            Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"CodeStyle.getSettings(project)");
            CodeStyleSettings settings2 = codeStyleSettings;
            KotlinCommonCodeStyleSettings kotlinCommonSettings = KtCodeStyleSettingsKt.getKotlinCommonSettings(settings2);
            KotlinCodeStyleSettings kotlinCustomSettings = KtCodeStyleSettingsKt.getKotlinCustomSettings(settings2);
            boolean isDefaultKotlinCommonSettings = Intrinsics.areEqual((Object)((Object)kotlinCommonSettings), (Object)new KotlinLanguageCodeStyleSettingsProvider().getDefaultCommonSettings());
            boolean isDefaultKotlinCustomSettings = Intrinsics.areEqual((Object)((Object)kotlinCustomSettings), (Object)((Object)KotlinCodeStyleSettings.defaultSettings()));
            if (isDefaultKotlinCommonSettings && isDefaultKotlinCustomSettings) {
                return isDefaultOfficialCodeStyle2 ? this.paired(KotlinFormatterKind.IDEA_OFFICIAL_DEFAULT, isProject) : this.paired(KotlinFormatterKind.IDEA_DEFAULT, isProject);
            }
            if (Intrinsics.areEqual((Object)((Object)kotlinCommonSettings), (Object)KOTLIN_OBSOLETE_DEFAULT_COMMON) && Intrinsics.areEqual((Object)((Object)kotlinCustomSettings), (Object)((Object)this.getKOTLIN_OBSOLETE_DEFAULT_CUSTOM()))) {
                return this.paired(KotlinFormatterKind.IDEA_OBSOLETE_KOTLIN, isProject);
            }
            if (Intrinsics.areEqual((Object)((Object)kotlinCommonSettings), (Object)KOTLIN_DEFAULT_COMMON) && Intrinsics.areEqual((Object)((Object)kotlinCustomSettings), (Object)((Object)this.getKOTLIN_DEFAULT_CUSTOM()))) {
                return this.paired(KotlinFormatterKind.IDEA_KOTLIN, isProject);
            }
            CodeStyleSettings codeStyleSettings2 = settings2.clone();
            CodeStyleSettings codeStyleSettings3 = settings2;
            boolean bl = false;
            boolean bl2 = false;
            CodeStyleSettings it = codeStyleSettings2;
            boolean bl3 = false;
            CodeStyleSettings codeStyleSettings4 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings4, (String)"it");
            KotlinStyleGuideCodeStyle.Companion.apply(codeStyleSettings4);
            CodeStyleSettings codeStyleSettings5 = codeStyleSettings2;
            boolean isKotlinOfficialLikeSettings = Intrinsics.areEqual((Object)codeStyleSettings3, (Object)codeStyleSettings5);
            if (isKotlinOfficialLikeSettings) {
                return this.paired(KotlinFormatterKind.IDEA_OFFICIAL_KOTLIN_WITH_CUSTOM, isProject);
            }
            CodeStyleSettings codeStyleSettings6 = settings2.clone();
            codeStyleSettings3 = settings2;
            bl2 = false;
            boolean bl4 = false;
            CodeStyleSettings it2 = codeStyleSettings6;
            boolean bl5 = false;
            CodeStyleSettings codeStyleSettings7 = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings7, (String)"it");
            KotlinObsoleteCodeStyle.Companion.apply(codeStyleSettings7);
            codeStyleSettings5 = codeStyleSettings6;
            boolean isKotlinObsoleteLikeSettings = Intrinsics.areEqual((Object)codeStyleSettings3, (Object)codeStyleSettings5);
            if (isKotlinObsoleteLikeSettings) {
                return this.paired(KotlinFormatterKind.IDEA_KOTLIN_WITH_CUSTOM, isProject);
            }
            return this.paired(KotlinFormatterKind.IDEA_CUSTOM, isProject);
        }

        private final KotlinFormatterKind paired(KotlinFormatterKind kind2, boolean isProject) {
            KotlinFormatterKind kotlinFormatterKind;
            if (!isProject) {
                return kind2;
            }
            switch (KotlinFormatterUsageCollector$Companion$WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
                case 1: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_DEFAULT;
                    break;
                }
                case 2: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_OFFICIAL_DEFAULT;
                    break;
                }
                case 3: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_CUSTOM;
                    break;
                }
                case 4: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_KOTLIN_WITH_CUSTOM;
                    break;
                }
                case 5: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_KOTLIN;
                    break;
                }
                case 6: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_OBSOLETE_KOTLIN;
                    break;
                }
                case 7: {
                    kotlinFormatterKind = KotlinFormatterKind.PROJECT_OBSOLETE_KOTLIN_WITH_CUSTOM;
                    break;
                }
                default: {
                    kotlinFormatterKind = kind2;
                }
            }
            return kotlinFormatterKind;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

