/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework;

import com.intellij.ide.util.projectWizard.JavaModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.framework.KotlinModuleSettingStep;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.idea.framework.KotlinTemplatesFactory;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.idea.statistics.FUSEventGroups;
import org.jetbrains.kotlin.idea.statistics.KotlinFUSLogger;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ'\u0010\u0013\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0015\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J\b\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u0005H\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016J\b\u0010\u001e\u001a\u00020\u0005H\u0016J\u0012\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/idea/framework/KotlinModuleBuilder;", "Lcom/intellij/ide/util/projectWizard/JavaModuleBuilder;", "targetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "builderName", "", "builderDescription", "icon", "Ljavax/swing/Icon;", "(Lorg/jetbrains/kotlin/platform/TargetPlatform;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "getBuilderDescription", "()Ljava/lang/String;", "getBuilderName", "getIcon", "()Ljavax/swing/Icon;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/platform/TargetPlatform;", "wizardContext", "Lcom/intellij/ide/util/projectWizard/WizardContext;", "createWizardSteps", "", "Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "modulesProvider", "Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;", "(Lcom/intellij/ide/util/projectWizard/WizardContext;Lcom/intellij/openapi/roots/ui/configuration/ModulesProvider;)[Lcom/intellij/ide/util/projectWizard/ModuleWizardStep;", "getBuilderId", "getDescription", "getGroupName", "getName", "getNodeIcon", "getPresentableName", "isSuitableSdkType", "", "sdkType", "Lcom/intellij/openapi/projectRoots/SdkTypeId;", "modifySettingsStep", "settingsStep", "Lcom/intellij/ide/util/projectWizard/SettingsStep;", "setupRootModel", "", "rootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "idea-jvm"})
public final class KotlinModuleBuilder
extends JavaModuleBuilder {
    private WizardContext wizardContext;
    @NotNull
    private final TargetPlatform targetPlatform;
    @NotNull
    private final String builderName;
    @NotNull
    private final String builderDescription;
    @NotNull
    private final Icon icon;

    @NotNull
    public String getBuilderId() {
        return "kotlin.module.builder";
    }

    @NotNull
    public String getName() {
        return this.builderName;
    }

    @NotNull
    public String getPresentableName() {
        return this.builderName;
    }

    @NotNull
    public String getDescription() {
        return this.builderDescription;
    }

    @NotNull
    public Icon getNodeIcon() {
        return this.icon;
    }

    @NotNull
    public String getGroupName() {
        return KotlinTemplatesFactory.Companion.getKOTLIN_GROUP_NAME();
    }

    @Nullable
    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        Intrinsics.checkParameterIsNotNull((Object)wizardContext, (String)"wizardContext");
        Intrinsics.checkParameterIsNotNull((Object)modulesProvider, (String)"modulesProvider");
        this.wizardContext = wizardContext;
        return ModuleWizardStep.EMPTY_ARRAY;
    }

    @NotNull
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        Intrinsics.checkParameterIsNotNull((Object)settingsStep, (String)"settingsStep");
        return new KotlinModuleSettingStep(this.targetPlatform, (ModuleBuilder)this, settingsStep, this.wizardContext);
    }

    public boolean isSuitableSdkType(@Nullable SdkTypeId sdkType) {
        return JvmPlatformKt.isJvm(this.targetPlatform) ? super.isSuitableSdkType(sdkType) : sdkType instanceof KotlinSdkType;
    }

    public void setupRootModel(@NotNull ModifiableRootModel rootModel) {
        Intrinsics.checkParameterIsNotNull((Object)rootModel, (String)"rootModel");
        KotlinFUSLogger.Companion.log(FUSEventGroups.NPWizards, ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.targetPlatform);
        super.setupRootModel(rootModel);
        if (!JvmPlatformKt.isJvm(this.targetPlatform)) {
            ProjectRootUtilsKt.migrateNonJvmSourceFolders(rootModel);
        }
    }

    @NotNull
    public final TargetPlatform getTargetPlatform() {
        return this.targetPlatform;
    }

    @NotNull
    public final String getBuilderName() {
        return this.builderName;
    }

    @NotNull
    public final String getBuilderDescription() {
        return this.builderDescription;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    public KotlinModuleBuilder(@NotNull TargetPlatform targetPlatform, @NotNull String builderName, @NotNull String builderDescription, @NotNull Icon icon) {
        Intrinsics.checkParameterIsNotNull((Object)targetPlatform, (String)"targetPlatform");
        Intrinsics.checkParameterIsNotNull((Object)builderName, (String)"builderName");
        Intrinsics.checkParameterIsNotNull((Object)builderDescription, (String)"builderDescription");
        Intrinsics.checkParameterIsNotNull((Object)icon, (String)"icon");
        this.targetPlatform = targetPlatform;
        this.builderName = builderName;
        this.builderDescription = builderDescription;
        this.icon = icon;
    }
}

