/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactoryRegistrar;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.StatusBarEx;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.script.IdeScriptReportSink;
import org.jetbrains.kotlin.idea.highlighter.ScriptExternalHighlightingPass$WhenMappings;
import org.jetbrains.kotlin.idea.script.ScriptDiagnosticFixProvider;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u001c\u001dB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J$\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0015\u001a\u00020\n*\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0016\u001a\u0004\u0018\u00010\u0017*\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\u00020\n*\u00020\u00062\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "document", "Lcom/intellij/openapi/editor/Document;", "(Lorg/jetbrains/kotlin/psi/KtFile;Lcom/intellij/openapi/editor/Document;)V", "computeOffsets", "Lkotlin/Pair;", "", "position", "Lkotlin/script/experimental/api/SourceCode$Location;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "showNotification", "message", "", "coerceLineIn", "convertSeverity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "Lkotlin/script/experimental/api/ScriptDiagnostic$Severity;", "offsetBy", "line", "col", "Factory", "Registrar", "idea-core"})
public final class ScriptExternalHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    private final KtFile file;

    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkParameterIsNotNull((Object)progress2, (String)"progress");
    }

    /*
     * WARNING - void declaration
     */
    public void doApplyInformationToEditor() {
        void $this$mapTo$iv$iv;
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Document document = this.getDocument();
        if (document == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"document ?: return");
        Document document2 = document;
        if (!this.file.isScript()) {
            return;
        }
        List<ScriptDiagnostic> reports = IdeScriptReportSink.Companion.getReports(this.file);
        Iterable $this$mapNotNull$iv = reports;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<Annotation> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Annotation annotation2;
            Pair<Integer, Integer> pair2;
            ScriptDiagnostic scriptDiagnostic;
            block13: {
                block12: {
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    scriptDiagnostic = (ScriptDiagnostic)element$iv$iv;
                    boolean bl2 = false;
                    pair2 = scriptDiagnostic.getLocation();
                    if (pair2 == null) break block12;
                    Pair<Integer, Integer> pair3 = pair2;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Pair<Integer, Integer> it = pair3;
                    boolean bl5 = false;
                    pair2 = this.computeOffsets(document2, (SourceCode.Location)it);
                    if (pair2 != null) break block13;
                }
                pair2 = TuplesKt.to((Object)0, (Object)0);
            }
            Pair<Integer, Integer> pair4 = pair2;
            int n = ((Number)pair4.component1()).intValue();
            int endOffset = ((Number)pair4.component2()).intValue();
            Throwable exception = scriptDiagnostic.getException();
            String exceptionMessage = exception != null ? " (" + exception + ')' : "";
            String message2 = scriptDiagnostic.getMessage() + exceptionMessage;
            if (this.convertSeverity(scriptDiagnostic.getSeverity()) == null) {
                Annotation annotation3;
                annotation2 = annotation3 = null;
            } else {
                void startOffset;
                HighlightSeverity highlightSeverity;
                int n2;
                void var45_50;
                String string = message2;
                String string2 = message2;
                Annotation annotation4 = new Annotation((int)var45_50, n2, highlightSeverity, string2, string);
                annotation4.setFileLevelAnnotation(startOffset == endOffset);
                for (ScriptDiagnosticFixProvider provider2 : (ScriptDiagnosticFixProvider[])ScriptDiagnosticFixProvider.Companion.getEP_NAME().getExtensions()) {
                    Iterable $this$forEach$iv = provider2.provideFixes(scriptDiagnostic);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IntentionAction it = (IntentionAction)element$iv;
                        boolean bl = false;
                        annotation4.registerFix(it);
                    }
                }
                annotation2 = annotation4;
            }
            if (annotation2 == null) continue;
            Annotation annotation5 = annotation2;
            boolean bl = false;
            boolean bl6 = false;
            Annotation it$iv$iv = annotation5;
            boolean bl7 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List annotations2 = (List)destination$iv$iv;
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            element$iv$iv$iv = (Annotation)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            HighlightInfo highlightInfo = HighlightInfo.fromAnnotation((Annotation)it);
            collection.add(highlightInfo);
        }
        List infos2 = (List)destination$iv$iv2;
        Document document3 = this.myDocument;
        if (document3 == null) {
            Intrinsics.throwNpe();
        }
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)document3, (int)0, (int)this.file.getTextLength(), (Collection)infos2, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
    }

    private final Pair<Integer, Integer> computeOffsets(Document document, SourceCode.Location position2) {
        int startLine = this.coerceLineIn(position2.getStart().getLine(), document);
        int startOffset = this.offsetBy(document, startLine, position2.getStart().getCol());
        SourceCode.Position position3 = position2.getEnd();
        int endLine = position3 != null ? this.coerceLineIn(RangesKt.coerceAtLeast((int)position3.getLine(), (int)startLine), document) : startLine;
        SourceCode.Position position4 = position2.getEnd();
        int endOffset = RangesKt.coerceAtLeast((int)this.offsetBy(document, endLine, position4 != null ? position4.getCol() : document.getLineEndOffset(endLine)), (int)startOffset);
        return TuplesKt.to((Object)startOffset, (Object)endOffset);
    }

    private final int coerceLineIn(int $this$coerceLineIn, Document document) {
        return RangesKt.coerceIn((int)$this$coerceLineIn, (int)0, (int)(document.getLineCount() - 1));
    }

    private final int offsetBy(@NotNull Document $this$offsetBy, int line, int col) {
        return RangesKt.coerceIn((int)($this$offsetBy.getLineStartOffset(line) + col), (int)$this$offsetBy.getLineStartOffset(line), (int)$this$offsetBy.getLineEndOffset(line));
    }

    private final HighlightSeverity convertSeverity(@NotNull ScriptDiagnostic.Severity $this$convertSeverity) {
        HighlightSeverity highlightSeverity;
        switch (ScriptExternalHighlightingPass$WhenMappings.$EnumSwitchMapping$0[$this$convertSeverity.ordinal()]) {
            case 1: {
                highlightSeverity = HighlightSeverity.ERROR;
                break;
            }
            case 2: {
                highlightSeverity = HighlightSeverity.ERROR;
                break;
            }
            case 3: {
                highlightSeverity = HighlightSeverity.WARNING;
                break;
            }
            case 4: {
                highlightSeverity = HighlightSeverity.INFORMATION;
                break;
            }
            case 5: {
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isInternal()) {
                    highlightSeverity = HighlightSeverity.INFORMATION;
                    break;
                }
                highlightSeverity = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return highlightSeverity;
    }

    private final void showNotification(KtFile file2, String message2) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(file2, message2){
            final /* synthetic */ KtFile $file;
            final /* synthetic */ String $message;

            public final void run() {
                IdeFrame ideFrame = WindowManager.getInstance().getIdeFrame(this.$file.getProject());
                if (ideFrame != null) {
                    StatusBar statusBar = ideFrame.getStatusBar();
                    if (statusBar == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.wm.ex.StatusBarEx");
                    }
                    StatusBarEx statusBar2 = (StatusBarEx)statusBar;
                    statusBar2.notifyProgressByBalloon(MessageType.WARNING, this.$message, null, null);
                }
            }
            {
                this.$file = ktFile;
                this.$message = string;
            }
        });
    }

    public ScriptExternalHighlightingPass(@NotNull KtFile file2, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        super(file2.getProject(), document);
        this.file = file2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass$Registrar;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactoryRegistrar;", "()V", "registerHighlightingPassFactory", "", "registrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "project", "Lcom/intellij/openapi/project/Project;", "idea-core"})
    public static final class Registrar
    implements TextEditorHighlightingPassFactoryRegistrar {
        public void registerHighlightingPassFactory(@NotNull TextEditorHighlightingPassRegistrar registrar, @NotNull Project project2) {
            Intrinsics.checkParameterIsNotNull((Object)registrar, (String)"registrar");
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)new Factory(), TextEditorHighlightingPassRegistrar.Anchor.BEFORE, 1, false, false);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/ScriptExternalHighlightingPass$Factory;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "()V", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea-core"})
    public static final class Factory
    implements TextEditorHighlightingPassFactory {
        @Nullable
        public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor2) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)editor2, (String)"editor");
            if (!(file2 instanceof KtFile)) {
                return null;
            }
            KtFile ktFile = (KtFile)file2;
            Document document = editor2.getDocument();
            Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
            return new ScriptExternalHighlightingPass(ktFile, document);
        }
    }
}

