/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.ImplicitThisInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.ImplicitReceiversUtilsKt;
import org.jetbrains.kotlin.idea.util.ReceiverExpressionFactory;
import org.jetbrains.kotlin.idea.util.ScopeUtils;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ImplicitThisInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "CallFix", "CallableReferenceFix", "idea"})
public final class ImplicitThisInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        return new KtVisitorVoid(holder2){
            final /* synthetic */ ProblemsHolder $holder;

            public void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                if (expression2.getReceiverExpression() != null) {
                    return;
                }
                KtExpression ktExpression = expression2;
                KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.callableReference");
                this.handle(ktExpression, ktSimpleNameExpression, (Function1<? super String, ? extends LocalQuickFix>)((Function1)buildVisitor.visitCallableReferenceExpression.1.INSTANCE));
            }

            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                if (!(expression2 instanceof KtNameReferenceExpression)) {
                    return;
                }
                if (((KtNameReferenceExpression)expression2).getParent() instanceof KtThisExpression) {
                    return;
                }
                if (((KtNameReferenceExpression)expression2).getParent() instanceof KtCallableReferenceExpression) {
                    return;
                }
                if (this.isSelectorOfDotQualifiedExpression(expression2)) {
                    return;
                }
                PsiElement parent2 = ((KtNameReferenceExpression)expression2).getParent();
                if (parent2 instanceof KtCallExpression && this.isSelectorOfDotQualifiedExpression((KtExpression)parent2)) {
                    return;
                }
                this.handle(expression2, expression2, (Function1<? super String, ? extends LocalQuickFix>)((Function1)buildVisitor.visitSimpleNameExpression.1.INSTANCE));
            }

            private final void handle(KtExpression expression2, KtReferenceExpression reference2, Function1<? super String, ? extends LocalQuickFix> fixFactory) {
                BindingContext context2 = ResolutionUtils.analyze$default((KtElement)reference2, null, (int)1, null);
                LexicalScope lexicalScope = ScopeUtils.getResolutionScope((PsiElement)((PsiElement)reference2), (BindingContext)context2);
                if (lexicalScope == null) {
                    return;
                }
                LexicalScope scope2 = lexicalScope;
                CallableDescriptor callableDescriptor = UtilsKt.getCallableDescriptor(reference2);
                if (callableDescriptor == null) {
                    return;
                }
                CallableDescriptor descriptor2 = callableDescriptor;
                ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
                if (receiverParameterDescriptor == null) {
                    receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
                }
                if (receiverParameterDescriptor == null) {
                    return;
                }
                ReceiverParameterDescriptor receiverDescriptor = receiverParameterDescriptor;
                KotlinType kotlinType = receiverDescriptor.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverDescriptor.type");
                KotlinType receiverType2 = kotlinType;
                ReceiverExpressionFactory receiverExpressionFactory = ImplicitReceiversUtilsKt.getFactoryForImplicitReceiverWithSubtypeOf((LexicalScope)scope2, (KotlinType)receiverType2);
                if (receiverExpressionFactory == null) {
                    return;
                }
                ReceiverExpressionFactory expressionFactory = receiverExpressionFactory;
                String receiverText = expressionFactory.isImmediate() ? "this" : expressionFactory.getExpressionText();
                LocalQuickFix fix = (LocalQuickFix)fixFactory.invoke((Object)receiverText);
                this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("callable.reference.fix.family.name", receiverText), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
            }

            private final boolean isSelectorOfDotQualifiedExpression(@NotNull KtExpression $this$isSelectorOfDotQualifiedExpression) {
                PsiElement parent2 = $this$isSelectorOfDotQualifiedExpression.getParent();
                return parent2 instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)parent2).getSelectorExpression(), (Object)$this$isSelectorOfDotQualifiedExpression);
            }
            {
                this.$holder = $captured_local_variable$0;
            }
        };
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ImplicitThisInspection$CallFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "receiverText", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "idea"})
    private static final class CallFix
    implements LocalQuickFix {
        private final String receiverText;

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("callable.reference.fix.family.name", this.receiverText);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtExpression)) {
                psiElement2 = null;
            }
            KtExpression ktExpression = (KtExpression)psiElement2;
            if (ktExpression == null) {
                return;
            }
            KtExpression expression2 = ktExpression;
            KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
            PsiElement psiElement3 = expression2.getParent();
            if (!(psiElement3 instanceof KtCallExpression)) {
                psiElement3 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)psiElement3;
            KtExpression call2 = ktCallExpression != null ? (KtExpression)ktCallExpression : expression2;
            call2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, "$0.$1", new Object[]{this.receiverText, call2}, false, 4, null));
        }

        public CallFix(@NotNull String receiverText) {
            Intrinsics.checkParameterIsNotNull((Object)receiverText, (String)"receiverText");
            this.receiverText = receiverText;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ImplicitThisInspection$CallableReferenceFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "receiverText", "", "(Ljava/lang/String;)V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "idea"})
    private static final class CallableReferenceFix
    implements LocalQuickFix {
        private final String receiverText;

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("callable.reference.fix.family.name", this.receiverText);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (!(psiElement2 instanceof KtCallableReferenceExpression)) {
                psiElement2 = null;
            }
            KtCallableReferenceExpression ktCallableReferenceExpression = (KtCallableReferenceExpression)psiElement2;
            if (ktCallableReferenceExpression == null) {
                return;
            }
            KtCallableReferenceExpression expression2 = ktCallableReferenceExpression;
            KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
            KtSimpleNameExpression ktSimpleNameExpression = expression2.getCallableReference();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"expression.callableReference");
            KtSimpleNameExpression reference2 = ktSimpleNameExpression;
            expression2.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, "$0::$1", new Object[]{this.receiverText, reference2}, false, 4, null));
        }

        public CallableReferenceFix(@NotNull String receiverText) {
            Intrinsics.checkParameterIsNotNull((Object)receiverText, (String)"receiverText");
            this.receiverText = receiverText;
        }
    }
}

