/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\f\u0010\t\u001a\u00020\b*\u00020\nH\u0002\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/KotlinCovariantEqualsInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isEquals", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "idea"})
public final class KotlinCovariantEqualsInspection
extends AbstractKotlinInspection {
    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        return VisitorWrappersKt.namedFunctionVisitor((Function1<? super KtNamedFunction, Unit>)((Function1)new Function1<KtNamedFunction, Unit>(this, holder2){
            final /* synthetic */ KotlinCovariantEqualsInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtNamedFunction function2) {
                Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                if (function2.isTopLevel() || function2.isLocal()) {
                    return;
                }
                if (Intrinsics.areEqual((Object)function2.getNameAsName(), (Object)OperatorNameConventions.EQUALS) ^ true) {
                    return;
                }
                PsiElement psiElement2 = function2.getNameIdentifier();
                if (psiElement2 == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"function.nameIdentifier ?: return");
                PsiElement nameIdentifier = psiElement2;
                KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(function2);
                if (ktClassOrObject == null) {
                    return;
                }
                KtClassOrObject classOrObject = ktClassOrObject;
                if (classOrObject instanceof KtObjectDeclaration && ((KtObjectDeclaration)classOrObject).isCompanion()) {
                    return;
                }
                List<KtParameter> list2 = function2.getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"function.valueParameters");
                KtParameter ktParameter = (KtParameter)CollectionsKt.singleOrNull(list2);
                if (ktParameter == null) {
                    return;
                }
                KtParameter parameter = ktParameter;
                KtTypeReference ktTypeReference = parameter.getTypeReference();
                if (ktTypeReference == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"parameter.typeReference ?: return");
                KtTypeReference typeReference2 = ktTypeReference;
                KotlinType kotlinType = (KotlinType)ResolutionUtils.analyze((KtElement)parameter, (BodyResolveMode)BodyResolveMode.PARTIAL).get(BindingContext.TYPE, typeReference2);
                if (kotlinType == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"parameter.analyze(BodyRe\u2026 typeReference] ?: return");
                KotlinType type2 = kotlinType;
                if (KotlinBuiltIns.isNullableAny(type2)) {
                    return;
                }
                PsiElement[] psiElementArray = classOrObject.getBody();
                if (psiElementArray != null && (psiElementArray = psiElementArray.getChildren()) != null) {
                    boolean bl;
                    block13: {
                        PsiElement[] $this$any$iv = psiElementArray;
                        boolean $i$f$any = false;
                        PsiElement[] psiElementArray2 = $this$any$iv;
                        int n = psiElementArray2.length;
                        for (int j = 0; j < n; ++j) {
                            PsiElement element$iv;
                            PsiElement it = element$iv = psiElementArray2[j];
                            boolean bl2 = false;
                            PsiElement psiElement3 = it;
                            if (!(psiElement3 instanceof KtNamedFunction)) {
                                psiElement3 = null;
                            }
                            KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement3;
                            if (!(ktNamedFunction != null && KotlinCovariantEqualsInspection.access$isEquals(this.this$0, ktNamedFunction))) continue;
                            bl = true;
                            break block13;
                        }
                        bl = false;
                    }
                    if (bl) {
                        return;
                    }
                }
                this.$holder.registerProblem(nameIdentifier, KotlinBundle.message("equals.should.take.any.as.its.argument", new Object[0]), new LocalQuickFix[0]);
            }
            {
                this.this$0 = kotlinCovariantEqualsInspection;
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    private final boolean isEquals(@NotNull KtNamedFunction $this$isEquals) {
        if (!$this$isEquals.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)$this$isEquals.getNameAsName(), (Object)OperatorNameConventions.EQUALS) ^ true) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor = UtilsKt.getDescriptor($this$isEquals);
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)declarationDescriptor;
        if (functionDescriptor2 == null) {
            return false;
        }
        FunctionDescriptor descriptor2 = functionDescriptor2;
        List<ValueParameterDescriptor> list2 = descriptor2.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.valueParameters");
        Annotated annotated = (ValueParameterDescriptor)CollectionsKt.singleOrNull(list2);
        if (annotated == null || (annotated = annotated.getType()) == null || !TypeUtilsKt.isNullableAny((KotlinType)annotated)) {
            return false;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        return kotlinType != null && TypeUtilsKt.isBoolean(kotlinType);
        {
        }
    }

    public static final /* synthetic */ boolean access$isEquals(KotlinCovariantEqualsInspection $this, KtNamedFunction $this$access_u24isEquals) {
        return $this.isEquals($this$access_u24isEquals);
    }
}

