/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.synthetic.SyntheticJavaPropertyDescriptor;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RecursivePropertyAccessorInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "ReplaceWithFieldFix", "idea"})
public final class RecursivePropertyAccessorInspection
extends AbstractKotlinInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        return VisitorWrappersKt.simpleNameExpressionVisitor((Function1<? super KtSimpleNameExpression, Unit>)((Function1)new Function1<KtSimpleNameExpression, Unit>(holder2){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtSimpleNameExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                if (RecursivePropertyAccessorInspection.Companion.isRecursivePropertyAccess(expression2)) {
                    this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("recursive.property.accessor", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithFieldFix()});
                } else if (RecursivePropertyAccessorInspection.Companion.isRecursiveSyntheticPropertyAccess(expression2)) {
                    this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("recursive.synthetic.property.accessor", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RecursivePropertyAccessorInspection$ReplaceWithFieldFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    public static final class ReplaceWithFieldFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("replace.with.field.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression expression2 = (KtExpression)psiElement2;
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null);
            expression2.replace((PsiElement)factory2.createExpression("field"));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002J\u0014\u0010\f\u001a\u00020\u0004*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u0010\u001a\u00020\u0004*\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RecursivePropertyAccessorInspection$Companion;", "", "()V", "isRecursivePropertyAccess", "", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "isRecursiveSyntheticPropertyAccess", "isSameAccessor", "expression", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "isGetter", "hasObjectReceiver", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "isAssignmentTo", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "idea"})
    public static final class Companion {
        private final boolean isAssignmentTo(@Nullable KtBinaryExpression $this$isAssignmentTo, KtSimpleNameExpression expression2) {
            return $this$isAssignmentTo != null && KtPsiUtil.isAssignment((PsiElement)$this$isAssignmentTo) && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)$this$isAssignmentTo.getLeft()), (PsiElement)((PsiElement)expression2), (boolean)false);
        }

        private final boolean isSameAccessor(KtSimpleNameExpression expression2, boolean isGetter) {
            KtUnaryExpression unaryExpr;
            PsiElement $this$getStrictParentOfType$iv = (PsiElement)expression2;
            boolean $i$f$getStrictParentOfType = false;
            KtBinaryExpression binaryExpr = (KtBinaryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtBinaryExpression.class, (boolean)true);
            if (isGetter) {
                if (this.isAssignmentTo(binaryExpr, expression2)) {
                    KtBinaryExpression ktBinaryExpression = binaryExpr;
                    return KtTokens.AUGMENTED_ASSIGNMENTS.contains((IElementType)(ktBinaryExpression != null ? ktBinaryExpression.getOperationToken() : null));
                }
                return true;
            }
            if (this.isAssignmentTo(binaryExpr, expression2)) {
                return true;
            }
            PsiElement $this$getStrictParentOfType$iv2 = (PsiElement)expression2;
            boolean $i$f$getStrictParentOfType2 = false;
            KtUnaryExpression ktUnaryExpression = unaryExpr = (KtUnaryExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv2, KtUnaryExpression.class, (boolean)true);
            IElementType iElementType = ktUnaryExpression != null ? ktUnaryExpression.getOperationToken() : null;
            boolean bl = false;
            boolean bl2 = false;
            IElementType it = iElementType;
            boolean bl3 = false;
            return Intrinsics.areEqual((Object)it, (Object)((Object)KtTokens.PLUSPLUS)) || Intrinsics.areEqual((Object)it, (Object)((Object)KtTokens.MINUSMINUS));
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isRecursivePropertyAccess(@NotNull KtElement element3) {
            void $this$getParentOfType$iv;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            if (!(element3 instanceof KtSimpleNameExpression)) {
                return false;
            }
            PsiElement psiElement2 = (PsiElement)element3;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclarationWithBody.class, (boolean)strict$iv);
            if (!(psiElement3 instanceof KtPropertyAccessor)) {
                psiElement3 = null;
            }
            KtPropertyAccessor ktPropertyAccessor = (KtPropertyAccessor)psiElement3;
            if (ktPropertyAccessor == null) {
                return false;
            }
            KtPropertyAccessor propertyAccessor = ktPropertyAccessor;
            String string = ((KtSimpleNameExpression)element3).getText();
            KtProperty ktProperty = propertyAccessor.getProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktProperty, (String)"propertyAccessor.property");
            if (Intrinsics.areEqual((Object)string, (Object)ktProperty.getName()) ^ true) {
                return false;
            }
            if (((KtSimpleNameExpression)element3).getParent() instanceof KtCallableReferenceExpression) {
                return false;
            }
            BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)element3, null, (int)1, null);
            DeclarationDescriptor target = (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, element3);
            if (Intrinsics.areEqual((Object)target, (Object)bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, propertyAccessor.getProperty())) ^ true) {
                return false;
            }
            PsiElement psiElement4 = ((KtSimpleNameExpression)element3).getParent();
            if (!(psiElement4 instanceof KtQualifiedExpression)) {
                psiElement4 = null;
            }
            KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)psiElement4;
            if (ktQualifiedExpression != null) {
                KtQualifiedExpression ktQualifiedExpression2 = ktQualifiedExpression;
                boolean bl = false;
                boolean bl2 = false;
                KtQualifiedExpression it = ktQualifiedExpression2;
                boolean bl3 = false;
                String string2 = it.getReceiverExpression().getText();
                KtKeywordToken ktKeywordToken = KtTokens.THIS_KEYWORD;
                Intrinsics.checkExpressionValueIsNotNull((Object)((Object)ktKeywordToken), (String)"KtTokens.THIS_KEYWORD");
                if (Intrinsics.areEqual((Object)string2, (Object)ktKeywordToken.getValue()) ^ true && !Companion.hasObjectReceiver(it, bindingContext2)) {
                    return false;
                }
            }
            return this.isSameAccessor((KtSimpleNameExpression)element3, propertyAccessor.isGetter());
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isRecursiveSyntheticPropertyAccess(@NotNull KtElement element3) {
            void $this$getParentOfType$iv;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            if (!(element3 instanceof KtSimpleNameExpression)) {
                return false;
            }
            PsiElement psiElement2 = (PsiElement)element3;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            PsiElement psiElement3 = PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtDeclarationWithBody.class, (boolean)strict$iv);
            if (!(psiElement3 instanceof KtNamedFunction)) {
                psiElement3 = null;
            }
            KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement3;
            if (ktNamedFunction == null) {
                return false;
            }
            KtNamedFunction namedFunction = ktNamedFunction;
            String string = namedFunction.getName();
            if (string == null) {
                return false;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"namedFunction.name ?: return false");
            String name2 = string;
            String string2 = ((KtSimpleNameExpression)element3).getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"element.text");
            String referencedName = StringsKt.capitalize((String)string2);
            boolean isGetter = Intrinsics.areEqual((Object)name2, (Object)("get" + referencedName));
            boolean isSetter = Intrinsics.areEqual((Object)name2, (Object)("set" + referencedName));
            if (!isGetter && !isSetter) {
                return false;
            }
            if (((KtSimpleNameExpression)element3).getParent() instanceof KtCallableReferenceExpression) {
                return false;
            }
            BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)element3, null, (int)1, null);
            Object v = bindingContext2.get(BindingContext.REFERENCE_TARGET, element3);
            if (!(v instanceof SyntheticJavaPropertyDescriptor)) {
                v = null;
            }
            SyntheticJavaPropertyDescriptor syntheticJavaPropertyDescriptor = (SyntheticJavaPropertyDescriptor)v;
            if (syntheticJavaPropertyDescriptor == null) {
                return false;
            }
            SyntheticJavaPropertyDescriptor syntheticDescriptor = syntheticJavaPropertyDescriptor;
            DeclarationDescriptor namedFunctionDescriptor = bindingContext2.get(BindingContext.DECLARATION_TO_DESCRIPTOR, namedFunction);
            if (Intrinsics.areEqual((Object)namedFunctionDescriptor, (Object)syntheticDescriptor.getGetMethod()) ^ true && Intrinsics.areEqual((Object)namedFunctionDescriptor, (Object)syntheticDescriptor.getSetMethod()) ^ true) {
                return false;
            }
            return this.isSameAccessor((KtSimpleNameExpression)element3, isGetter);
        }

        private final boolean hasObjectReceiver(@NotNull KtQualifiedExpression $this$hasObjectReceiver, BindingContext context2) {
            KtExpression ktExpression = $this$hasObjectReceiver.getReceiverExpression();
            if (!(ktExpression instanceof KtReferenceExpression)) {
                ktExpression = null;
            }
            KtReferenceExpression ktReferenceExpression = (KtReferenceExpression)ktExpression;
            if (ktReferenceExpression == null) {
                return false;
            }
            KtReferenceExpression receiver2 = ktReferenceExpression;
            Object v = context2.get(BindingContext.REFERENCE_TARGET, receiver2);
            if (!(v instanceof ClassDescriptor)) {
                v = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)v;
            return (classDescriptor2 != null ? classDescriptor2.getKind() : null) == ClassKind.OBJECT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

