/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.CastExplicitlyFix;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/UnsafeCastFromDynamicInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "idea"})
public final class UnsafeCastFromDynamicInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly, @NotNull LocalInspectionToolSession session2) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        return VisitorWrappersKt.expressionVisitor((Function1<? super KtExpression, Unit>)((Function1)new Function1<KtExpression, Unit>(holder2){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                BindingContext context2 = ResolutionUtils.analyze((KtElement)expression2, (BodyResolveMode)BodyResolveMode.PARTIAL);
                KotlinType kotlinType = (KotlinType)context2.get(BindingContext.EXPECTED_EXPRESSION_TYPE, expression2);
                if (kotlinType == null) {
                    return;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"context[BindingContext.E\u2026PE, expression] ?: return");
                KotlinType expectedType = kotlinType;
                KotlinType kotlinType2 = CallUtilKt.getType(expression2, context2);
                if (kotlinType2 == null) {
                    return;
                }
                KotlinType actualType = kotlinType2;
                if (DynamicTypesKt.isDynamic(actualType) && !DynamicTypesKt.isDynamic(expectedType) && !TypeUtils.noExpectedType(expectedType)) {
                    this.$holder.registerProblem((PsiElement)expression2, KotlinBundle.message("implicit.unsafe.cast.from.dynamic.to.0", expectedType), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new CastExplicitlyFix(expectedType)});
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }
}

