/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.api;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModelKt;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;
import org.jetbrains.kotlin.idea.inspections.api.IncompatibleAPIInspection;

public class AddToIncompatibleApiDialog
extends DialogWrapper {
    private JPanel contentPane;
    private JTextField referenceTextField;
    private JTextField reasonTextField;
    private final Project project;

    public AddToIncompatibleApiDialog(@NotNull Project project2, @NotNull String qualifiedReference) {
        if (project2 == null) {
            AddToIncompatibleApiDialog.$$$reportNull$$$0(0);
        }
        if (qualifiedReference == null) {
            AddToIncompatibleApiDialog.$$$reportNull$$$0(1);
        }
        super(project2, true);
        this.project = project2;
        this.$$$setupUI$$$();
        this.setModal(true);
        this.setTitle(KotlinJvmBundle.message("incompatible.api.report", new Object[0]));
        this.referenceTextField.setText(qualifiedReference);
        this.init();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.reasonTextField;
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    protected void doOKAction() {
        String reference2 = this.referenceTextField.getText();
        String reason = this.reasonTextField.getText();
        reference2 = reference2 != null ? reference2.trim() : null;
        String string = reason = reason != null ? reason.trim() : null;
        if (reference2 != null && !reference2.isEmpty()) {
            String finalReference = reference2;
            String finalReason = reason == null || reason.isEmpty() ? null : reason;
            InspectionProfileModifiableModelKt.modifyAndCommitProjectProfile((Project)this.project, inspectionProfileModifiableModel -> {
                ToolsImpl toolImpl = inspectionProfileModifiableModel.getToolsOrNull("IncompatibleAPI", this.project);
                if (toolImpl != null) {
                    IncompatibleAPIInspection incompatibleAPIInspection = (IncompatibleAPIInspection)toolImpl.getDefaultState().getTool().getTool();
                    incompatibleAPIInspection.addProblem(finalReference, finalReason);
                }
            });
        }
        super.doOKAction();
    }

    public void dispose() {
        super.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "qualifiedReference";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/idea/inspections/api/AddToIncompatibleApiDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JTextField jTextField2;
        JPanel jPanel2;
        this.contentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 3, new Dimension(600, -1), null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/KotlinJvmBundle", AddToIncompatibleApiDialog.class).getString("reference"));
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.referenceTextField = jTextField2 = new JTextField();
        jPanel3.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/KotlinJvmBundle", AddToIncompatibleApiDialog.class).getString("reason"));
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.reasonTextField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int j = 0; j < string.length(); ++j) {
            if (string.charAt(j) == '&') {
                if (++j == string.length()) break;
                if (!bl && string.charAt(j) != '&') {
                    bl = true;
                    c = string.charAt(j);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(j));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

