/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.conventionNameCalls;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.ModifierChecksKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0017\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u0002H\u0016J \u0010\u001a\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u0019*\u00020\u001fH\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/inspections/conventionNameCalls/ReplaceGetOrSetInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "operatorNames", "", "Lorg/jetbrains/kotlin/name/Name;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fixText", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "inspectionText", "isApplicable", "", "moveCaret", "isSet", "newElement", "Lcom/intellij/psi/PsiElement;", "isExplicitOperator", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "idea"})
public final class ReplaceGetOrSetInspection
extends AbstractApplicabilityBasedInspection<KtDotQualifiedExpression> {
    private final Set<Name> operatorNames = SetsKt.setOf((Object[])new Name[]{OperatorNameConventions.GET, OperatorNameConventions.SET});

    private final boolean isExplicitOperator(@NotNull FunctionDescriptor $this$isExplicitOperator) {
        boolean bl;
        block5: {
            if ($this$isExplicitOperator.getOverriddenDescriptors().isEmpty()) {
                bl = !($this$isExplicitOperator.getContainingDeclaration() instanceof JavaClassDescriptor) && $this$isExplicitOperator.isOperator();
            } else {
                Collection<? extends FunctionDescriptor> collection = $this$isExplicitOperator.getOverriddenDescriptors();
                Intrinsics.checkExpressionValueIsNotNull(collection, (String)"overriddenDescriptors");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FunctionDescriptor it = (FunctionDescriptor)element$iv;
                        boolean bl2 = false;
                        FunctionDescriptor functionDescriptor2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)functionDescriptor2, (String)"it");
                        if (!this.isExplicitOperator(functionDescriptor2)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean isApplicable(@NotNull KtDotQualifiedExpression element3) {
        boolean bl;
        FunctionDescriptor target;
        BindingContext bindingContext2;
        block15: {
            Name calleeName;
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
            if (ktCallExpression == null) {
                return false;
            }
            KtCallExpression callExpression2 = ktCallExpression;
            KtExpression ktExpression = callExpression2.getCalleeExpression();
            if (!(ktExpression instanceof KtSimpleNameExpression)) {
                ktExpression = null;
            }
            KtSimpleNameExpression ktSimpleNameExpression = (KtSimpleNameExpression)ktExpression;
            Name name2 = calleeName = ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null;
            if (!CollectionsKt.contains((Iterable)this.operatorNames, (Object)calleeName)) {
                return false;
            }
            bindingContext2 = ResolutionUtils.analyze((KtElement)callExpression2, (BodyResolveMode)BodyResolveMode.PARTIAL_WITH_CFA);
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression2, bindingContext2);
            if (resolvedCall2 == null) {
                return false;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            if (!ArgumentMappingKt.isReallySuccess(resolvedCall3)) {
                return false;
            }
            CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
            if (!(callableDescriptor instanceof FunctionDescriptor)) {
                callableDescriptor = null;
            }
            FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
            if (functionDescriptor2 == null) {
                return false;
            }
            target = functionDescriptor2;
            if (!ModifierChecksKt.isValidOperator(target) || !this.operatorNames.contains(target.getName())) {
                return false;
            }
            if (callExpression2.getTypeArgumentList() != null) {
                return false;
            }
            List<KtValueArgument> list2 = callExpression2.getValueArguments();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callExpression.valueArguments");
            List<KtValueArgument> arguments2 = list2;
            if (arguments2.isEmpty()) {
                return false;
            }
            Iterable $this$any$iv = arguments2;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtValueArgument it = (KtValueArgument)element$iv;
                    boolean bl2 = false;
                    if (!it.isNamed()) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        if (!UtilsKt.isReceiverExpressionWithValue(element3)) {
            return false;
        }
        return Intrinsics.areEqual((Object)target.getName(), (Object)OperatorNameConventions.SET) ^ true || !BindingContextUtilsKt.isUsedAsExpression(element3, bindingContext2);
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return KotlinBundle.message("should.be.replaced.with.indexing", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public ProblemHighlightType inspectionHighlightType(@NotNull KtDotQualifiedExpression element3) {
        ProblemHighlightType problemHighlightType2;
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = UtilsKt.toResolvedCall(element3, BodyResolveMode.PARTIAL);
        CallableDescriptor callableDescriptor = resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor2 != null) {
            if (this.isExplicitOperator(functionDescriptor2)) {
                problemHighlightType2 = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                return problemHighlightType2;
            }
        }
        problemHighlightType2 = ProblemHighlightType.INFORMATION;
        return problemHighlightType2;
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("replace.get.or.set.call.with.indexing.operator", new Object[0]);
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
        if (ktCallExpression == null) {
            return this.getDefaultFixText();
        }
        KtCallExpression callExpression2 = ktCallExpression;
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)callExpression2, null, (int)1, null);
        if (resolvedCall2 == null) {
            return this.getDefaultFixText();
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        Object[] objectArray = new Object[1];
        String string = resolvedCall3.getResultingDescriptor().getName().asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolvedCall.resultingDescriptor.name.asString()");
        objectArray[0] = string;
        return KotlinBundle.message("replace.0.call.with.indexing.operator", objectArray);
    }

    @Override
    @Nullable
    public TextRange inspectionHighlightRangeInElement(@NotNull KtDotQualifiedExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return ExpressionExtKt.calleeTextRangeInThis(element3);
    }

    @Override
    public void applyTo(@NotNull KtDotQualifiedExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        boolean isSet = Intrinsics.areEqual((Object)UtilsKt.getCalleeName(element3), (Object)OperatorNameConventions.SET.getIdentifier());
        KtCallExpression ktCallExpression = UtilsKt.getCallExpression(element3);
        if (ktCallExpression == null) {
            Intrinsics.throwNpe();
        }
        List<KtValueArgument> list2 = ktCallExpression.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"element.callExpression!!.valueArguments");
        List<KtValueArgument> allArguments = list2;
        Collection collection = allArguments;
        boolean bl = false;
        boolean bl2 = !collection.isEmpty();
        bl = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtExpression newExpression2 = CreateByPatternKt.buildExpression$default(KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null), false, (Function1)new Function1<BuilderByPattern<KtExpression>, Unit>(element3, isSet, allArguments){
            final /* synthetic */ KtDotQualifiedExpression $element;
            final /* synthetic */ boolean $isSet;
            final /* synthetic */ List $allArguments;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull BuilderByPattern<KtExpression> $this$buildExpression) {
                Collection<KtExpression> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkParameterIsNotNull($this$buildExpression, (String)"$receiver");
                $this$buildExpression.appendExpression(this.$element.getReceiverExpression());
                $this$buildExpression.appendFixedText("[");
                List arguments2 = this.$isSet ? CollectionsKt.dropLast((List)this.$allArguments, (int)1) : this.$allArguments;
                Iterable iterable = arguments2;
                BuilderByPattern<KtExpression> builderByPattern = $this$buildExpression;
                boolean $i$f$map = false;
                void var5_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    KtValueArgument ktValueArgument = (KtValueArgument)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    KtExpression ktExpression = it.getArgumentExpression();
                    collection.add(ktExpression);
                }
                collection = (List)destination$iv$iv;
                BuilderByPattern.appendExpressions$default(builderByPattern, collection, null, 2, null);
                $this$buildExpression.appendFixedText("]");
                if (this.$isSet) {
                    $this$buildExpression.appendFixedText("=");
                    $this$buildExpression.appendExpression(((KtValueArgument)CollectionsKt.last((List)this.$allArguments)).getArgumentExpression());
                }
            }
            {
                this.$element = ktDotQualifiedExpression;
                this.$isSet = bl;
                this.$allArguments = list2;
                super(1);
            }
        }, 1, null);
        PsiElement psiElement2 = element3.replace((PsiElement)newExpression2);
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"element.replace(newExpression)");
        PsiElement newElement = psiElement2;
        if (editor2 != null) {
            this.moveCaret(editor2, isSet, newElement);
        }
    }

    private final void moveCaret(Editor editor2, boolean isSet, PsiElement newElement) {
        block4: {
            KtArrayAccessExpression ktArrayAccessExpression;
            if (isSet) {
                PsiElement $this$getChildOfType$iv = newElement;
                boolean $i$f$getChildOfType = false;
                ktArrayAccessExpression = (KtArrayAccessExpression)PsiTreeUtil.getChildOfType((PsiElement)$this$getChildOfType$iv, KtArrayAccessExpression.class);
            } else {
                PsiElement psiElement2 = newElement;
                if (!(psiElement2 instanceof KtArrayAccessExpression)) {
                    psiElement2 = null;
                }
                ktArrayAccessExpression = (KtArrayAccessExpression)psiElement2;
            }
            if (ktArrayAccessExpression == null) {
                return;
            }
            KtArrayAccessExpression arrayAccessExpression2 = ktArrayAccessExpression;
            PsiElement psiElement3 = arrayAccessExpression2.getLeftBracket();
            if (psiElement3 == null) break block4;
            int n = PsiUtilsKt.getStartOffset(psiElement3);
            boolean bl = false;
            boolean bl2 = false;
            int it = n;
            boolean bl3 = false;
            editor2.getCaretModel().moveToOffset(it);
        }
    }

    public ReplaceGetOrSetInspection() {
        super(KtDotQualifiedExpression.class);
    }
}

