/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.coroutines;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.collections.AbstractCallChainChecker;
import org.jetbrains.kotlin.idea.inspections.collections.SimplifyCallChainFix;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0007R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/RedundantAsyncInspection;", "Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractCallChainChecker;", "()V", "conversionGroups", "", "Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractCallChainChecker$ConversionId;", "", "Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractCallChainChecker$Conversion;", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "generateConversion", "expression", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "generateFix", "Lorg/jetbrains/kotlin/idea/inspections/collections/SimplifyCallChainFix;", "conversion", "Companion", "idea"})
public final class RedundantAsyncInspection
extends AbstractCallChainChecker {
    private final Map<AbstractCallChainChecker.ConversionId, List<AbstractCallChainChecker.Conversion>> conversionGroups = this.group(conversions);
    private static final List<AbstractCallChainChecker.Conversion> conversions;
    private static final String GLOBAL_SCOPE = "kotlinx.coroutines.GlobalScope";
    private static final String CONTEXT_ARGUMENT_NAME = "context";
    private static final String START_ARGUMENT_NAME = "start";
    private static final String DEFAULT_ASYNC_ARGUMENT = "kotlinx.coroutines.Dispatchers.Default";
    private static final String DEFAULT_ASYNC_ARGUMENT_EXPERIMENTAL = "kotlinx.coroutines.experimental.DefaultDispatcher";
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final AbstractCallChainChecker.Conversion generateConversion(@NotNull KtQualifiedExpression expression2) {
        KtExpression scopeExpression;
        void defaultStart;
        void defaultContext;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = null;
        AbstractCallChainChecker.Conversion conversion2 = this.findQualifiedConversion(expression2, this.conversionGroups, (Function4)new Function4<AbstractCallChainChecker.Conversion, ResolvedCall<?>, ResolvedCall<?>, BindingContext, Boolean>((Ref.ObjectRef)defaultContext, (Ref.ObjectRef)defaultStart){
            final /* synthetic */ Ref.ObjectRef $defaultContext;
            final /* synthetic */ Ref.ObjectRef $defaultStart;

            /*
             * WARNING - void declaration
             */
            public final boolean invoke(@NotNull AbstractCallChainChecker.Conversion $noName_0, @NotNull ResolvedCall<?> firstResolvedCall, @NotNull ResolvedCall<?> $noName_2, @NotNull BindingContext $noName_3) {
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                Intrinsics.checkParameterIsNotNull(firstResolvedCall, (String)"firstResolvedCall");
                Intrinsics.checkParameterIsNotNull($noName_2, (String)"<anonymous parameter 2>");
                Intrinsics.checkParameterIsNotNull((Object)$noName_3, (String)"<anonymous parameter 3>");
                Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = firstResolvedCall.getValueArguments();
                Intrinsics.checkExpressionValueIsNotNull(map2, (String)"firstResolvedCall.valueArguments");
                Object object = map2;
                boolean bl = false;
                Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = object.entrySet().iterator();
                while (iterator2.hasNext()) {
                    void parameterDescriptor;
                    Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
                    Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
                    boolean bl2 = false;
                    object = entry2.getKey();
                    entry2 = entry;
                    bl2 = false;
                    ResolvedValueArgument valueArgument = entry2.getValue();
                    boolean bl3 = valueArgument instanceof DefaultValueArgument;
                    void v1 = parameterDescriptor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"parameterDescriptor");
                    switch (v1.getName().asString()) {
                        case "context": {
                            this.$defaultContext.element = bl3;
                            break;
                        }
                        case "start": {
                            this.$defaultStart.element = bl3;
                            break;
                        }
                    }
                }
                return true;
            }
            {
                this.$defaultContext = objectRef;
                this.$defaultStart = objectRef2;
                super(4);
            }
        });
        if (conversion2 == null) {
            return null;
        }
        AbstractCallChainChecker.Conversion conversion3 = conversion2;
        Boolean bl = (Boolean)defaultContext.element;
        if (bl == null) {
            return null;
        }
        bl.booleanValue();
        Boolean bl2 = (Boolean)defaultStart.element;
        if (bl2 == null) {
            return null;
        }
        bl2.booleanValue();
        Boolean bl3 = (Boolean)defaultStart.element;
        if (bl3 == null) {
            Intrinsics.throwNpe();
        }
        if (!bl3.booleanValue()) {
            return null;
        }
        KtExpression receiverExpression = expression2.getReceiverExpression();
        KtExpression ktExpression = receiverExpression;
        if (!(ktExpression instanceof KtQualifiedExpression)) {
            ktExpression = null;
        }
        KtQualifiedExpression ktQualifiedExpression = (KtQualifiedExpression)ktExpression;
        KtExpression ktExpression2 = scopeExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
        if (scopeExpression != null) {
            FqName scopeDescriptor;
            FqName fqName2;
            Object object;
            BindingContext context2 = ResolutionUtils.analyze((KtElement)scopeExpression, (BodyResolveMode)BodyResolveMode.PARTIAL);
            KtExpression ktExpression3 = scopeExpression;
            if (!(ktExpression3 instanceof KtNameReferenceExpression)) {
                ktExpression3 = null;
            }
            KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression3;
            if (ktNameReferenceExpression != null) {
                KtNameReferenceExpression ktNameReferenceExpression2 = ktNameReferenceExpression;
                boolean bl4 = false;
                boolean bl5 = false;
                KtNameReferenceExpression it = ktNameReferenceExpression2;
                boolean bl6 = false;
                object = (DeclarationDescriptor)context2.get(BindingContext.REFERENCE_TARGET, it);
            } else {
                object = null;
            }
            if (Intrinsics.areEqual((Object)((fqName2 = (scopeDescriptor = object)) != null && (fqName2 = DescriptorUtilsKt.getFqNameSafe(fqName2)) != null ? fqName2.toString() : null), (Object)GLOBAL_SCOPE) ^ true) {
                conversion3 = conversion3.withArgument(scopeExpression.getText() + ".coroutineContext");
            }
        }
        if (conversion3.getAdditionalArgument() == null) {
            Boolean bl7 = (Boolean)defaultContext.element;
            if (bl7 == null) {
                Intrinsics.throwNpe();
            }
            if (bl7.booleanValue()) {
                Boolean bl8 = (Boolean)defaultStart.element;
                if (bl8 == null) {
                    Intrinsics.throwNpe();
                }
                if (bl8.booleanValue()) {
                    conversion3 = conversion3.withArgument(conversion3 == conversions.get(0) ? DEFAULT_ASYNC_ARGUMENT : DEFAULT_ASYNC_ARGUMENT_EXPERIMENTAL);
                }
            }
        }
        return conversion3;
    }

    @NotNull
    public final SimplifyCallChainFix generateFix(@NotNull AbstractCallChainChecker.Conversion conversion2) {
        Intrinsics.checkParameterIsNotNull((Object)conversion2, (String)"conversion");
        String contextArgument = conversion2.getAdditionalArgument();
        return new SimplifyCallChainFix(conversion2, true, true, (Function2<? super KtPsiFactory, ? super KtCallExpression, Unit>)((Function2)new Function2<KtPsiFactory, KtCallExpression, Unit>(contextArgument){
            final /* synthetic */ String $contextArgument;

            public final void invoke(@NotNull KtPsiFactory $receiver, @NotNull KtCallExpression callExpression2) {
                ResolvedCall call2;
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)callExpression2, (String)"callExpression");
                if (this.$contextArgument != null && (call2 = ResolutionUtils.resolveToCall$default((KtElement)callExpression2, null, (int)1, null)) != null) {
                    for (KtValueArgument argument2 : callExpression2.getValueArguments()) {
                        ArgumentMatch mapping2;
                        ArgumentMapping argumentMapping = call2.getArgumentMapping(argument2);
                        if (!(argumentMapping instanceof ArgumentMatch)) {
                            argumentMapping = null;
                        }
                        if ((ArgumentMatch)argumentMapping == null) {
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)mapping2.getValueParameter().getName().asString(), (Object)"context")) continue;
                        KtValueArgumentName ktValueArgumentName = argument2.getArgumentName();
                        Name name2 = ktValueArgumentName != null ? ktValueArgumentName.getAsName() : null;
                        StringBuilder stringBuilder2 = new StringBuilder().append(this.$contextArgument).append(" + ");
                        KtExpression ktExpression = argument2.getArgumentExpression();
                        if (ktExpression == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"argument.getArgumentExpression()!!");
                        String expressionText2 = stringBuilder2.append(ktExpression.getText()).toString();
                        argument2.replace((PsiElement)(name2 == null ? $receiver.createArgument(expressionText2) : $receiver.createArgument(name2 + " = " + expressionText2)));
                        break;
                    }
                }
            }
            {
                this.$contextArgument = string;
                super(2);
            }
        }));
    }

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder2, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder2, (String)"holder");
        return VisitorWrappersKt.qualifiedExpressionVisitor((Function1<? super KtQualifiedExpression, Unit>)((Function1)new Function1<KtQualifiedExpression, Unit>(this, holder2, isOnTheFly){
            final /* synthetic */ RedundantAsyncInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            public final void invoke(@NotNull KtQualifiedExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                AbstractCallChainChecker.Conversion conversion2 = this.this$0.generateConversion(expression2);
                if (conversion2 == null) {
                    return;
                }
                AbstractCallChainChecker.Conversion conversion3 = conversion2;
                InspectionManager inspectionManager = this.$holder.getManager();
                PsiElement psiElement2 = (PsiElement)expression2;
                KtExpression ktExpression = AbstractCallChainChecker.Companion.firstCalleeExpression(expression2);
                if (ktExpression == null) {
                    Intrinsics.throwNpe();
                }
                ProblemDescriptor problemDescriptor = inspectionManager.createProblemDescriptor(psiElement2, ktExpression.getTextRange().shiftRight(-PsiUtilsKt.getStartOffset((PsiElement)expression2)), String.valueOf(KotlinBundle.message("redundant.async.call.may.be.reduced.to.0", conversion3.getReplacement())), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$isOnTheFly, new LocalQuickFix[]{this.this$0.generateFix(conversion3)});
                Intrinsics.checkExpressionValueIsNotNull((Object)problemDescriptor, (String)"holder.manager.createPro\u2026conversion)\n            )");
                ProblemDescriptor descriptor2 = problemDescriptor;
                this.$holder.registerProblem(descriptor2);
            }
            {
                this.this$0 = redundantAsyncInspection;
                this.$holder = problemsHolder;
                this.$isOnTheFly = bl;
                super(1);
            }
        }));
    }

    static {
        Companion = new Companion(null);
        conversions = CollectionsKt.listOf((Object[])new AbstractCallChainChecker.Conversion[]{new AbstractCallChainChecker.Conversion("kotlinx.coroutines.async", "kotlinx.coroutines.Deferred.await", "kotlinx.coroutines.withContext", null, false, 24, null), new AbstractCallChainChecker.Conversion("kotlinx.coroutines.experimental.async", "kotlinx.coroutines.experimental.Deferred.await", "kotlinx.coroutines.experimental.withContext", null, false, 24, null)});
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/coroutines/RedundantAsyncInspection$Companion;", "", "()V", "CONTEXT_ARGUMENT_NAME", "", "DEFAULT_ASYNC_ARGUMENT", "DEFAULT_ASYNC_ARGUMENT_EXPERIMENTAL", "GLOBAL_SCOPE", "START_ARGUMENT_NAME", "conversions", "", "Lorg/jetbrains/kotlin/idea/inspections/collections/AbstractCallChainChecker$Conversion;", "idea"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

